/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ducts;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiValueField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.TypedProp;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.CompElementActions;
import ventus.actions.MerlinOpImpl;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.CompositePropertyUtil;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.feature.comps.ISelectionRibbon;
import ventus.feature.comps.SelectionRibbonHelper;
import ventus.feature.dependencies.powerlaw.PowerlawModel;
import ventus.feature.ducts.DuctFlowElement;
import ventus.feature.ducts.EditDuctFlowElementMgrOp;
import ventus.feature.ducts.Junction;
import ventus.feature.ducts.Segment;
import ventus.gui.MerlinComboBox;
import ventus.gui.MerlinUDF;
import ventus.gui.guiUtil;
import ventus.gui.value.ScheduleField;
import ventus.mv.gui.PropConnections;
import ventus.mv.gui.SelectionEditorPanel;
import ventus.util.MerlinUtil;

public class SegmentRibbon
implements ISelectionRibbon {
    private final List<SelectionEditorPanel.EditorPanel> d_sections = new ArrayList<SelectionEditorPanel.EditorPanel>();

    private void createSections() {
        guiLabel elementLbl = guiUtil.lblProp(Segment.ELEMENT);
        MerlinComboBox elementCb = new MerlinComboBox(VentusApp.getAppData(), DuctFlowElement.class, (IMerlinObj[])new DuctFlowElement[0]);
        PropConnections.ComboPropConn<DuctFlowElement> elementConn = new PropConnections.ComboPropConn<DuctFlowElement>(new CompElementActions.DefProp(Segment.ELEMENT), elementCb);
        HTMLBtn elementEditBtn = new HTMLBtn(Intl.intl("Edit..."));
        EditPropDuctFlowElement editElementConn = new EditPropDuctFlowElement((TypedProp<DuctFlowElement>)Segment.ELEMENT, elementEditBtn);
        guiLabel multiplierLbl = guiUtil.lblProp(Segment.MULTIPLIER);
        PropConnections.ScheduleProp multiplierConn = SelectionRibbonHelper.scheduleConn(Segment.MULTIPLIER, Segment.MULTIPLIER.name, 10, UnitDoubleVR.between(0.0, 1.0, Unit.ONE, true, true));
        ScheduleField multiplierFld = (ScheduleField)multiplierConn.getControl();
        SelectionEditorPanel.EditorPanel section1 = this.newSection();
        GridBagHelper gb = new GridBagHelper(section1);
        gb.rowSpace = 1;
        gb.addRow(this.createTitleLabel(Intl.intl("Flow")), 0, 1.0);
        gb.add(elementLbl);
        gb.add(elementCb, elementEditBtn, 0, 1.0);
        gb.addRow(new Object[0]);
        gb.addRow(multiplierLbl, multiplierFld, 0, 1.0);
        section1.addConnection(elementConn);
        section1.addConnection(editElementConn);
        section1.addConnection(multiplierConn);
        PropConnections.BoolPropConnection overrideLengthConn = SelectionRibbonHelper.boolConn(Segment.USE_MANUAL_LENGTH, Segment.AUTO_LENGTH.getNameWithColon());
        final guiMultiStateCheckBox overrideLengthCb = (guiMultiStateCheckBox)overrideLengthConn.getControl();
        overrideLengthCb.setToolTipText(Segment.USE_MANUAL_LENGTH.getDisplayDesc());
        PropConnections.UDPropConnection autoLengthConn = SelectionRibbonHelper.udConn(Segment.AUTO_LENGTH, 0);
        final MerlinUDF autoLengthFld = (MerlinUDF)autoLengthConn.getControl();
        autoLengthFld.setEditable(false);
        PropConnections.UDPropConnection manualLengthConn = SelectionRibbonHelper.udConn(Segment.MANUAL_LENGTH, 0);
        final MerlinUDF manualLengthFld = (MerlinUDF)manualLengthConn.getControl();
        HTMLBtn junctionABtn = new HTMLBtn("");
        JunctionPropConn junctionAConn = new JunctionPropConn(Segment.JUNCTION_A, junctionABtn);
        HTMLBtn junctionBBtn = new HTMLBtn("");
        JunctionPropConn junctionBConn = new JunctionPropConn(Segment.JUNCTION_B, junctionBBtn);
        HTMLBtn directionBtn = new HTMLBtn("");
        DirectionPropConn directionConn = new DirectionPropConn(Segment.DIRECTION_A_TO_B, directionBtn);
        final SelectionEditorPanel.EditorPanel section2 = this.newSection();
        gb = new GridBagHelper(section2);
        gb.addRow(this.createTitleLabel(Intl.intl("Segment Data")), 0, 1.0);
        guiPanel lengthPnl = new guiPanel(new MigLayout("insets 0"));
        lengthPnl.add(overrideLengthCb);
        lengthPnl.add((Component)autoLengthFld, "cell 1 0, hidemode 3");
        lengthPnl.add((Component)manualLengthFld, "cell 1 0, hidemode 3");
        gb.addRow(lengthPnl);
        guiPanel directionPnl = new guiPanel(new MigLayout("insets 0"));
        directionPnl.add(junctionABtn);
        directionPnl.add(directionBtn);
        directionPnl.add(junctionBBtn);
        gb.addRow(directionPnl);
        section2.addConnection(overrideLengthConn);
        section2.addConnection(autoLengthConn);
        section2.addConnection(manualLengthConn);
        section2.addConnection(junctionAConn);
        section2.addConnection(directionConn);
        section2.addConnection(junctionBConn);
        section2.addConnection(new AutoLengthPropConn(autoLengthFld));
        section2.addConnection(new ManualLengthPropConn(manualLengthFld));
        overrideLengthCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (overrideLengthCb.isSelected()) {
                    manualLengthFld.setVisible(true);
                    autoLengthFld.setVisible(false);
                } else {
                    manualLengthFld.setVisible(false);
                    autoLengthFld.setVisible(true);
                }
                section2.revalidate();
                section2.repaint();
            }
        });
        guiLabel sumLossCoefLbl = guiUtil.lblProp(Segment.SUM_OF_LOSS_COEFFICIENTS);
        PropConnections.DoublePropConn sumLossCoefConn = SelectionRibbonHelper.doubleConn(Segment.SUM_OF_LOSS_COEFFICIENTS, DoubleVR.ge(0.0));
        guiValueField sumLossCoefFld = (guiValueField)sumLossCoefConn.getControl();
        SelectionEditorPanel.EditorPanel section3 = this.newSection();
        section3.add((Component)this.createTitleLabel(Intl.intl("Darcey-Colebrook Data")), "wrap");
        section3.add(sumLossCoefLbl);
        section3.add(sumLossCoefFld);
        section3.addConnection(sumLossCoefConn);
        section3.addConnection(new CheckSumLossCoefPropConn(section3));
    }

    private SelectionEditorPanel.EditorPanel newSection() {
        SelectionEditorPanel.EditorPanel panel = new SelectionEditorPanel.EditorPanel(new MigLayout("insets 0, aligny top"));
        this.d_sections.add(panel);
        return panel;
    }

    private guiLabel createTitleLabel(String title) {
        guiLabel label = new guiLabel(title);
        label.setFont(label.getFont().deriveFont(1));
        return label;
    }

    @Override
    public boolean isEnabled(Set<TypedProp<?>> shared, Set<TypedProp<?>> unshared) {
        return shared.contains(Segment.ELEMENT) && !unshared.contains(Junction.ROOM);
    }

    @Override
    public Collection<SelectionEditorPanel.EditorPanel> getSections() {
        if (this.d_sections.isEmpty()) {
            this.createSections();
        }
        return this.d_sections;
    }

    public static class EditPropDuctFlowElement
    extends PropConnections.ASinglePropConnection<HTMLBtn, TypedProp<DuctFlowElement>> {
        public EditPropDuctFlowElement(TypedProp<DuctFlowElement> prop, HTMLBtn control) {
            super(prop, control);
            control.addFocusListener(this);
            control.addKeyListener(this);
        }

        @Override
        public void setProp(TypedProp<DuctFlowElement> prop, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
        }

        @Override
        public void initFromProp(TypedProp<DuctFlowElement> prop, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
            PropValue<DuctFlowElement> val = CompositePropertyUtil.getValue(prop, objs);
            comp.setVisible(false);
            comp.clearListeners();
            if (val.isUniform()) {
                comp.setVisible(true);
                comp.addActionListener(new EditPropDuctFlowElementAction(val.get()));
            }
        }

        private static class EditPropDuctFlowElementAction
        extends AMerlinOp
        implements ActionListener {
            private static DuctFlowElement d_elem;

            public EditPropDuctFlowElementAction(DuctFlowElement elem) {
                d_elem = elem;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                UIHook.run(UIHook.getComponent(e), "EditDuctFlowElementAction", this, 0);
            }

            @Override
            public void run(VentusApp app, VentusData md) {
                EditDuctFlowElementMgrOp.showDlg(app, md, d_elem);
            }
        }
    }

    public static class JunctionPropConn
    extends PropConnections.ASinglePropConnection<HTMLBtn, CompElementActions.IObjectProp<IMerlinObj, Junction>> {
        public JunctionPropConn(TypedProp<Junction> prop, HTMLBtn control) {
            super(new CompElementActions.DefProp(prop), control);
            control.addActionListener(this);
        }

        @Override
        public void setProp(CompElementActions.IObjectProp<IMerlinObj, Junction> prop, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
        }

        @Override
        public void initFromProp(CompElementActions.IObjectProp<IMerlinObj, Junction> prop, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
            comp.clearListeners();
            PropValue<Junction> value = prop.get(VentusApp.getAppData(), objs);
            if (!value.isUniform()) {
                comp.setText(Intl.intl("&lt;mixed&gt;"));
                return;
            }
            Junction junction = value.get();
            comp.setText(MerlinUtil.getName(junction));
            comp.addActionListener(evt -> {
                MerlinOpImpl op = new MerlinOpImpl((app, md) -> {
                    try (VentusData.WriteLock lock = md.lockWrite();){
                        Undo.begin(Intl.intl("Select Junction"));
                        Undo.insertUndoEntry_restoreSelection(md);
                        md.selection.set(junction);
                        Undo.end(md);
                    }
                });
                UIHook.run(UIHook.getComponent(evt), "SegmentRibbon.JunctionPropConn.initFromProp", op, 0);
            });
        }
    }

    public static class DirectionPropConn
    extends PropConnections.ASinglePropConnection<HTMLBtn, CompElementActions.IObjectProp<IMerlinObj, Boolean>> {
        private static final String POSITIVE = "&rarr;";
        private static final String NEGATIVE = "&larr;";
        private boolean d_modified = false;

        public DirectionPropConn(TypedProp<Boolean> prop, HTMLBtn control) {
            super(new CompElementActions.DefProp(prop), control);
            control.clearListeners();
            control.addActionListener(evt -> {
                Boolean direction = DirectionPropConn.parse(control);
                direction = direction == null ? Boolean.valueOf(true) : Boolean.valueOf(direction == false);
                this.d_modified = true;
                control.setText(DirectionPropConn.format(direction));
            });
            control.addActionListener(this);
        }

        private static Boolean parse(HTMLBtn comp) {
            if (comp.getText().contains(POSITIVE)) {
                return true;
            }
            if (comp.getText().contains(NEGATIVE)) {
                return false;
            }
            return null;
        }

        private static String format(Boolean dir) {
            return dir != null ? (dir.booleanValue() ? POSITIVE : NEGATIVE) : "&lt;&gt;";
        }

        @Override
        protected boolean isModified(HTMLBtn comp) {
            return this.d_modified;
        }

        @Override
        public void setProp(CompElementActions.IObjectProp<IMerlinObj, Boolean> prop, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
            if (comp.getText() == null || objs.isEmpty()) {
                return;
            }
            Boolean direction = DirectionPropConn.parse(comp);
            if (direction == null) {
                return;
            }
            SelectionEditorPanel.setPropRecursive(Intl.intl("Set Flow Direction"), prop, objs, direction);
            this.d_modified = false;
        }

        @Override
        public void initFromProp(CompElementActions.IObjectProp<IMerlinObj, Boolean> prop, Collection<? extends IMerlinObj> objs, HTMLBtn comp) {
            if (objs.isEmpty()) {
                return;
            }
            PropValue<Boolean> val = prop.get(VentusApp.getApp().getData(), objs);
            String text = DirectionPropConn.format(val.orElse(null));
            comp.setText(text);
            this.d_modified = false;
        }
    }

    public static class AutoLengthPropConn
    extends PropConnections.ASinglePropConnection<MerlinUDF, TypedProp<UnitDouble>> {
        public AutoLengthPropConn(MerlinUDF fld) {
            super(Segment.AUTO_LENGTH, fld);
        }

        @Override
        public void setProp(TypedProp<UnitDouble> prop, Collection<? extends IMerlinObj> objs, MerlinUDF comp) {
        }

        @Override
        public void initFromProp(TypedProp<UnitDouble> prop, Collection<? extends IMerlinObj> objs, MerlinUDF comp) {
            IMerlinObj iMerlinObj;
            if (objs.size() > 1) {
                comp.setVisible(false);
                comp.setValue(null);
                return;
            }
            if (objs.size() == 1 && (iMerlinObj = objs.stream().findFirst().get()) instanceof Segment) {
                Segment seg = (Segment)iMerlinObj;
                comp.setVisible(seg.get(Segment.USE_MANUAL_LENGTH) == false);
            }
        }
    }

    public static class ManualLengthPropConn
    extends PropConnections.ASinglePropConnection<MerlinUDF, TypedProp<UnitDouble>> {
        public ManualLengthPropConn(MerlinUDF fld) {
            super(Segment.MANUAL_LENGTH, fld);
        }

        @Override
        public void setProp(TypedProp<UnitDouble> prop, Collection<? extends IMerlinObj> objs, MerlinUDF comp) {
        }

        @Override
        public void initFromProp(TypedProp<UnitDouble> prop, Collection<? extends IMerlinObj> objs, MerlinUDF comp) {
            IMerlinObj iMerlinObj;
            if (objs.size() > 1) {
                comp.setVisible(true);
                comp.setEditable(false);
                comp.setValue(null);
                return;
            }
            if (objs.size() == 1 && (iMerlinObj = objs.stream().findFirst().get()) instanceof Segment) {
                Segment seg = (Segment)iMerlinObj;
                comp.setVisible(seg.get(Segment.USE_MANUAL_LENGTH));
                comp.setValue(seg.get(Segment.MANUAL_LENGTH));
            }
        }
    }

    public static class CheckSumLossCoefPropConn
    extends PropConnections.ASinglePropConnection<SelectionEditorPanel.EditorPanel, TypedProp<DuctFlowElement>> {
        public CheckSumLossCoefPropConn(SelectionEditorPanel.EditorPanel pnl) {
            super(Segment.ELEMENT, pnl);
        }

        @Override
        public void setProp(TypedProp<DuctFlowElement> prop, Collection<? extends IMerlinObj> objs, SelectionEditorPanel.EditorPanel comp) {
        }

        @Override
        public void initFromProp(TypedProp<DuctFlowElement> props, Collection<? extends IMerlinObj> objs, SelectionEditorPanel.EditorPanel pnl) {
            boolean elementIsDC = CompElementActions.flattenToLocallyDefined(Segment.ELEMENT, objs).stream().allMatch(obj -> {
                DuctFlowElement element = obj.get(Segment.ELEMENT);
                return element.get(DuctFlowElement.POWERLAW_MODEL) == PowerlawModel.DARCEY_COLEBROOK;
            });
            pnl.setVisible(elementIsDC);
        }
    }
}

