/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ducts;

import java.util.Map;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TypedProp;
import ventus.VentusApp;
import ventus.data.VentusData;
import ventus.data.value.Schedule;
import ventus.feature.comps.IPrjDataWriter;
import ventus.feature.ducts.DuctFlowElement;
import ventus.feature.ducts.DuctObjectRoot;
import ventus.feature.ducts.DuctObjectsData;
import ventus.feature.ducts.Junction;
import ventus.feature.ducts.Segment;
import ventus.io.contamx.PrjData;
import ventus.io.contamx.PrjUtil;

public class SegmentPrjWriter
implements IPrjDataWriter {
    @Override
    public IPrjDataWriter.Order getOrder() {
        return IPrjDataWriter.Order.AFTER_NORMAL;
    }

    private static int getJunctionIndex(PrjData data, Junction junction) {
        assert (junction != null);
        return data.findJunction((Object)junction).nr;
    }

    private static int getDuctFlowElementIndex(PrjData data, DuctFlowElement element) {
        assert (element != null);
        return data.findDuctFlowElement((Object)element).nr;
    }

    private static double getSegmentLength(Segment seg) {
        if (seg.get(Segment.USE_MANUAL_LENGTH).booleanValue()) {
            return seg.get(Segment.MANUAL_LENGTH).getValue(SI.METER);
        }
        return seg.get(Segment.AUTO_LENGTH).getValue(SI.METER);
    }

    @Override
    public void addPrjData(VentusApp app, VentusData md, Map<TypedProp, Object> scenario, PrjData prjData) {
        DuctObjectRoot root = (DuctObjectRoot)md.getComponentData(DuctObjectsData.GUID);
        for (Segment s : root.flatten(Segment.class)) {
            Pair<Integer, Double> flowMultiplier = PrjUtil.maybeWriteSchedule(prjData, s.get(Segment.MULTIPLIER), Unit.ONE);
            PrjData.Segment out = new PrjData.Segment(s);
            prjData.segmentList.add(out);
            out.nr = prjData.ndct = prjData.segmentList.size();
            out.flags = 0;
            if (s.get(Segment.DIRECTION_A_TO_B).booleanValue()) {
                out.pjn = SegmentPrjWriter.getJunctionIndex(prjData, s.get(Segment.JUNCTION_A));
                out.pjm = SegmentPrjWriter.getJunctionIndex(prjData, s.get(Segment.JUNCTION_B));
            } else {
                out.pjn = SegmentPrjWriter.getJunctionIndex(prjData, s.get(Segment.JUNCTION_B));
                out.pjm = SegmentPrjWriter.getJunctionIndex(prjData, s.get(Segment.JUNCTION_A));
            }
            out.pe = SegmentPrjWriter.getDuctFlowElementIndex(prjData, s.get(Segment.ELEMENT));
            out.pf = 0;
            out.ps = (Integer)flowMultiplier.v1 == 0 && (Double)flowMultiplier.v2 != 1.0 ? ((Integer)PrjUtil.maybeWriteSchedule((PrjData)prjData, (Schedule)Schedule.newRectangular((UnitDouble)s.get(Segment.MULTIPLIER).getInitialValue(), (Schedule.Entry[])new Schedule.Entry[0]), (Unit)Unit.ONE).v1).intValue() : ((Integer)flowMultiplier.v1).intValue();
            out.pc = 0;
            out.dir = 0;
            out.length = SegmentPrjWriter.getSegmentLength(s);
            out.Ain = 0.0314159;
            out.Aout = 0.0314159;
            out.sllc = s.get(Segment.SUM_OF_LOSS_COEFFICIENTS);
            out.color = -1;
            out.u_L = 0;
            out.u_A = 0;
            out.vf_type = 0;
            out.vf_node_name = "0";
        }
    }
}

