/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ducts;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.function.Function;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.util.theUtil;
import ventus.data.VentusData;
import ventus.feature.ducts.DuctFlowElement;
import ventus.feature.ducts.DuctFlowElementData;
import ventus.feature.ducts.DuctFlowElementRoot;
import ventus.feature.ducts.DuctObjectRoot;
import ventus.feature.ducts.DuctObjectsData;
import ventus.feature.ducts.Junction;
import ventus.feature.ducts.Segment;
import ventus.feature.ducts.SegmentBuilder;
import ventus.feature.ducts.SegmentWaypoint;
import ventus.geom.Geometry;
import ventus.mv.ModelView;
import ventus.mv.tools.IConditionallyEnabledTool;
import ventus.mv.tools.VentusTool;

public class NewSegmentTool
extends VentusTool<SegmentBuilder>
implements IConditionallyEnabledTool {
    public NewSegmentTool(ModelView mv) {
        super(mv, new SegmentFunc<Object>(tool -> mv.getData().activeFloor().getWorkingZ().get(Geometry.LENGTH_UNIT)));
    }

    private void initValueEditor() {
        ((SegmentBuilder)this.props()).initValueEditor(this.getAttachedComponent());
    }

    @Override
    protected void propsChanged(SegmentBuilder props, Object arg) {
        if (((SegmentBuilder)this.props()).aPropChanged(SegmentBuilder.COMPLETED)) {
            this.reset();
            this.finish();
        }
    }

    @Override
    public void reset() {
        super.reset();
        ((SegmentBuilder)this.props()).reset();
    }

    @Override
    public boolean cancel() {
        ((SegmentBuilder)this.props()).cancel();
        return super.cancel();
    }

    @Override
    public void activate() {
        super.activate();
        ((SegmentBuilder)this.props()).initValueEditor(this.getAttachedComponent());
        ((SegmentBuilder)this.props()).d_valueEditor.attach();
    }

    @Override
    public void deactivate() {
        ((SegmentBuilder)this.props()).reset();
        ((SegmentBuilder)this.props()).d_valueEditor.detach();
        super.deactivate();
    }

    @Override
    public boolean isEnabled(VentusData vd) {
        return !((DuctFlowElementRoot)vd.getComponentData(DuctFlowElementData.GUID)).flatten(DuctFlowElement.class).isEmpty() && !((DuctObjectRoot)vd.getComponentData(DuctObjectsData.GUID)).flatten(Junction.class).isEmpty();
    }

    private static class SegmentFunc<T extends NewSegmentTool>
    extends AToolFunction<T> {
        private final Function<T, Double> d_getZ;

        public SegmentFunc(Function<T, Double> getZ) {
            this.d_getZ = getZ;
        }

        @Override
        public Cursor getCursor(NewSegmentTool tool) {
            return null;
        }

        @Override
        public ISnapConstraint getSnapConstraint(T tool) {
            return new DuctConstraint(new Plane3d(new Vector3d(0.0, 0.0, 1.0), new Point3d(0.0, 0.0, this.d_getZ.apply(tool))));
        }

        @Override
        public void mousePressed(T tool, MouseEvent e) {
        }

        @Override
        public void mouseReleased(T tool, MouseEvent e) {
            switch (e.getButton()) {
                case 1: {
                    boolean finished = ((SegmentBuilder)((VentusTool)tool).props()).commitLoc();
                    if (!finished) break;
                    ((SegmentBuilder)((VentusTool)tool).props()).create(e.getComponent());
                    ((CursorTool)tool).finish();
                    break;
                }
                case 3: {
                    ((SegmentBuilder)((VentusTool)tool).props()).cancel();
                }
            }
        }

        @Override
        public void mouseDragged(T tool, MouseEvent e) {
        }

        @Override
        public void mouseMoved(T tool, MouseEvent e) {
            this.updateLocation(tool);
        }

        private void updateLocation(T tool) {
            Collection<IsectInfo> isects = ((CursorTool)tool).getP1().getFinalSnaps();
            if (!isects.isEmpty()) {
                IsectInfo isect = isects.iterator().next();
                Object object = isect.obj;
                if (object instanceof Junction) {
                    Junction junc = (Junction)object;
                    ((SegmentBuilder)((VentusTool)tool).props()).setHoveringJunction(junc);
                    return;
                }
                ((SegmentBuilder)((VentusTool)tool).props()).setHoveringPoint(isect.isectPoint);
                ((SegmentBuilder)((VentusTool)tool).props()).setHoveringJunction(null);
            }
            ((SegmentBuilder)((VentusTool)tool).props()).setHoveringJunction(null);
        }
    }

    private static class DuctConstraint
    extends PlanarConstraint {
        public DuctConstraint(Plane3d plane) {
            super(plane);
        }

        @Override
        public Collection<IsectInfo> snapPoint(Runnable validateProgress, Collection<IsectInfo> snaps, Vector3d projectionDir) {
            Collection<IsectInfo> ductSnaps = theUtil.preFilter(snaps, IsectInfo.class, snap -> {
                validateProgress.run();
                return snap.obj instanceof Junction || snap.obj instanceof Segment || snap.obj instanceof SegmentWaypoint;
            });
            if (!ductSnaps.isEmpty()) {
                return ductSnaps;
            }
            return super.snapPoint(validateProgress, snaps, projectionDir);
        }

        @Override
        public ISnapConstraint transform(Matrix4d xform) {
            return this;
        }
    }
}

