/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ducts;

import java.awt.Component;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Predicates;
import ventus.Intl;
import ventus.data.VentusData;
import ventus.feature.ducts.Junction;
import ventus.feature.ducts.JunctionBuilder;
import ventus.geom.Geometry;
import ventus.gui.APropEditPanel;
import ventus.gui.IPropEditCommand;
import ventus.gui.MerlinUDF;
import ventus.gui.guiUtil;
import ventus.mv.gui.CreatePanel;
import ventus.mv.gui.LocationPanel;
import ventus.util.MerlinProps;

public class NewJunctionPanel
extends APropEditPanel<JunctionBuilder> {
    private static final long serialVersionUID = 1L;
    private final guiTextField d_nameFld = this.initValueField(new guiTextField(), new IPropEditCommand[0]);
    private final MerlinUDF d_relHeightFld;

    public NewJunctionPanel(VentusData vd) {
        super(Junction.NAME);
        this.d_nameFld.setToolTipText(Intl.intl("Name"));
        guiPanel namePnl = new guiPanel();
        GridBagHelper gb = new GridBagHelper(namePnl);
        gb.addRow(new guiLabel(Intl.intl("Name:")), this.d_nameFld, 0, 1.0);
        guiPanel locPnl = new guiPanel();
        gb = new GridBagHelper(locPnl);
        LocationPanel locPanel = new LocationPanel(6, new Object[]{Junction.LOCATION}){

            @Override
            protected void updateToProps(MerlinProps props) {
                props.set(Junction.LOCATION, this.getValue().getPoint3dValue(Geometry.LENGTH_UNIT));
            }

            @Override
            protected void updateFromProps(MerlinProps props) {
                this.setValue(new UnitPoint3D(props.get(Junction.LOCATION), Geometry.LENGTH_UNIT));
            }
        };
        gb.addRow(locPanel);
        guiPanel propsPnl = new guiPanel();
        gb = new GridBagHelper(propsPnl);
        guiLabel relHeightLbl = guiUtil.lbl(Junction.RELATIVE_ELEVATION.getNameWithColon(), Junction.RELATIVE_ELEVATION.getDisplayDesc());
        this.d_relHeightFld = this.initValueField(new MerlinUDF(0), new IPropEditCommand[0]);
        gb.addRow(relHeightLbl, this.d_relHeightFld, 0, 1.0);
        CreatePanel<JunctionBuilder> createPnl = new CreatePanel<JunctionBuilder>(Intl.intl("Create"), Predicates.alwaysTrue(), (btn, builder) -> builder.create((Component)btn), new Object[0]);
        this.addSection(namePnl);
        this.addSeparator();
        this.addSection(propsPnl);
        this.addSeparator();
        this.addSection(locPnl);
        this.addSeparator();
        this.addSection(createPnl);
    }

    @Override
    protected void updateFromProps(JunctionBuilder props) {
        this.d_nameFld.setText((String)props.get(Junction.NAME));
        this.d_relHeightFld.setValue(props.get(Junction.RELATIVE_ELEVATION));
    }

    @Override
    protected void updateToProps(JunctionBuilder props) {
        props.set(Junction.NAME, this.d_nameFld.getValue());
        props.set(Junction.RELATIVE_ELEVATION, (UnitDouble)this.d_relHeightFld.getValue());
    }
}

