/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ducts;

import java.util.HashMap;
import java.util.Map;
import thunderheadeng.util.TypedProp;
import ventus.VentusApp;
import ventus.data.VentusData;
import ventus.feature.comps.IPrjDataWriter;
import ventus.io.contamx.PrjData;

public class JunctionConcentrationPrjDataWriter
implements IPrjDataWriter {
    @Override
    public IPrjDataWriter.Order getOrder() {
        return IPrjDataWriter.Order.AFTER_NORMAL;
    }

    @Override
    public void addPrjData(VentusApp app, VentusData md, Map<TypedProp, Object> scenario, PrjData prjData) {
        HashMap<Integer, PrjData.Species> contaminants = new HashMap<Integer, PrjData.Species>();
        for (Integer contaminant : prjData.contaminantsList) {
            contaminants.put(contaminant, prjData.findSpeciesNr(contaminant));
        }
        for (Integer contaminant : prjData.contaminantsList) {
            prjData.juncConcentrationHeaders.add(((PrjData.Species)contaminants.get((Object)contaminant)).name);
        }
        for (PrjData.Junction junc : prjData.junctionList) {
            PrjData.JunctionConcentration concentration = new PrjData.JunctionConcentration();
            concentration.nr = junc.nr;
            for (Integer contaminant : prjData.contaminantsList) {
                concentration.concentrations.add(((PrjData.Species)contaminants.get((Object)contaminant)).ccdef);
            }
            prjData.juncConcentrationList.add(concentration);
        }
        prjData.numOfMassFractions = prjData.njct * prjData.nctm;
    }
}

