/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ducts;

import java.awt.Component;
import javax.vecmath.Point3d;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.TypedProp;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.AddObject;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.feature.ducts.DuctObjectRoot;
import ventus.feature.ducts.DuctObjectsData;
import ventus.feature.ducts.Junction;
import ventus.geom.IMerlinGeomSrc;
import ventus.mv.ModelView;
import ventus.mv.displays.APropsDisplay;
import ventus.util.MerlinProps;

public class JunctionBuilder
extends MerlinProps {
    public static final Object COMPLETED = new Object();
    private final Junction d_junction = new Junction("");

    public Junction getJunction() {
        return this.d_junction;
    }

    @Override
    public <T> void set(IPropertySet.Prop<T> prop, T val) {
        if (!this.lock()) {
            return;
        }
        try {
            this.d_junction.set((TypedProp)prop, val);
            this.firePropChanged(prop);
        }
        finally {
            this.release();
        }
    }

    @Override
    public <T> T get(IPropertySet.Prop<T> prop) {
        TypedProp typedProp;
        if (prop instanceof TypedProp && Junction.PROP_TYPES.has(typedProp = (TypedProp)prop)) {
            return this.d_junction.get(typedProp);
        }
        return super.get(prop);
    }

    public void setLocation(Point3d location) {
        this.pause();
        this.set(Junction.LOCATION, location);
        this.resume();
    }

    public void reset() {
        this.pause();
        this.set(Junction.LOCATION, (Point3d)Junction.LOCATION.defVal);
        this.resume();
    }

    public void cancel() {
        this.reset();
    }

    public void create(Component c) {
        final Junction junction = this.getJunction().clone();
        AMerlinOp op = new AMerlinOp(this){

            @Override
            public void run(VentusApp app, VentusData md) {
                DuctObjectRoot root = (DuctObjectRoot)md.getComponentData(DuctObjectsData.GUID);
                if (root == null) {
                    return;
                }
                try (VentusData.WriteLock ignored = md.lockWrite();){
                    Undo.begin(Intl.intl("New Junction"));
                    String nextName = junction.getName().isEmpty() ? root.nextJunctionName() : junction.getName();
                    junction.setName(nextName);
                    AddObject.add((VentusData)md, (Composite)root, (int)root.getMembers().size(), (IMerlinObj[])new Junction[]{junction});
                    Undo.end(md);
                }
            }
        };
        UIHook.run(c, "JunctionBuilder.create", op, 4);
        this.firePropChanged(COMPLETED);
    }

    public static class Display
    extends APropsDisplay<JunctionBuilder> {
        public Display(ModelView mv) {
            super(mv);
        }

        @Override
        protected IMerlinGeomSrc constructGeom(JunctionBuilder builder) {
            Junction junc = builder.getJunction().clone();
            junc.setName("");
            junc.setVisible(true);
            return junc;
        }

        @Override
        protected Object[] getInterestingChanges() {
            return new Object[]{Junction.LOCATION};
        }
    }
}

