/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ducts;

import java.util.Collection;
import java.util.Optional;
import ventus.VentusApp;
import ventus.data.IMerlinObj;
import ventus.feature.ducts.DuctObjectRoot;
import ventus.feature.ducts.DuctObjectsData;
import ventus.feature.ducts.Junction;
import ventus.feature.ducts.Segment;
import ventus.feature.ducts.SegmentWaypoint;

public class DuctsUtil {
    public static Optional<Segment> getSegmentFromTerminal(Junction j) {
        if (j.getJunctionType() == Junction.JunctionType.JUNCTION) {
            return Optional.empty();
        }
        for (Segment seg : ((DuctObjectRoot)VentusApp.getAppData().getComponentData(DuctObjectsData.GUID)).flatten(Segment.class)) {
            if (seg.get(Segment.JUNCTION_A) != j && seg.get(Segment.JUNCTION_B) != j) continue;
            return Optional.of(seg);
        }
        return Optional.empty();
    }

    public static int getConnectedSegmentCount(Junction j) {
        int count = 0;
        for (Segment seg : ((DuctObjectRoot)VentusApp.getAppData().getComponentData(DuctObjectsData.GUID)).flatten(Segment.class)) {
            if (seg.get(Segment.JUNCTION_A) != j && seg.get(Segment.JUNCTION_B) != j) continue;
            ++count;
        }
        return count;
    }

    public static boolean findIdenticallyShapedSegment(Segment seg1) {
        Junction seg1juncA = seg1.get(Segment.JUNCTION_A);
        Junction seg1juncB = seg1.get(Segment.JUNCTION_B);
        Collection<IMerlinObj> seg1Children = seg1.getChildren();
        for (Segment seg2 : ((DuctObjectRoot)VentusApp.getAppData().getComponentData(DuctObjectsData.GUID)).flatten(Segment.class)) {
            if (seg1 == seg2) continue;
            Junction seg2juncA = seg2.get(Segment.JUNCTION_A);
            Junction seg2juncB = seg2.get(Segment.JUNCTION_B);
            Collection<IMerlinObj> seg2Children = seg2.getChildren();
            if ((seg1juncA != seg2juncA || seg1juncB != seg2juncB) && (seg1juncB != seg2juncA || seg1juncA != seg2juncB)) continue;
            if (seg1Children.isEmpty() && seg2Children.isEmpty()) {
                return true;
            }
            if (seg1Children.size() == seg2Children.size()) {
                Object[] seg1childArray = seg1Children.toArray();
                Object[] seg2childArray = seg2Children.toArray();
                boolean forwardsViolates = true;
                boolean backwardsViolates = true;
                for (int i = 0; i < seg1childArray.length; ++i) {
                    if (!((SegmentWaypoint)seg1childArray[i]).getElevatedLocation().equals(((SegmentWaypoint)seg2childArray[i]).getElevatedLocation())) {
                        forwardsViolates = false;
                    }
                    int j = seg1childArray.length - 1 - i;
                    if (((SegmentWaypoint)seg1childArray[i]).getElevatedLocation().equals(((SegmentWaypoint)seg2childArray[j]).getElevatedLocation())) continue;
                    backwardsViolates = false;
                }
                return forwardsViolates || backwardsViolates;
            }
            return false;
        }
        return false;
    }
}

