/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ducts;

import java.awt.Color;
import java.util.Collection;
import java.util.function.Function;
import thunderheadeng.util.NameGenerator;
import ventus.Intl;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.feature.dependencies.powerlaw.PowerlawModel;
import ventus.feature.ducts.DuctFlowElement;
import ventus.util.MerlinUtil;

public class DuctFlowElementRoot
extends Composite<DuctFlowElement> {
    static final long serialVersionUID = 1L;
    private NameGenerator d_nameGen = new NameGenerator(Intl.intl("DuctFlowElement"));

    public DuctFlowElementRoot() {
        super(Intl.intl("Duct Flow Elements"));
        this.addDefaults();
    }

    public void reset() {
        this.clear();
        this.d_nameGen.reset();
        this.addDefaults();
    }

    @Override
    public void restoreFrom(Object obj) {
        super.restoreFrom(obj);
        if (obj instanceof DuctFlowElementRoot) {
            DuctFlowElementRoot root = (DuctFlowElementRoot)obj;
            this.d_nameGen = root.d_nameGen;
        }
    }

    public String nextName() {
        String name = this.d_nameGen.generateName();
        this.d_nameGen.registerName(name);
        return name;
    }

    public NameGenerator getNameGenerator() {
        return this.d_nameGen;
    }

    @Override
    public void add(IMerlinObj elem) {
        super.add(elem);
        this.d_nameGen.registerName(MerlinUtil.getName(elem));
    }

    private void addDefaults() {
        this.pauseUpdates();
        for (Default def : Default.values()) {
            this.add(def.create.apply(def));
        }
        this.resumeUpdates();
    }

    public DuctFlowElement getDefault() {
        return this.getDefault(this.getDeepMembers(DuctFlowElement.class));
    }

    public DuctFlowElement getDefault(Collection<DuctFlowElement> elements) {
        DuctFlowElement defElement = elements.stream().filter(e -> e.get(DuctFlowElement.DEFAULT_TYPE) != null).findFirst().orElse(null);
        if (defElement != null) {
            return defElement;
        }
        if (elements.size() > 0) {
            return elements.iterator().next();
        }
        assert (false) : "getDefault is unable to return an applicable default DuctFlowElement";
        return null;
    }

    @Override
    public Composite<DuctFlowElement> newGroup(String name) {
        return new DuctFlowElementNode(name);
    }

    public static enum Default {
        DARCY_COLEBROOK(type -> {
            DuctFlowElement darcyColebrook = new DuctFlowElement(Intl.intl("DARCY_COLEBROOK"), (Default)((Object)type), new Color(253, 218, 13), PowerlawModel.DARCEY_COLEBROOK);
            return darcyColebrook;
        });

        public final Function<Default, DuctFlowElement> create;

        private Default(Function<Default, DuctFlowElement> create) {
            this.create = create;
        }
    }

    static class DuctFlowElementNode
    extends Composite<DuctFlowElement> {
        public DuctFlowElementNode(String name) {
            super(name);
        }

        @Override
        public String getNewGroupName() {
            return Intl.intl("Duct Flow Element Group");
        }

        @Override
        public Composite<DuctFlowElement> newGroup(String name) {
            return new DuctFlowElementNode(name);
        }
    }
}

