/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ducts;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AddObject;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.VentusData;
import ventus.feature.dependencies.powerlaw.PowerlawGuiUtil;
import ventus.feature.dependencies.powerlaw.PowerlawModel;
import ventus.feature.ducts.DuctFlowElement;
import ventus.feature.ducts.DuctFlowElementData;
import ventus.feature.ducts.DuctFlowElementEditor;
import ventus.feature.ducts.DuctFlowElementManager;
import ventus.feature.ducts.DuctFlowElementRoot;
import ventus.gui.ManagerDlg;
import ventus.gui.guiUtil;
import ventus.unitsystem.UnitSystem;

public class DuctFlowElementMgrDlg
extends ManagerDlg<DuctFlowElement, DuctFlowElementManager> {
    private static final long serialVersionUID = 1L;
    private final DuctFlowElementEditor d_editor;
    private DuctFlowElementManager d_manager;
    private final VentusData d_vd;

    public DuctFlowElementMgrDlg(JFrame owner, VentusApp app, UnitSystem us) {
        super(owner, app, Intl.intl("Edit Duct Flow Elements"), DuctFlowElement.class);
        this.d_editor = new DuctFlowElementEditor(owner, us);
        this.d_vd = app.getData();
        this.createActions();
        this.updateActions();
    }

    private void createActions() {
        this.addAction(new guiAction(Intl.intl("New..."), this::createNew));
        this.addAction(new ManagerDlg.LibraryAction(this, Intl.intl("Duct Flow Element"), vd -> (Composite)vd.getComponentData(DuctFlowElementData.GUID), "lib/ductflowelement", "ductflowelement"));
        this.addAction(new guiAction(Intl.intl("Duplicate..."), this::duplicate), this::canDuplicate);
        this.addAction(new ManagerDlg.RenameAction(this, DuctFlowElement.NAME), x$0 -> super.canRename(x$0));
        this.addAction(new ManagerDlg.DeleteAction(this), x$0 -> super.canDelete(x$0));
    }

    public void init(VentusData data, DuctFlowElementManager manager, DuctFlowElement node) {
        super.init(data, manager, this.d_editor, DuctFlowElementData.ICON);
        this.d_manager = manager;
        if (node == null) {
            this.getList().select(0);
        } else {
            this.getList().select(node);
        }
        this.d_editor.init((DuctFlowElement)this.getList().getSelectedItem());
    }

    public void createNew(ActionEvent event) {
        this.preSave();
        DuctFlowElementRoot root = this.d_manager.getRoot();
        NameGenerator ng = root.getNameGenerator();
        PowerlawModel initPlmFromSelected = this.getList().getSelectedItem() != null ? (PowerlawModel)((DuctFlowElement)this.getList().getSelectedItem()).get(DuctFlowElement.POWERLAW_MODEL) : PowerlawModel.DARCEY_COLEBROOK;
        guiComboBox<PowerlawModel> modelBox = PowerlawGuiUtil.createPowerlawCombo(PowerlawModel.Usage.DUCT);
        modelBox.setSelectedItem(initPlmFromSelected);
        final guiTextField nameField = new guiTextField(ng.generateValidName(Intl.intl("DuctFlowElement")));
        guiPanel namePanel = new guiPanel(new MigLayout("fill, insets 0")){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                return DuctFlowElementMgrDlg.this.validateName(true, true).test(null, nameField.getValue());
            }
        };
        namePanel.add((Component)guiUtil.lblProp(DuctFlowElement.NAME), "growx");
        namePanel.add((Component)nameField, "growx, wrap");
        guiDialog dlg = new guiDialog((Window)this, Intl.intl("New Duct Flow Element"), 9);
        dlg.setDialogComponent(namePanel);
        if (dlg.doModal() == 1) {
            DuctFlowElement element = new DuctFlowElement(nameField.getValue(), theUtil.newRandomSatColor(), modelBox.getSelectedItem());
            Undo.begin(Intl.intl("Create Duct Flow Element"));
            AddObject.add(this.d_vd, root, List.of(element));
            Undo.end(this.d_vd);
        }
    }

    protected boolean canDuplicate(DuctFlowElement element) {
        return element != null;
    }

    public void duplicate(ActionEvent event) {
        this.preSave();
        DuctFlowElementRoot root = this.d_manager.getRoot();
        DuctFlowElement selected = (DuctFlowElement)this.getList().getSelectedItem();
        guiComboBox<DuctFlowElement> basedOnComboBox = new guiComboBox<DuctFlowElement>(this.d_manager.getSorted());
        basedOnComboBox.setSelectedItem(selected);
        final guiTextField nameField = new guiTextField();
        nameField.setText(root.getNameGenerator().generateValidName(selected.getName()));
        basedOnComboBox.addItemListener(evt -> {
            if (evt.getStateChange() == 1 && !nameField.isModified()) {
                DuctFlowElement item = (DuctFlowElement)evt.getItem();
                nameField.setText(root.getNameGenerator().generateValidName(item.getName()));
            }
        });
        guiPanel namePanel = new guiPanel(new MigLayout("fill, insets 0")){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                return DuctFlowElementMgrDlg.this.validateName(true, true).test(null, nameField.getValue());
            }
        };
        namePanel.add((Component)new guiLabel(Intl.intl("Name:")), "growx");
        namePanel.add((Component)nameField, "growx, wrap");
        namePanel.add((Component)new guiLabel(Intl.intl("Based On:")), "growx");
        namePanel.add(basedOnComboBox, "growx, wrap");
        guiDialog dlg = new guiDialog((Window)this, Intl.intl("Duplicate Duct Flow Element"), 9);
        dlg.setDialogComponent(namePanel);
        if (dlg.doModal() == 1) {
            String name = nameField.getValue();
            DuctFlowElement element = basedOnComboBox.getSelectedItem() != null ? basedOnComboBox.getSelectedItem().clone() : new DuctFlowElement(name);
            element.setName(name);
            element.set(DuctFlowElement.DESC, "");
            Undo.begin(Intl.intl("Duplicate Duct Flow Element"));
            AddObject.add(this.getVentusData(), root, List.of(element));
            Undo.end(this.getVentusData());
        }
    }
}

