/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ducts;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import ventus.Intl;
import ventus.data.IMerlinObj;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.feature.dependencies.powerlaw.IPowerlawObj;
import ventus.feature.dependencies.powerlaw.PowerlawModel;
import ventus.feature.ducts.DuctFlowElementRoot;
import ventus.feature.props.DisplayProps;
import ventus.feature.props.PropertyDefs;
import ventus.feature.tags.Tag;
import ventus.feature.tags.TagsUtil;

public class DuctFlowElement
extends NamedMerlinObj
implements Serializable,
IPowerlawObj,
ISurrogate,
IDirectDependent<VentusData> {
    private static final long serialVersionUID = 1L;
    public static final PropertyDefs<DuctFlowElement> PROP_TYPES = PropertyDefs.defsInheritPropsOnlyMultiple(DuctFlowElement.class, PropertyDefs.serializedOnly(obj -> obj.d_properties, obj -> {
        obj.d_properties = new PropertySet();
    }), List.of(NamedMerlinObj.PROP_TYPES, IPowerlawObj.PROP_TYPES), Filters.reject(IPowerlawObj.getDuctFlowElementRejectedProps()));
    public static final TypedProp<DuctFlowElementRoot.Default> DEFAULT_TYPE = TypedProps.build((Object)"DuctFlowElement.DEFAULT_TYPE", DuctFlowElementRoot.Default.class).attrStoreAsPlainOldData(PROP_TYPES).attrCloneValue((obj, val) -> null).attrFinish();
    public static final DisplayProp<String> DESC = (DisplayProp)DisplayProps.build((Object)"DuctFlowElement.DESC", "", Intl.intl("Description"), Intl.intl("Duct Flow Element Description")).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<String> DESCRIPTION = PROP_TYPES.storeDirectWrapper(VentusData.DESCRIPTION, DESC).attrFinish();
    public static final DisplayProp<Color> COLOR = (DisplayProp)DisplayProps.build((Object)"DuctFlowElement.COLOR", Color.class, Color.BLACK, Intl.intl("Color"), Intl.intl("Duct Flow Element Color")).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<Color> SEARCH_COLOR = PROP_TYPES.storeAsReadOnly(VentusData.SEARCH_COLOR).attrGetter(elem -> elem.get(COLOR), COLOR).attrFinish();
    public static final DisplayProp<Set<Tag>> TAGS = TagsUtil.newTagsProp(PROP_TYPES);
    private PropertySet d_properties = new PropertySet();

    public DuctFlowElement(String name) {
        super(name);
    }

    public DuctFlowElement(String name, Color color, PowerlawModel law) {
        this(name, null, color, law);
    }

    public DuctFlowElement(String name, DuctFlowElementRoot.Default def, Color color, PowerlawModel law) {
        super(name);
        this.set(DEFAULT_TYPE, def);
        this.set(COLOR, color);
        this.set(POWERLAW_MODEL, law);
        this.d_properties.merge(law.defaultProps);
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        is.defaultReadObject();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getPropertyDefs() {
        return PROP_TYPES;
    }

    @Override
    public DuctFlowElement clone() {
        return (DuctFlowElement)super.clone();
    }

    public UnitDouble getDuctGeomArea() {
        if (this.get(POWERLAW_MODEL) == PowerlawModel.ORIFICE_AREA) {
            return (UnitDouble)this.get(CROSS_SECTIONAL_AREA);
        }
        double val = switch ((IPowerlawObj.DuctShape)this.get(DUCT_SHAPE)) {
            default -> throw new MatchException(null, null);
            case IPowerlawObj.DuctShape.CIRCLE -> Math.PI * Math.pow(((UnitDouble)this.get(DUCT_CIRCLE_DIAMETER)).get(SI.METER) / 2.0, 2.0);
            case IPowerlawObj.DuctShape.RECTANGLE -> ((UnitDouble)this.get(DUCT_RECT_WIDTH)).get(SI.METER) * ((UnitDouble)this.get(DUCT_RECT_HEIGHT)).get(SI.METER);
            case IPowerlawObj.DuctShape.OVAL -> {
                Pair<UnitDouble, UnitDouble> majorMinor = this.getMajorMinorPair();
                double majorDim = ((UnitDouble)majorMinor.v1).get(SI.METER);
                double minorDim = ((UnitDouble)majorMinor.v2).get(SI.METER);
                double span = majorDim - minorDim;
                double rectTerm = span * minorDim;
                double circTerm = Math.PI * Math.pow(minorDim / 2.0, 2.0);
                yield rectTerm + circTerm;
            }
            case IPowerlawObj.DuctShape.OTHER -> ((UnitDouble)this.get(DUCT_FLOW_AREA)).get(SI.METER.pow(2));
        };
        return new UnitDouble(val, SI.METER.pow(2));
    }

    public UnitDouble getDuctGeomPerimeter() {
        double val = switch ((IPowerlawObj.DuctShape)this.get(DUCT_SHAPE)) {
            default -> throw new MatchException(null, null);
            case IPowerlawObj.DuctShape.CIRCLE -> Math.PI * ((UnitDouble)this.get(DUCT_CIRCLE_DIAMETER)).get(SI.METER);
            case IPowerlawObj.DuctShape.RECTANGLE -> 2.0 * (((UnitDouble)this.get(DUCT_RECT_WIDTH)).get(SI.METER) + ((UnitDouble)this.get(DUCT_RECT_HEIGHT)).get(SI.METER));
            case IPowerlawObj.DuctShape.OVAL -> {
                Pair<UnitDouble, UnitDouble> majorMinor = this.getMajorMinorPair();
                double majorDim = ((UnitDouble)majorMinor.v1).get(SI.METER);
                double minorDim = ((UnitDouble)majorMinor.v2).get(SI.METER);
                double span = majorDim - minorDim;
                yield Math.PI * minorDim + 2.0 * span;
            }
            case IPowerlawObj.DuctShape.OTHER -> ((UnitDouble)this.get(DUCT_PERIMETER)).get(SI.METER);
        };
        return new UnitDouble(val, SI.METER);
    }

    public UnitDouble getDuctHydraulicDiam() {
        double val = switch ((IPowerlawObj.DuctShape)this.get(DUCT_SHAPE)) {
            default -> throw new MatchException(null, null);
            case IPowerlawObj.DuctShape.CIRCLE -> ((UnitDouble)this.get(DUCT_CIRCLE_DIAMETER)).get(SI.METER);
            case IPowerlawObj.DuctShape.RECTANGLE -> {
                double width = ((UnitDouble)this.get(DUCT_RECT_WIDTH)).get(SI.METER);
                double height = ((UnitDouble)this.get(DUCT_RECT_HEIGHT)).get(SI.METER);
                yield 1.3 * Math.pow(width * height, 0.625) / Math.pow(width + height, 0.25);
            }
            case IPowerlawObj.DuctShape.OVAL -> 1.55 * Math.pow(this.getDuctGeomArea().get(SI.METER.pow(2)), 0.625) / Math.pow(this.getDuctGeomPerimeter().get(SI.METER), 0.25);
            case IPowerlawObj.DuctShape.OTHER -> 4.0 * this.getDuctGeomArea().get(SI.METER.pow(2)) / this.getDuctGeomPerimeter().get(SI.METER);
        };
        return new UnitDouble(val, SI.METER);
    }

    public Pair<UnitDouble, UnitDouble> getMajorMinorPair() {
        return switch ((IPowerlawObj.DuctShape)this.get(DUCT_SHAPE)) {
            default -> throw new MatchException(null, null);
            case IPowerlawObj.DuctShape.CIRCLE -> new Pair<UnitDouble, UnitDouble>((UnitDouble)this.get(DUCT_CIRCLE_DIAMETER), (UnitDouble)this.get(DUCT_CIRCLE_DIAMETER));
            case IPowerlawObj.DuctShape.RECTANGLE -> new Pair<UnitDouble, UnitDouble>((UnitDouble)this.get(DUCT_RECT_WIDTH), (UnitDouble)this.get(DUCT_RECT_HEIGHT));
            case IPowerlawObj.DuctShape.OVAL -> {
                double large = Math.max(((UnitDouble)this.get(DUCT_OVAL_MAJOR)).get(SI.METER), ((UnitDouble)this.get(DUCT_OVAL_MINOR)).get(SI.METER));
                double small = Math.min(((UnitDouble)this.get(DUCT_OVAL_MAJOR)).get(SI.METER), ((UnitDouble)this.get(DUCT_OVAL_MINOR)).get(SI.METER));
                yield new Pair<UnitDouble, UnitDouble>(new UnitDouble(large, SI.METER), new UnitDouble(small, SI.METER));
            }
            case IPowerlawObj.DuctShape.OTHER -> new Pair<UnitDouble, UnitDouble>(new UnitDouble(0.0, SI.METER), new UnitDouble(0.0, SI.METER));
        };
    }
}

