/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ducts;

import java.util.ArrayList;
import java.util.Map;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TypedProp;
import ventus.VentusApp;
import ventus.data.VentusData;
import ventus.data.property.Function1dProp;
import ventus.data.value.APiecewiseFunction1d;
import ventus.feature.comps.IPrjDataWriter;
import ventus.feature.dependencies.powerlaw.CubicFanPerformanceCurveUtil;
import ventus.feature.dependencies.powerlaw.IPowerlawObj;
import ventus.feature.dependencies.powerlaw.PowerlawModel;
import ventus.feature.dependencies.powerlaw.PowerlawUtil;
import ventus.feature.ducts.DuctFlowElement;
import ventus.feature.ducts.DuctFlowElementData;
import ventus.feature.ducts.DuctFlowElementRoot;
import ventus.feature.flowpaths.FlowElement;
import ventus.io.contamx.PrjData;
import ventus.unitsystem.SIUS;

public class DuctElementPrjWriter
implements IPrjDataWriter {
    @Override
    public IPrjDataWriter.Order getOrder() {
        return IPrjDataWriter.Order.NORMAL;
    }

    @Override
    public void addPrjData(VentusApp app, VentusData md, Map<TypedProp, Object> scenario, PrjData prjData) {
        DuctFlowElementRoot root = (DuctFlowElementRoot)md.getComponentData(DuctFlowElementData.GUID);
        for (DuctFlowElement df : root.flatten(DuctFlowElement.class)) {
            PrjData.DuctFlowElem out = new PrjData.DuctFlowElem(df);
            prjData.ductFlowList.add(out);
            out.nr = prjData.ndfe = prjData.ductFlowList.size();
            out.dtype = PowerlawUtil.getPowerlawModelType(df, PowerlawModel.Usage.DUCT);
            out.name = df.getName();
            out.desc = "";
            if (df.get(DuctFlowElement.POWERLAW_MODEL) == PowerlawModel.DARCEY_COLEBROOK) {
                PrjData.DuctFlowTypeDarceyColebrook outDctDwc = new PrjData.DuctFlowTypeDarceyColebrook();
                prjData.dctDwcMap.put(out.nr, outDctDwc);
                outDctDwc.roughness = ((UnitDouble)df.get(DuctFlowElement.DUCT_ROUGHNESS)).get(SI.METER);
                outDctDwc.lam = 0.0;
                outDctDwc.u_r = 0;
            } else if (df.get(DuctFlowElement.POWERLAW_MODEL) == PowerlawModel.ORIFICE_AREA) {
                PrjData.DuctFlowPlrElem outPlr = new PrjData.DuctFlowPlrElem();
                prjData.ductPlrMap.put(out.nr, outPlr);
                outPlr.lam = PowerlawUtil.getLaminarFlow(df);
                outPlr.turb = PowerlawUtil.getTurbulentFlow(df);
                outPlr.expt = (Double)df.get(FlowElement.DUCT_ORIFICE_PRESSURE_EXPONENT);
                outPlr.area = ((UnitDouble)df.get(FlowElement.DUCT_ORIFICE_CROSS_SECTIONAL_AREA)).getValue(SI.METER.pow(2));
                outPlr.dia = PowerlawUtil.areaToDiameter((UnitDouble)df.get(FlowElement.DUCT_ORIFICE_CROSS_SECTIONAL_AREA)).getValue(SI.METER);
                outPlr.coef = (Double)df.get(FlowElement.DISCHARGE_COEFFICIENT);
                outPlr.uA = 0;
                outPlr.uD = 0;
            } else if (df.get(DuctFlowElement.POWERLAW_MODEL) == PowerlawModel.PERFORMANCE_CURVE) {
                PrjData.DuctFlowTypePerformanceCurve ductCurve = new PrjData.DuctFlowTypePerformanceCurve();
                prjData.ductPerformanceCurveMap.put(out.nr, ductCurve);
                ductCurve.lam = PowerlawUtil.getLaminarFlow(df);
                ductCurve.turb = PowerlawUtil.getTurbulentFlow(df);
                ductCurve.expt = (Double)df.get(FlowElement.PERFORMANCE_CURVE_PRESSURE_EXPONENT);
                ductCurve.cutOffRatio = (Double)df.get(FlowElement.PERFORMANCE_CURVE_CUTOFF_RATIO);
                Function1dProp prop = FlowElement.PERFORMANCE_CURVE;
                APiecewiseFunction1d func = df.get(prop).toPiecewise(Unit.ONE);
                CubicFanPerformanceCurveUtil.CurveData fanPerfCurve = CubicFanPerformanceCurveUtil.getCurveData(func.getInput(), SI.KILOGRAM.divide(SI.SECOND), SI.PASCAL);
                ductCurve.coefficients = fanPerfCurve.coefficients;
                ductCurve.freeDeliveryFlow = fanPerfCurve.freeDeliveryFlow;
                ductCurve.shutOffPressure = ductCurve.coefficients[0];
                ductCurve.area = ((UnitDouble)df.get(FlowElement.PERFORMANCE_CURVE_ORIFICE_AREA)).getValue(SI.METER.pow(2));
                ductCurve.uA = 0;
                ductCurve.npts = func.getInput().length;
                ductCurve.points = new ArrayList();
                Unit x_unit = SIUS.unit(prop.x.unitType);
                Unit y_unit = SIUS.unit(prop.y.unitType);
                for (APiecewiseFunction1d.Entry e : func.getInput()) {
                    ductCurve.points.add(new Pair<Double, Double>(e.x.getValue(x_unit), e.y.getValue(y_unit)));
                }
            } else if (df.get(DuctFlowElement.POWERLAW_MODEL) == PowerlawModel.CONSTANT_MASS_FLOW_FAN) {
                PrjData.DuctFlowTypeConstantMassFan constMass = new PrjData.DuctFlowTypeConstantMassFan();
                prjData.ductConstMassMap.put(out.nr, constMass);
                constMass.flow = ((UnitDouble)df.get(DuctFlowElement.CONSTANT_FAN_MAX_FLOW_RATE)).getValue(SI.KILOGRAM.divide(SI.SECOND));
                constMass.uF = 0;
            } else if (df.get(DuctFlowElement.POWERLAW_MODEL) == PowerlawModel.CONSTANT_VOLUME_FLOW_FAN) {
                PrjData.DuctFlowTypeConstantVolumeFan constVolume = new PrjData.DuctFlowTypeConstantVolumeFan();
                prjData.ductConstVolumeMap.put(out.nr, constVolume);
                constVolume.flow = ((UnitDouble)df.get(DuctFlowElement.CONSTANT_FAN_VOLUME_FLOW_RATE)).getValue(SI.METER.pow(3).divide(SI.SECOND));
                constVolume.uF = 0;
            }
            PrjData.DuctGeometry geom = new PrjData.DuctGeometry();
            prjData.ductGeometryMap.put(out.nr, geom);
            geom.hdia = df.getDuctHydraulicDiam().get(SI.METER);
            geom.perim = df.getDuctGeomPerimeter().get(SI.METER);
            geom.area = df.getDuctGeomArea().get(SI.METER.pow(2));
            Pair<UnitDouble, UnitDouble> dims = df.getMajorMinorPair();
            geom.major = ((UnitDouble)dims.v1).get(SI.METER);
            geom.minor = ((UnitDouble)dims.v2).get(SI.METER);
            geom.As = 0.0;
            geom.Qr = ((UnitDouble)df.get(DuctFlowElement.DUCT_LEAKAGE_RATE)).get(NonSI.LITER.divide(SI.SECOND).divide(SI.METER.pow(2)));
            geom.Pr = ((UnitDouble)df.get(DuctFlowElement.PRESSURE_DIFFERENCE)).get(SI.PASCAL);
            geom.shape = ((IPowerlawObj.DuctShape)df.get(DuctFlowElement.DUCT_SHAPE)).shape_id;
            geom.u_d = 4;
            geom.u_p = 4;
            geom.u_a = 2;
            geom.u_mj = 0;
            geom.u_mn = 0;
            geom.u_qr = 0;
            geom.u_pr = 0;
        }
    }
}

