/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.dependencies.powerlaw;

import java.util.Collection;
import java.util.EnumSet;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import ventus.data.value.IFunction1d;
import ventus.feature.dependencies.powerlaw.IPowerlawObj;
import ventus.feature.dependencies.powerlaw.LeakageAreaType;
import ventus.feature.dependencies.powerlaw.LeakageAreaTypeInfo;
import ventus.feature.dependencies.powerlaw.PowerlawMathUtil;
import ventus.feature.dependencies.powerlaw.PowerlawModel;
import ventus.feature.ducts.DuctFlowElement;
import ventus.feature.flowpaths.FlowElement;

public class PowerlawUtil {
    public static Collection<PowerlawModel> getPowerlawsForUsage(PowerlawModel.Usage usage) {
        return EnumSet.allOf(PowerlawModel.class).stream().filter(model -> model.doesUsageApply(usage)).sorted((m1, m2) -> m1.name.compareTo(m2.name)).toList();
    }

    public static String getPowerlawModelType(IPowerlawObj obj, PowerlawModel.Usage usageType) {
        if (obj.get(IPowerlawObj.POWERLAW_MODEL) == PowerlawModel.LEAKAGE_AREA) {
            return PowerlawModel.LEAKAGE_AREA.getType(usageType) + obj.get(IPowerlawObj.LEAKAGE_AREA_TYPE).sequence;
        }
        return obj.get(IPowerlawObj.POWERLAW_MODEL).getType(usageType);
    }

    public static double getFlowExponent(IPowerlawObj obj) {
        if (obj.get(IPowerlawObj.POWERLAW_MODEL) == PowerlawModel.CRACK_DESCRIPTION) {
            return PowerlawMathUtil.calcCrackExpt(obj.get(IPowerlawObj.CRACK_WIDTH).get(SI.METER));
        }
        assert (false) : "gettFlowExponent is unsupported for powerlaw model " + obj.get(IPowerlawObj.POWERLAW_MODEL).name;
        return 0.0;
    }

    public static double getTurbulentFlow(IPowerlawObj obj) {
        if (obj.get(IPowerlawObj.POWERLAW_MODEL) == PowerlawModel.ORIFICE_AREA) {
            double crossSection = obj instanceof FlowElement ? obj.get(IPowerlawObj.CROSS_SECTIONAL_AREA).get(SI.METER.pow(2)) : obj.get(IPowerlawObj.DUCT_ORIFICE_CROSS_SECTIONAL_AREA).get(SI.METER.pow(2));
            return PowerlawMathUtil.orificeAreaTurbulentFlow(crossSection, obj.get(IPowerlawObj.DISCHARGE_COEFFICIENT));
        }
        if (obj.get(IPowerlawObj.POWERLAW_MODEL) == PowerlawModel.LEAKAGE_AREA) {
            return PowerlawMathUtil.leakageAreaTurbulentFlow(PowerlawUtil.getSingleUnitOfLeakArea(obj).get(SI.METER.pow(2)), obj.get(IPowerlawObj.DISCHARGE_COEFFICIENT), obj.get(IPowerlawObj.PRESSURE_DIFFERENCE).get(SI.PASCAL), obj.get(IPowerlawObj.PRESSURE_EXPONENT));
        }
        if (obj.get(IPowerlawObj.POWERLAW_MODEL) == PowerlawModel.STAIRWELL) {
            return PowerlawMathUtil.stairwellTurbulentFlow(obj.get(IPowerlawObj.CROSS_SECTIONAL_AREA).get(SI.METER.pow(2)), obj.get(IPowerlawObj.STAIR_SHAFT_DZ).get(SI.METER), obj.get(IPowerlawObj.PEOPLE_DENSITY).get(Unit.ONE.divide(SI.METER.pow(2))), obj.get(IPowerlawObj.STAIR_TREADS_OPEN));
        }
        if (obj.get(IPowerlawObj.POWERLAW_MODEL) == PowerlawModel.SHAFT) {
            PowerlawMathUtil.ShaftCalcOutput result = PowerlawMathUtil.getShaftData(obj.get(IPowerlawObj.STAIR_SHAFT_DZ).get(SI.METER), obj.get(IPowerlawObj.CROSS_SECTIONAL_AREA).get(SI.METER.pow(2)), obj.get(IPowerlawObj.PERIMETER).get(SI.METER), obj.get(IPowerlawObj.ROUGHNESS).get(SI.METER));
            return result.coefTurbulent;
        }
        if (obj.get(IPowerlawObj.POWERLAW_MODEL) == PowerlawModel.PERFORMANCE_CURVE) {
            return PowerlawMathUtil.orificeAreaTurbulentFlow(obj.get(IPowerlawObj.PERFORMANCE_CURVE_ORIFICE_AREA).get(SI.METER.pow(2)), obj.get(IPowerlawObj.DISCHARGE_COEFFICIENT));
        }
        if (obj.get(IPowerlawObj.POWERLAW_MODEL) == PowerlawModel.TWOWAY_ONE) {
            return PowerlawMathUtil.orificeAreaTurbulentFlow(obj.get(IPowerlawObj.DOOR_HEIGHT).get(SI.METER) * obj.get(IPowerlawObj.DOOR_WIDTH).get(SI.METER), obj.get(IPowerlawObj.DISCHARGE_COEFFICIENT));
        }
        if (obj.get(IPowerlawObj.POWERLAW_MODEL) == PowerlawModel.TWOWAY_TWO) {
            return PowerlawMathUtil.orificeAreaTurbulentFlow(obj.get(IPowerlawObj.DOOR_HEIGHT).get(SI.METER) * obj.get(IPowerlawObj.DOOR_WIDTH).get(SI.METER) / 2.0, obj.get(IPowerlawObj.DISCHARGE_COEFFICIENT));
        }
        if (obj.get(IPowerlawObj.POWERLAW_MODEL) == PowerlawModel.TEST_ONE) {
            return PowerlawMathUtil.calcTestPointTurbulentFlow(obj.get(IPowerlawObj.FLOWRATE).get(SI.KILOGRAM.divide(SI.SECOND)), obj.get(IPowerlawObj.PRESSURE_DIFFERENCE).get(SI.PASCAL), obj.get(IPowerlawObj.PRESSURE_EXPONENT));
        }
        if (obj.get(IPowerlawObj.POWERLAW_MODEL) == PowerlawModel.TEST_TWO) {
            return PowerlawMathUtil.calcTestPoint2TurbulentFlow(obj.get(IPowerlawObj.PRESSURE_DIFFERENCE1).get(SI.PASCAL), obj.get(IPowerlawObj.FLOWRATE1).get(SI.KILOGRAM.divide(SI.SECOND)), obj.get(IPowerlawObj.PRESSURE_DIFFERENCE2).get(SI.PASCAL), obj.get(IPowerlawObj.FLOWRATE2).get(SI.KILOGRAM.divide(SI.SECOND)));
        }
        if (obj.get(IPowerlawObj.POWERLAW_MODEL) == PowerlawModel.CRACK_DESCRIPTION) {
            return PowerlawMathUtil.calcCrackDescriptionTurbulentFlow(obj.get(IPowerlawObj.CRACK_WIDTH).get(SI.METER), obj.get(IPowerlawObj.CRACK_LENGTH).get(SI.METER));
        }
        assert (false) : "getTurbulentFlow is unsupported for powerlaw model " + obj.get(IPowerlawObj.POWERLAW_MODEL).name;
        return 0.0;
    }

    private static UnitDouble getSingleUnitOfLeakArea(IPowerlawObj obj) {
        LeakageAreaType type = obj.get(IPowerlawObj.LEAKAGE_AREA_TYPE);
        LeakageAreaTypeInfo typeInfo = new LeakageAreaTypeInfo(type);
        UnitDouble baseValue = obj.get(typeInfo.prop);
        return typeInfo.convertToAreaM2.apply(baseValue);
    }

    public static UnitDouble areaToDiameter(UnitDouble area) {
        return area.divide(new UnitDouble(Math.PI, Unit.ONE)).root(2).multiply(new UnitDouble(2.0, Unit.ONE));
    }

    public static double getLaminarFlow(IPowerlawObj obj) {
        if (obj.get(IPowerlawObj.POWERLAW_MODEL) == PowerlawModel.ORIFICE_AREA) {
            if (obj instanceof FlowElement) {
                return PowerlawMathUtil.orificeAreaLaminarFlow(obj.get(IPowerlawObj.REYNOLDS_NUMBER), obj.get(IPowerlawObj.CROSS_SECTIONAL_AREA).get(SI.METER.pow(2)), obj.get(IPowerlawObj.DISCHARGE_COEFFICIENT), PowerlawUtil.areaToDiameter(obj.get(IPowerlawObj.CROSS_SECTIONAL_AREA)).get(SI.METER), obj.get(IPowerlawObj.PRESSURE_EXPONENT));
            }
            if (obj instanceof DuctFlowElement) {
                return PowerlawMathUtil.orificeAreaLaminarFlow(obj.get(IPowerlawObj.REYNOLDS_NUMBER), obj.get(IPowerlawObj.DUCT_ORIFICE_CROSS_SECTIONAL_AREA).get(SI.METER.pow(2)), obj.get(IPowerlawObj.DISCHARGE_COEFFICIENT), PowerlawUtil.areaToDiameter(obj.get(IPowerlawObj.DUCT_ORIFICE_CROSS_SECTIONAL_AREA)).get(SI.METER), obj.get(IPowerlawObj.DUCT_ORIFICE_PRESSURE_EXPONENT));
            }
        } else {
            if (obj.get(IPowerlawObj.POWERLAW_MODEL) == PowerlawModel.LEAKAGE_AREA) {
                return PowerlawMathUtil.leakageAreaLaminarFlow(PowerlawUtil.getSingleUnitOfLeakArea(obj).get(SI.METER.pow(2)), obj.get(IPowerlawObj.DISCHARGE_COEFFICIENT), obj.get(IPowerlawObj.PRESSURE_DIFFERENCE).get(SI.PASCAL), obj.get(IPowerlawObj.PRESSURE_EXPONENT));
            }
            if (obj.get(IPowerlawObj.POWERLAW_MODEL) == PowerlawModel.STAIRWELL) {
                return PowerlawMathUtil.stairwellLaminarFlow(obj.get(IPowerlawObj.CROSS_SECTIONAL_AREA).get(SI.METER.pow(2)), obj.get(IPowerlawObj.STAIR_SHAFT_DZ).get(SI.METER), obj.get(IPowerlawObj.PEOPLE_DENSITY).get(Unit.ONE.divide(SI.METER.pow(2))), obj.get(IPowerlawObj.PRESSURE_EXPONENT), obj.get(IPowerlawObj.STAIR_TREADS_OPEN));
            }
            if (obj.get(IPowerlawObj.POWERLAW_MODEL) == PowerlawModel.SHAFT) {
                PowerlawMathUtil.ShaftCalcOutput result = PowerlawMathUtil.getShaftData(obj.get(IPowerlawObj.STAIR_SHAFT_DZ).get(SI.METER), obj.get(IPowerlawObj.CROSS_SECTIONAL_AREA).get(SI.METER.pow(2)), obj.get(IPowerlawObj.PERIMETER).get(SI.METER), obj.get(IPowerlawObj.ROUGHNESS).get(SI.METER));
                return result.coefLaminar;
            }
            if (obj.get(IPowerlawObj.POWERLAW_MODEL) == PowerlawModel.PERFORMANCE_CURVE) {
                return PowerlawMathUtil.getFanFanLaminarFlow(obj.get(IPowerlawObj.PERFORMANCE_CURVE_ORIFICE_AREA).get(SI.METER.pow(2)));
            }
            if (obj.get(IPowerlawObj.POWERLAW_MODEL) == PowerlawModel.TWOWAY_ONE) {
                return PowerlawUtil.getTwoWayLaminarFlow(obj, false);
            }
            if (obj.get(IPowerlawObj.POWERLAW_MODEL) == PowerlawModel.TWOWAY_TWO) {
                return PowerlawUtil.getTwoWayLaminarFlow(obj, true);
            }
            if (obj.get(IPowerlawObj.POWERLAW_MODEL) == PowerlawModel.TEST_ONE) {
                return PowerlawMathUtil.calcTestPoint1LaminarFlow(obj.get(IPowerlawObj.PRESSURE_DIFFERENCE).get(SI.PASCAL), obj.get(IPowerlawObj.FLOWRATE).get(SI.KILOGRAM.divide(SI.SECOND)), obj.get(IPowerlawObj.PRESSURE_EXPONENT));
            }
            if (obj.get(IPowerlawObj.POWERLAW_MODEL) == PowerlawModel.TEST_TWO) {
                return PowerlawMathUtil.calcTestPoint2LaminarFlow(obj.get(IPowerlawObj.PRESSURE_DIFFERENCE1).get(SI.PASCAL), obj.get(IPowerlawObj.FLOWRATE1).get(SI.KILOGRAM.divide(SI.SECOND)), obj.get(IPowerlawObj.PRESSURE_DIFFERENCE2).get(SI.PASCAL), obj.get(IPowerlawObj.FLOWRATE2).get(SI.KILOGRAM.divide(SI.SECOND)));
            }
            if (obj.get(IPowerlawObj.POWERLAW_MODEL) == PowerlawModel.CRACK_DESCRIPTION) {
                return PowerlawMathUtil.calcCrackDescriptionLaminarFlow(obj.get(IPowerlawObj.CRACK_WIDTH).get(SI.METER), obj.get(IPowerlawObj.CRACK_LENGTH).get(SI.METER));
            }
            assert (false) : "getLaminarFlow is unsupported for powerlaw model " + obj.get(IPowerlawObj.POWERLAW_MODEL).name;
        }
        return 0.0;
    }

    private static double getTwoWayLaminarFlow(IPowerlawObj obj, boolean twoOpening) {
        double h = obj.get(IPowerlawObj.DOOR_HEIGHT).get(SI.METER);
        double w = obj.get(IPowerlawObj.DOOR_WIDTH).get(SI.METER);
        double a = h * w;
        double dH = 4.0 * a / (h * 2.0 + w * 2.0);
        return PowerlawMathUtil.getTwoWayLaminarFlow(a, dH, obj.get(IPowerlawObj.DISCHARGE_COEFFICIENT), twoOpening);
    }

    public static boolean isLeakageAreaPerItem(IPowerlawObj obj) {
        return obj.get(IPowerlawObj.POWERLAW_MODEL) == PowerlawModel.LEAKAGE_AREA && obj.get(IPowerlawObj.LEAKAGE_AREA_TYPE) == LeakageAreaType.ITEM;
    }

    public static IFunction1d getFanPerformanceCurve(IPowerlawObj obj) {
        assert (obj.get(IPowerlawObj.POWERLAW_MODEL) == PowerlawModel.PERFORMANCE_CURVE);
        return obj.get(IPowerlawObj.PERFORMANCE_CURVE);
    }
}

