/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.dependencies.powerlaw;

import java.awt.Color;
import java.awt.Component;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.value.PopupValEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.TypedProp;
import ventus.Intl;
import ventus.data.IMerlinObj;
import ventus.data.value.APiecewiseFunction1d;
import ventus.data.value.IFunction1d;
import ventus.feature.dependencies.powerlaw.CubicFlowFunction;
import ventus.feature.dependencies.powerlaw.CubicPolyFunction1dEditor;
import ventus.feature.dependencies.powerlaw.IPowerlawObj;
import ventus.feature.dependencies.powerlaw.PowerlawModel;
import ventus.feature.dependencies.powerlaw.PowerlawUtil;
import ventus.unitsystem.UnitSystem;

public class PowerlawGuiUtil {
    public static guiComboBox<PowerlawModel> createPowerlawCombo(PowerlawModel.Usage usage) {
        return PowerlawGuiUtil.createPowerlawCombo(PowerlawUtil.getPowerlawsForUsage(usage));
    }

    public static guiComboBox<PowerlawModel> createPowerlawCombo(Collection<PowerlawModel> values) {
        guiComboBox<PowerlawModel> modelBox = new guiComboBox<PowerlawModel>(values);
        modelBox.setRenderer(new BasicComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (c instanceof JLabel && value != null) {
                    JLabel label = (JLabel)c;
                    if (value instanceof PowerlawModel) {
                        PowerlawModel model = (PowerlawModel)value;
                        label.setToolTipText(model.description);
                    }
                }
                return c;
            }
        });
        return modelBox;
    }

    public static List<Component> addRow(guiPanel migPanel, String lbl, String tooltip, Component comp, String ... compConstraints) {
        ArrayList<Component> comps = new ArrayList<Component>();
        guiLabel label = new guiLabel(lbl);
        if (tooltip != null) {
            label.setToolTipText(tooltip);
        }
        comps.add(label);
        migPanel.add(label);
        Component glue = Box.createGlue();
        comps.add(glue);
        migPanel.add(glue, "");
        comps.add(comp);
        if (compConstraints.length > 0) {
            migPanel.add(comp, String.join((CharSequence)", ", compConstraints));
        } else {
            migPanel.add(comp, "wrap");
        }
        return comps;
    }

    public static String getStandardMigLayoutConstraintsForTabs() {
        return PowerlawGuiUtil.getStandardMigInsetsForTabs();
    }

    public static String getStandardMigInsetsForTabs() {
        return "insets 6 0 0 0";
    }

    public static String appendHideMode(String baseLayoutConstraints) {
        return baseLayoutConstraints + ", hidemode 3";
    }

    public static String getStandardMigDimConstraintsForTabs() {
        return "[left][grow][fill, right]";
    }

    public static guiPanel wrapNonMigPanel(guiPanel nonMigPanel) {
        guiPanel wrapper = new guiPanel(new MigLayout(PowerlawGuiUtil.getStandardMigLayoutConstraintsForTabs(), PowerlawGuiUtil.getStandardMigDimConstraintsForTabs()));
        wrapper.add((Component)nonMigPanel, "span, grow, wrap");
        return wrapper;
    }

    public static guiPanel createCardOrificeArea(UnitSystem us, Bindings<? extends IMerlinObj> bindings, boolean isDuct) {
        ValueField<Double> pressureExponent;
        ValueField<UnitDouble> crossSectionalArea;
        guiPanel card = new guiPanel(new MigLayout("insets 0", "[left][grow][fill, right]"));
        if (isDuct) {
            crossSectionalArea = bindings.bind(IPowerlawObj.DUCT_ORIFICE_CROSS_SECTIONAL_AREA, ValueFields.udFld(UnitDoubleVR.above(0.0, us.getArea(), false), us.getArea()));
            pressureExponent = bindings.bind(IPowerlawObj.DUCT_ORIFICE_PRESSURE_EXPONENT, ValueFields.doubleFld(DoubleVR.between(0.5, 1.0, true, true)));
        } else {
            crossSectionalArea = bindings.bind(IPowerlawObj.CROSS_SECTIONAL_AREA, ValueFields.udFld(UnitDoubleVR.above(0.0, us.getArea(), false), us.getArea()));
            pressureExponent = bindings.bind(IPowerlawObj.PRESSURE_EXPONENT, ValueFields.doubleFld(DoubleVR.between(0.5, 1.0, true, true)));
        }
        ValueField<Double> dischargeCoef = bindings.bind(IPowerlawObj.DISCHARGE_COEFFICIENT, ValueFields.doubleFld(DoubleVR.between(0.1, 1.0, true, true)));
        PowerlawGuiUtil.addRow(card, Intl.intl("Cross-Sectional Area:"), null, crossSectionalArea, new String[0]);
        PowerlawGuiUtil.addRow(card, Intl.intl("Flow Exponent:"), null, pressureExponent, new String[0]);
        PowerlawGuiUtil.addRow(card, Intl.intl("Discharge Coefficient:"), null, dischargeCoef, new String[0]);
        if (!isDuct) {
            ValueField<Double> reynoldsNumber = bindings.bind(IPowerlawObj.REYNOLDS_NUMBER, ValueFields.doubleFld(DoubleVR.above(1.0, true)));
            PowerlawGuiUtil.addRow(card, IPowerlawObj.REYNOLDS_NUMBER.name, IPowerlawObj.REYNOLDS_NUMBER.desc, reynoldsNumber, new String[0]);
        }
        return card;
    }

    public static <ClassT extends IMerlinObj> guiPanel createCardQvP(UnitSystem us, Bindings<ClassT> bindings) {
        guiPanel card = new guiPanel(new MigLayout("insets 0", "[left][grow][fill, right]"));
        CubicFlowFunction.CubicSplineEditor editor = new CubicFlowFunction.CubicSplineEditor(IPowerlawObj.Q_V_P_CURVE, 4, 1);
        PopupValEditor<APiecewiseFunction1d> popupEditor = new PopupValEditor<APiecewiseFunction1d>(PopupValEditor.Mode.PLAIN_BUTTON, APiecewiseFunction1d.class, Intl.intl("Edit Input"), () -> editor, f -> Intl.intl("Cubic Spline"));
        bindings.bind(popupEditor, new Binding<IMerlinObj>(data -> {
            APiecewiseFunction1d func = data.get(IPowerlawObj.Q_V_P_CURVE).toPiecewise(Unit.ONE);
            popupEditor.setValue(func);
            editor.setValue(func);
            editor.resetSeries();
        }, data -> data.set(IPowerlawObj.Q_V_P_CURVE, (IFunction1d)editor.getValue())));
        popupEditor.addValueListener(e -> editor.resetSeries());
        PowerlawGuiUtil.addRow(card, Intl.intl("Curve Data:"), Intl.intl("Modeled relationship between Pressure Difference and Volume Flow Rate"), popupEditor, "wrap", "shrink 50");
        return card;
    }

    public static guiPanel createCardConstantMassFlowFan(UnitSystem us, Bindings<? extends IMerlinObj> bindings) {
        guiPanel card = new guiPanel(new MigLayout("insets 0", "[left][grow][fill, right]"));
        ValueField<UnitDouble> maxFlowRate = bindings.bind(IPowerlawObj.CONSTANT_FAN_MAX_FLOW_RATE, ValueFields.udFld(UnitSystem.getType(17, false), UnitDoubleVR.ge(0.0, SI.KILOGRAM.divide(SI.SECOND))));
        PowerlawGuiUtil.addRow(card, Intl.intl("Design (max) Flow Rate:"), Intl.intl("Maximum constant mass flow rate allowed of this fan."), maxFlowRate, new String[0]);
        return card;
    }

    public static guiPanel createCardConstantVolumeFlowFan(UnitSystem us, Bindings<? extends IMerlinObj> bindings) {
        guiPanel card = new guiPanel(new MigLayout("insets 0", "[left][grow][fill, right]"));
        ValueField<UnitDouble> maxFlowRate = bindings.bind(IPowerlawObj.CONSTANT_FAN_VOLUME_FLOW_RATE, ValueFields.udFld(DoubleVR.above(0.0, false), us.getVolume().divide(us.getTime())));
        PowerlawGuiUtil.addRow(card, Intl.intl("Design (max) Flow Rate:"), Intl.intl("Maximum volumetric flow rate allowed of this fan."), maxFlowRate, new String[0]);
        return card;
    }

    public static guiPanel createCardPerformanceCurve(UnitSystem us, Bindings<? extends IMerlinObj> bindings) {
        guiPanel card = new guiPanel(new MigLayout("insets 0", "[left][grow][fill, right]"));
        ValueField<Double> cutOffRatio = bindings.bind(IPowerlawObj.PERFORMANCE_CURVE_CUTOFF_RATIO, ValueFields.doubleFld(DoubleVR.above(0.0, false)));
        ValueField<UnitDouble> equivalentOrificeArea = bindings.bind(IPowerlawObj.PERFORMANCE_CURVE_ORIFICE_AREA, ValueFields.udFld(DoubleVR.above(0.0, false), us.getArea()));
        ValueField<Double> pressureExponent = bindings.bind(IPowerlawObj.PERFORMANCE_CURVE_PRESSURE_EXPONENT, ValueFields.doubleFld(DoubleVR.between(0.5, 1.0, true, true)));
        ValueField<Double> dischargeCoefficient = ValueFields.doubleFld(0.6);
        dischargeCoefficient.setEditable(false);
        CubicPolyFunction1dEditor editor = new CubicPolyFunction1dEditor(IPowerlawObj.PERFORMANCE_CURVE);
        PopupValEditor<APiecewiseFunction1d> popupEditor = new PopupValEditor<APiecewiseFunction1d>(PopupValEditor.Mode.HTML, APiecewiseFunction1d.class, Intl.intl("Edit Fan Performance Data"), () -> editor, f -> Intl.intl("Edit..."));
        bindings.bind(popupEditor, new Binding<IPowerlawObj>(data -> {
            APiecewiseFunction1d func = data.get(IPowerlawObj.PERFORMANCE_CURVE).toPiecewise(Unit.ONE);
            popupEditor.setValue(func);
            editor.setValue(func);
            editor.resetSeriesWithMarks();
        }, data -> data.set(IPowerlawObj.PERFORMANCE_CURVE, (IFunction1d)editor.getValue())));
        popupEditor.addValueListener(e -> editor.resetSeriesWithMarks());
        PowerlawGuiUtil.addRow(card, Intl.intl("Fan Performance Data:"), null, popupEditor, "sgy perfcurve, wrap");
        PowerlawGuiUtil.addRow(card, Intl.intl("Cut-off Multiplier Ratio:"), null, cutOffRatio, "sgy perfcurve, wrap");
        card.add((Component)new guiLabel(Intl.intl("Cut-off Condition Flow Exponent:")), "gapLeft 10px");
        card.add(Box.createGlue(), "");
        card.add(pressureExponent, String.join((CharSequence)", ", "wrap"));
        card.add((Component)new guiLabel(Intl.intl("Cut-off Condition Discharge Coefficient:")), "gapLeft 10px");
        card.add(Box.createGlue(), "");
        card.add(dischargeCoefficient, String.join((CharSequence)", ", "wrap"));
        card.add((Component)new guiLabel(Intl.intl("Cut-off Condition Equivalent Orifice Area:")), "gapLeft 10px");
        card.add(Box.createGlue(), "");
        card.add(equivalentOrificeArea, String.join((CharSequence)", ", "wrap"));
        return card;
    }

    public static class Bindings<ClassT extends IMerlinObj> {
        private final Map<Component, Binding<ClassT>> d_bindings = new HashMap<Component, Binding<ClassT>>();

        public void load(ClassT dataObj) {
            for (Binding<ClassT> binding : this.d_bindings.values()) {
                binding.updateComp.accept(dataObj);
            }
        }

        public void store(ClassT dataObj) {
            for (Map.Entry<Component, Binding<ClassT>> entry : this.d_bindings.entrySet()) {
                Component comp = entry.getKey();
                if (!comp.isShowing() || !comp.isEnabled()) continue;
                entry.getValue().updateData.accept(dataObj);
            }
        }

        public <F extends Component> F bind(F comp, Binding binding) {
            this.d_bindings.put(comp, binding);
            return comp;
        }

        public <T, F extends Component> F bind(TypedProp<T> prop, F fld) {
            F f = fld;
            Objects.requireNonNull(f);
            F f2 = f;
            int n = 0;
            Binding<IMerlinObj> bindObj = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{guiTextField.class, ValueField.class, ColorButton.class}, f2, n)) {
                case 0 -> {
                    guiTextField textField = (guiTextField)f2;
                    yield new Binding<IMerlinObj>(data -> textField.setValue((String)data.get(prop)), data -> data.set(prop, textField.getValue()));
                }
                case 1 -> {
                    ValueField valField = (ValueField)f2;
                    yield new Binding<IMerlinObj>(data -> valField.setValue(data.get(prop)), data -> data.set(prop, valField.getValue()));
                }
                case 2 -> {
                    ColorButton colorButton = (ColorButton)f2;
                    yield new Binding<IMerlinObj>(data -> colorButton.setColor((Color)data.get(prop)), data -> data.set(prop, colorButton.getColor()));
                }
                default -> throw new IllegalArgumentException(fld.getClass().getName() + " not supported");
            };
            return this.bind(fld, bindObj);
        }
    }

    public static class Binding<T> {
        public final Consumer<T> updateComp;
        public final Consumer<T> updateData;

        public Binding(Consumer<T> updateComp, Consumer<T> updateData) {
            this.updateComp = updateComp;
            this.updateData = updateData;
        }
    }
}

