/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.dependencies.powerlaw;

import java.util.function.Function;
import java.util.function.Supplier;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.TypedProp;
import ventus.feature.dependencies.powerlaw.IPowerlawObj;
import ventus.feature.dependencies.powerlaw.LeakageAreaType;

public final class LeakageAreaTypeInfo {
    public final LeakageAreaType type;
    public final TypedProp<UnitDouble> prop;
    public final int unit;
    public final Function<UnitDouble, UnitDouble> convertToAreaM2;

    public LeakageAreaTypeInfo(LeakageAreaType type) {
        this.type = type;
        if (type == LeakageAreaType.ITEM) {
            this.prop = IPowerlawObj.LEAKAGE_AREA_PER_ITEM;
            this.unit = 2;
            this.convertToAreaM2 = areaPerItem -> areaPerItem.multiply(new UnitDouble(1.0, Unit.ONE)).convert(SI.METER.pow(2));
        } else if (type == LeakageAreaType.LENGTH) {
            this.prop = IPowerlawObj.LEAKAGE_AREA_PER_LENGTH;
            this.unit = 0;
            this.convertToAreaM2 = areaPerLength -> areaPerLength.multiply(new UnitDouble(1.0, SI.METER)).convert(SI.METER.pow(2));
        } else if (type == LeakageAreaType.AREA) {
            this.prop = IPowerlawObj.LEAKAGE_AREA_PER_AREA;
            this.unit = 10;
            this.convertToAreaM2 = areaPerArea -> areaPerArea.multiply(new UnitDouble(1.0, SI.METER.pow(2))).convert(SI.METER.pow(2));
        } else {
            throw new IllegalArgumentException(type.name());
        }
    }

    public void exec(Runnable perItem, Runnable perLength, Runnable perArea) {
        if (this.type == LeakageAreaType.ITEM) {
            perItem.run();
        } else if (this.type == LeakageAreaType.LENGTH) {
            perLength.run();
        } else if (this.type == LeakageAreaType.AREA) {
            perArea.run();
        } else {
            throw new IllegalArgumentException(this.type.name());
        }
    }

    public <T> T get(Supplier<T> perItem, Supplier<T> perLength, Supplier<T> perArea) {
        if (this.type == LeakageAreaType.ITEM) {
            return perItem.get();
        }
        if (this.type == LeakageAreaType.LENGTH) {
            return perLength.get();
        }
        if (this.type == LeakageAreaType.AREA) {
            return perArea.get();
        }
        throw new IllegalArgumentException(this.type.name());
    }
}

