/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.dependencies.powerlaw;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.ILabeled;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import ventus.Intl;
import ventus.data.IMerlinObj;
import ventus.data.property.Function1dProp;
import ventus.data.value.APiecewiseFunction1d;
import ventus.data.value.IFunction1d;
import ventus.data.value.PiecewiseFunction1d;
import ventus.feature.dependencies.powerlaw.CubicFlowFunction;
import ventus.feature.dependencies.powerlaw.LeakageAreaType;
import ventus.feature.dependencies.powerlaw.PowerlawModel;
import ventus.feature.props.DisplayProps;
import ventus.feature.props.PropComparisons;
import ventus.feature.props.PropertyDefs;
import ventus.unitsystem.SIUS;

public interface IPowerlawObj
extends IMerlinObj,
Serializable {
    public static final long serialVersionUID = 7829444618286808969L;
    public static final PropertyDefs<IPowerlawObj> PROP_TYPES = PropertyDefs.defsRoot(IPowerlawObj.class, PropertyDefs.none());
    public static final DisplayProp<PowerlawModel> POWERLAW_MODEL = (DisplayProp)DisplayProps.build((Object)"FlowElement.POWERLAW_MODEL", PowerlawModel.class, PowerlawModel.ORIFICE_AREA, Intl.intl("Powerlaw Model"), Intl.intl("Powerlaw Model for Element mass flow.")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().options(PowerlawModel.values())).attrFinish();
    public static final DisplayProp<UnitDouble> CROSS_SECTIONAL_AREA = (DisplayProp)DisplayProps.build((Object)"FlowElement.CROSS_SECTIONAL_AREA", new UnitDouble(1.0, SI.METER.pow(2)), Intl.intl("Cross-Sectional Area"), Intl.intl("Total area of the opening."), 2).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(2)).attrFinish();
    public static final DisplayProp<Double> PRESSURE_EXPONENT = (DisplayProp)DisplayProps.build((Object)"FlowElement.PRESSURE_EXPONENT", 0.65, Intl.intl("Flow Exponent"), Intl.intl("n of the mass flow powerlaw formula.")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().dbl()).attrFinish();
    public static final DisplayProp<Double> DISCHARGE_COEFFICIENT = (DisplayProp)DisplayProps.build((Object)"FlowElement.DISCHARGE_COEFFICIENT", 0.6, Intl.intl("Discharge Coefficient"), Intl.intl("C of the mass flow powerlaw formula.")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().dbl()).attrFinish();
    public static final DisplayProp<Double> REYNOLDS_NUMBER = (DisplayProp)DisplayProps.build((Object)"FlowElement.REYNOLDS_NUMBER", 30.0, Intl.intl("Reynolds Number"), Intl.intl("Relative ratio of viscous to inertial forces which helps dictate laminar vs. turbulent flow.")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().dbl()).attrFinish();
    public static final DisplayProp<UnitDouble> STAIR_SHAFT_DZ = (DisplayProp)DisplayProps.build((Object)"FlowElement.STAIR_SHAFT_DZ", new UnitDouble(3.0, SI.METER), Intl.intl("Distance Between Levels"), Intl.intl("Vertical distance between doorways of the stairwell."), 0).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> PRESSURE_DIFFERENCE = (DisplayProp)DisplayProps.build((Object)"FlowElement.PRESSURE_DIFFERENCE", new UnitDouble(10.0, SI.PASCAL), Intl.intl("Pressure Difference"), Intl.intl("The reference pressure difference for the associated leakage rating."), 15).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(15)).attrFinish();
    public static final DisplayProp<LeakageAreaType> LEAKAGE_AREA_TYPE = (DisplayProp)DisplayProps.build((Object)"FlowElement.LEAKAGE_AREA_TYPE", LeakageAreaType.class, LeakageAreaType.ITEM, Intl.intl("Leakage Area Type"), Intl.intl("Determines how the total leakage area for the flow path will be calculated.")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().options(LeakageAreaType.values())).attrFinish();
    @Deprecated
    public static final DisplayProp<UnitDouble> LEAKAGE_AREA = (DisplayProp)DisplayProps.build((Object)"FlowElement.LEAKAGE_AREA", new UnitDouble(1.0, SI.METER.pow(2)), Intl.intl("Leakage Area"), "", 2).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
    public static final DisplayProp<UnitDouble> LEAKAGE_AREA_PER_ITEM = (DisplayProp)DisplayProps.build((Object)"FlowElement.LEAKAGE_AREA_PER_ITEM", new UnitDouble(1.0, SI.METER.pow(2)), Intl.intl("Area per Item"), Intl.intl("Leakage Area per flow path item."), 2).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(2)).attrFinish();
    public static final DisplayProp<UnitDouble> LEAKAGE_AREA_PER_LENGTH = (DisplayProp)DisplayProps.build((Object)"FlowElement.LEAKAGE_AREA_PER_LENGTH", new UnitDouble(1.0, SI.METER), Intl.intl("Area per Unit Length"), Intl.intl("Leakage Area per flow path length."), 0).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> LEAKAGE_AREA_PER_AREA = (DisplayProp)DisplayProps.build((Object)"FlowElement.LEAKAGE_AREA_PER_AREA", new UnitDouble(3.5E-4, Unit.ONE), Intl.intl("Area per Unit Area"), Intl.intl("Leakage area per flow path area."), 10).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(10)).attrFinish();
    @Deprecated
    public static final UnitDouble PRE_202_LEAKAGE_AREA_PER_AREA = new UnitDouble(1.0, Unit.ONE);
    public static final DisplayProp<UnitDouble> PEOPLE_DENSITY = (DisplayProp)DisplayProps.build((Object)"FlowElement.PEOPLE_DENSITY", new UnitDouble(0.0, Unit.ONE.divide(SI.METER.pow(2))), Intl.intl("People Density"), Intl.intl("Density of people occupying the stairwell."), 22).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(8)).attrFinish();
    public static final DisplayProp<Boolean> STAIR_TREADS_OPEN = (DisplayProp)DisplayProps.build((Object)"FlowElement.STAIR_TREADS_OPEN", false, Intl.intl("Stair Treads"), Intl.intl("The stair tread can either be open or closed, affecting airflow.")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().booleanCustom(Intl.intl("is open"), Intl.intl("is closed"))).attrFinish();
    public static final DisplayProp<UnitDouble> PERIMETER = (DisplayProp)DisplayProps.build((Object)"FlowElement.PERIMETER", new UnitDouble(10.0, SI.METER), Intl.intl("Perimeter"), Intl.intl("Length of the perimeter of the cross-sectional area of the shaft, determining hydraulic diameter."), 0).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> ROUGHNESS = (DisplayProp)DisplayProps.build((Object)"FlowElement.ROUGHNESS", new UnitDouble(0.1, SI.METER), Intl.intl("Roughness"), Intl.intl("Average size of protrusions from the shaft wall into the airflow."), 0).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> MAX_FLOW_RATE = (DisplayProp)DisplayProps.build((Object)"FlowElement.MAX_FLOW_RATE", new UnitDouble(0.02, SI.METER.pow(3).divide(SI.SECOND)), Intl.intl("Vent Max Volume Flow Rate"), Intl.intl("Maximum airflow rate allowed through paths using this element."), 17).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(27)).attrFinish();
    public static final DisplayProp<UnitDouble> REGULATING_PRESSURE = (DisplayProp)DisplayProps.build((Object)"FlowElement.REGULATING_PRESSURE", new UnitDouble(0.5, SI.PASCAL), Intl.intl("Regulating Pressure"), Intl.intl("Approximate pressure difference above which airflow will be limited to the maximum flow rate."), 15).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(15)).attrFinish();
    public static final DisplayProp<UnitDouble> REVERSE_FLOW_FRACTION = (DisplayProp)DisplayProps.build((Object)"FlowElement.REVERSE_FLOW_FRACTION", new UnitDouble(1.0E-4, Unit.ONE), Intl.intl("Reverse Flow Fraction"), Intl.intl("Fraction of the Maximum Flow Rate that this element is limited to when the pressure difference is negative."), 10).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(10)).attrFinish();
    public static final DisplayProp<UnitDouble> CONSTANT_FAN_MAX_FLOW_RATE = (DisplayProp)DisplayProps.build((Object)"FlowElement.CONSTANT_FAN_MAX_FLOW_RATE", new UnitDouble(1.0, SI.KILOGRAM.divide(SI.SECOND)), Intl.intl("Fan Max Mass Flow Rate"), Intl.intl("Maximum constant mass flow rate allowed of this fan."), 17).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(26)).attrFinish();
    public static final DisplayProp<UnitDouble> CONSTANT_FAN_VOLUME_FLOW_RATE = (DisplayProp)DisplayProps.build((Object)"FlowElement.CONSTANT_FAN_VOLUME_FLOW_RATE", new UnitDouble(1.0, SI.METER.pow(3).divide(SI.SECOND)), Intl.intl("Fan Max Volume Flow Rate"), Intl.intl("Maximum volumetric flow rate allowed of this fan."), 27).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(27)).attrFinish();
    public static final DisplayProp<UnitDouble> PERFORMANCE_CURVE_ORIFICE_AREA = (DisplayProp)DisplayProps.build((Object)"FlowElement.PERFORMANCE_CURVE_ORIFICE_AREA", new UnitDouble(0.01, SI.METER.pow(2)), Intl.intl("Equivalent Orifice Area"), Intl.intl("Fan opening."), 2).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(2)).attrFinish();
    public static final DisplayProp<Double> PERFORMANCE_CURVE_PRESSURE_EXPONENT = (DisplayProp)DisplayProps.build((Object)"FlowElement.PERFORMANCE_CURVE_PRESSURE_EXPONENT", 0.5, Intl.intl("Cut-off Condition Flow Exponent"), Intl.intl("n of the mass flow powerlaw formula.")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().dbl()).attrFinish();
    public static final DisplayProp<Double> PERFORMANCE_CURVE_CUTOFF_RATIO = (DisplayProp)DisplayProps.build((Object)"FlowElement.PERFORMANCE_CURVE_CUTOFF_RATIO", 0.1, Intl.intl("Cut-off Ratio"), Intl.intl("Fan speed ratio.")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().dbl()).attrFinish();
    public static final Function1dProp PERFORMANCE_CURVE = PROP_TYPES.storeAsPlainOldData(new Function1dProp((Object)"FlowElement.PERFORMANCE_CURVE", (IFunction1d)IPowerlawObj.getInputDefault(), Intl.intl("Performance Curve"), Intl.intl("Edit Performance curve data."), Intl.intl("Flow Element"), new Function1dProp.Var(Intl.intl("Flow Rate"), 17, UnitDoubleVR.between(-1.7976931348623157E308, Double.MAX_VALUE, SI.KILOGRAM.divide(SI.SECOND), true, true)), new Function1dProp.Var(Intl.intl("Pressure"), 15, UnitDoubleVR.between(-1.7976931348623157E308, Double.MAX_VALUE, SI.PASCAL, true, true)), new Function1dProp.PredefFunction[0])).attrFinish();
    public static final Function1dProp Q_V_P_CURVE = PROP_TYPES.storeAsPlainOldData(new Function1dProp((Object)"FlowElement.Q_V_P_CURVE", (IFunction1d)IPowerlawObj.getQvPDefault(), Intl.intl("Q vs P"), Intl.intl("Volume flow as a function of pressure difference across the element."), Intl.intl("Flow Elements"), new Function1dProp.Var(Intl.intl("Pressure"), 15, UnitDoubleVR.between(-1.7976931348623157E308, Double.MAX_VALUE, SI.PASCAL, true, true)), new Function1dProp.Var(Intl.intl("Flow Rate"), 27, UnitDoubleVR.between(-1.7976931348623157E308, Double.MAX_VALUE, SI.METER.pow(3).divide(SI.SECOND), true, true)), new UnitDouble[]{new UnitDouble(0.0, SIUS.unit(15)), new UnitDouble(0.0, SIUS.unit(27)), new UnitDouble(20.0, SIUS.unit(15)), new UnitDouble(20.0, SIUS.unit(27))}, new Function1dProp.PredefFunction[0])).attrFinish();
    public static final DisplayProp<UnitDouble> DOOR_HEIGHT = (DisplayProp)DisplayProps.build((Object)"FlowElement.DOOR_HEIGHT", new UnitDouble(2.0, SI.METER), Intl.intl("Height"), Intl.intl("Doorway height"), 0).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> DOOR_WIDTH = (DisplayProp)DisplayProps.build((Object)"FlowElement.DOOR_WIDTH", new UnitDouble(0.8, SI.METER), Intl.intl("Width"), Intl.intl("Doorway width"), 0).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> CRACK_WIDTH = (DisplayProp)DisplayProps.build((Object)"IPowerlawObj.CRACK_WIDTH", new UnitDouble(0.002, SI.METER), Intl.intl("Crack Width"), Intl.intl("The overall width of the crack."), 0).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> CRACK_LENGTH = (DisplayProp)DisplayProps.build((Object)"IPowerlawObj.CRACK_LENGTH", new UnitDouble(2.0, SI.METER), Intl.intl("Crack Length"), Intl.intl("The overall length of the crack."), 0).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> FLOWRATE = (DisplayProp)DisplayProps.build((Object)"IPowerlawObj.FLOWRATE", new UnitDouble(0.019, SI.KILOGRAM.divide(SI.SECOND)), Intl.intl("Flow Rate"), Intl.intl("The measured flow rate across the data point."), 17).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(17)).attrFinish();
    public static final DisplayProp<UnitDouble> FLOWRATE1 = (DisplayProp)DisplayProps.build((Object)"IPowerlawObj.FLOWRATE1", new UnitDouble(0.019, SI.KILOGRAM.divide(SI.SECOND)), Intl.intl("Flow Rate (Point 1)"), Intl.intl("The measured flow rate across the first data point."), 17).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(17)).attrFinish();
    public static final DisplayProp<UnitDouble> FLOWRATE2 = (DisplayProp)DisplayProps.build((Object)"IPowerlawObj.FLOWRATE2", new UnitDouble(0.029, SI.KILOGRAM.divide(SI.SECOND)), Intl.intl("Flow Rate (Point 2)"), Intl.intl("The measured flow rate across the second data point."), 17).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(17)).attrFinish();
    public static final DisplayProp<UnitDouble> PRESSURE_DIFFERENCE1 = (DisplayProp)DisplayProps.build((Object)"IPowerLawObj.PRESSURE_DIFFERENCE1", new UnitDouble(4.0, SI.PASCAL), Intl.intl("Pressure Difference (Point 1)"), Intl.intl("The measured pressure drop across the first data point."), 15).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(15)).attrFinish();
    public static final DisplayProp<UnitDouble> PRESSURE_DIFFERENCE2 = (DisplayProp)DisplayProps.build((Object)"IPowerlawObj.PRESSURE_DIFFERENCE2", new UnitDouble(10.0, SI.PASCAL), Intl.intl("Pressure Difference (Point 2)"), Intl.intl("The measured pressure drop across the second data point."), 15).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(15)).attrFinish();
    public static final DisplayProp<UnitDouble> DUCT_ROUGHNESS = (DisplayProp)DisplayProps.build((Object)"IPowerlawObj.ROUGHNESS", new UnitDouble(0.09, SI.MILLI(SI.METER)), Intl.intl("Roughness"), Intl.intl("Average size of protrusions within the duct."), 0).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> DUCT_ORIFICE_CROSS_SECTIONAL_AREA = (DisplayProp)DisplayProps.build((Object)"IPowerlawObj.DUCT_CROSS_SECTIONAL_AREA", new UnitDouble(0.01, SI.METER.pow(2)), Intl.intl("Cross-Sectional Area"), Intl.intl("Total area of the opening."), 2).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(2)).attrFinish();
    public static final DisplayProp<Double> DUCT_ORIFICE_PRESSURE_EXPONENT = (DisplayProp)DisplayProps.build((Object)"IPowerlawObj.DUCT_PRESSURE_EXPONENT", 0.5, Intl.intl("Flow Exponent"), Intl.intl("n of the mass flow powerlaw formula.")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().dbl()).attrFinish();
    public static final DisplayProp<DuctShape> DUCT_SHAPE = (DisplayProp)DisplayProps.build((Object)"IPowerlawObj.DUCT_SHAPE", DuctShape.class, DuctShape.CIRCLE, Intl.intl("Duct Shape"), Intl.intl("The shape of the duct.")).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().options(DuctShape.values())).attrFinish();
    public static final DisplayProp<UnitDouble> DUCT_CIRCLE_DIAMETER = (DisplayProp)DisplayProps.build((Object)"IPowerlawObj.CIRCLE_DIAMETER", new UnitDouble(200.0, SI.MILLI(SI.METER)), Intl.intl("Diameter"), Intl.intl("The diameter of a circular duct."), 0).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> DUCT_RECT_HEIGHT = (DisplayProp)DisplayProps.build((Object)"IPowerlawObj.RECTANGULAR_HEIGHT", new UnitDouble(200.0, SI.MILLI(SI.METER)), Intl.intl("Height"), Intl.intl("The height dimension of a rectangular duct."), 0).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> DUCT_RECT_WIDTH = (DisplayProp)DisplayProps.build((Object)"IPowerlawObj.RECTANGULAR_WIDTH", new UnitDouble(200.0, SI.MILLI(SI.METER)), Intl.intl("Width"), Intl.intl("The width dimension of a rectangular duct."), 0).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> DUCT_OVAL_MAJOR = (DisplayProp)DisplayProps.build((Object)"IPowerlawObj.OVAL_MAJOR", new UnitDouble(200.0, SI.MILLI(SI.METER)), Intl.intl("Major Dimension"), Intl.intl("The major cross-sectional dimension of an oval duct."), 0).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> DUCT_OVAL_MINOR = (DisplayProp)DisplayProps.build((Object)"IPowerlawObj.OVAL_MINOR", new UnitDouble(200.0, SI.MILLI(SI.METER)), Intl.intl("Minor Dimension"), Intl.intl("The minor cross-sectional dimension of an oval duct."), 0).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> DUCT_PERIMETER = (DisplayProp)DisplayProps.build((Object)"IPowerlawObj.DUCT_PERIMETER", new UnitDouble(628.32, SI.MILLI(SI.METER)), Intl.intl("Perimeter"), Intl.intl("The perimeter of a generic duct."), 0).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> DUCT_FLOW_AREA = (DisplayProp)DisplayProps.build((Object)"IPowerlawObj.DUCT_FLOW_AREA", new UnitDouble(314.159, SI.CENTI(SI.METER).pow(2)), Intl.intl("Flow Area"), Intl.intl("The flow area of a generic duct."), 0).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> DUCT_LEAKAGE_RATE = (DisplayProp)DisplayProps.build((Object)"IPowerlawObj.LEAKAGE_RATE", new UnitDouble(0.0, NonSI.LITER.divide(SI.SECOND).divide(SI.METER.pow(2))), Intl.intl("Leakage Rate"), Intl.intl("The rate at which air escapes the duct and enters the surrounding zone."), 28).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(28)).attrFinish();

    private static PiecewiseFunction1d getInputDefault() {
        APiecewiseFunction1d.Entry[] input = new APiecewiseFunction1d.Entry[]{new APiecewiseFunction1d.Entry(SIUS.newud(0.0, 17), SIUS.newud(150.0, 15)), new APiecewiseFunction1d.Entry(SIUS.newud(2.0, 17), SIUS.newud(125.0, 15)), new APiecewiseFunction1d.Entry(SIUS.newud(3.0, 17), SIUS.newud(110.0, 15)), new APiecewiseFunction1d.Entry(SIUS.newud(4.0, 17), SIUS.newud(60.0, 15))};
        return new PiecewiseFunction1d(input);
    }

    private static APiecewiseFunction1d getQvPDefault() {
        APiecewiseFunction1d.Entry[] input = new APiecewiseFunction1d.Entry[]{new APiecewiseFunction1d.Entry(SIUS.newud(0.0, 15), SIUS.newud(0.0, 27)), new APiecewiseFunction1d.Entry(SIUS.newud(1.0, 15), SIUS.newud(2.0, 27)), new APiecewiseFunction1d.Entry(SIUS.newud(4.0, 15), SIUS.newud(7.0, 27)), new APiecewiseFunction1d.Entry(SIUS.newud(10.0, 15), SIUS.newud(10.0, 27))};
        return new CubicFlowFunction(input);
    }

    public static Collection<Object> getDuctFlowElementRejectedProps() {
        return List.of(LEAKAGE_AREA_TYPE, LEAKAGE_AREA, LEAKAGE_AREA_PER_ITEM, LEAKAGE_AREA_PER_LENGTH, LEAKAGE_AREA_PER_AREA, PERIMETER, ROUGHNESS, MAX_FLOW_RATE, REGULATING_PRESSURE, REVERSE_FLOW_FRACTION, DOOR_HEIGHT, DOOR_WIDTH, CRACK_LENGTH, CRACK_WIDTH, FLOWRATE, FLOWRATE1, FLOWRATE2, PRESSURE_DIFFERENCE1, PRESSURE_DIFFERENCE2, PRESSURE_EXPONENT, CROSS_SECTIONAL_AREA);
    }

    public static Collection<Object> getFlowElementRejectedProps() {
        return List.of(DUCT_ROUGHNESS, DUCT_SHAPE, DUCT_CIRCLE_DIAMETER, DUCT_RECT_HEIGHT, DUCT_RECT_WIDTH, DUCT_OVAL_MAJOR, DUCT_OVAL_MINOR, DUCT_PERIMETER, DUCT_FLOW_AREA, DUCT_LEAKAGE_RATE, DUCT_ORIFICE_PRESSURE_EXPONENT, DUCT_ORIFICE_CROSS_SECTIONAL_AREA);
    }

    public static enum DuctShape implements ILabeled
    {
        CIRCLE(Intl.intl("Circle"), Intl.intl(""), 0),
        RECTANGLE(Intl.intl("Rectangle"), Intl.intl(""), 1),
        OVAL(Intl.intl("Oval"), Intl.intl(""), 2),
        OTHER(Intl.intl("Other"), Intl.intl(""), 3);

        public final String name;
        public final String description;
        public final int shape_id;

        private DuctShape(String name, String description, int id) {
            this.name = name;
            this.description = description;
            this.shape_id = id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

