/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.dependencies.powerlaw;

import java.awt.Color;
import java.awt.EventQueue;
import java.util.Arrays;
import java.util.Vector;
import java.util.function.UnaryOperator;
import javax.swing.JOptionPane;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.Graph;
import thunderheadeng.gui.LWSeries;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.util.PlotData;
import ventus.Intl;
import ventus.VentusApp;
import ventus.data.property.Function1dProp;
import ventus.data.value.APiecewiseFunction1d;
import ventus.data.value.PiecewiseFunction1d;
import ventus.feature.dependencies.powerlaw.CubicFanPerformanceCurveUtil;
import ventus.gui.value.PiecewiseFunction1dEditor;

public final class CubicPolyFunction1dEditor
extends PiecewiseFunction1dEditor {
    private static final long serialVersionUID = 1L;
    private final int d_minEntries;

    public CubicPolyFunction1dEditor(Function1dProp prop) {
        super(prop);
        this.d_minEntries = 4;
        guiDefaultTableModel tableModel = this.getTableModel();
        tableModel.addTableModelListener(e -> {
            if (!this.validateData(false, false)) {
                return;
            }
            this.updateCurve();
        });
    }

    @Override
    public void loadValue(APiecewiseFunction1d var) {
        super.loadValue(new CubicPoly(var.getInput()));
    }

    @Override
    public APiecewiseFunction1d saveValue(Mediator mediator) {
        return new CubicPoly(this.getEntries());
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        int numRows = this.getTableModel().getRowCount();
        if (numRows < this.d_minEntries) {
            if (showWarn) {
                String msg = String.format(Intl.intl("cubic polynomial curve requires %d points."), this.d_minEntries);
                JOptionPane.showMessageDialog(this, msg, Intl.intl("Incomplete Entries"), 0);
            }
            return false;
        }
        if (showWarn && this.checkForInflectionPoints()) {
            JOptionPane.showMessageDialog(this, Intl.intl("Inflection point existed."), Intl.intl("Errors in Table"), 0);
            return false;
        }
        return true;
    }

    private boolean checkForInflectionPoints() {
        CubicFanPerformanceCurveUtil.CurveData curveData = CubicFanPerformanceCurveUtil.getCurveData(this.getEntries(), null, null);
        double[] coefficients = curveData.coefficients;
        return coefficients[2] * coefficients[2] - 3.0 * coefficients[1] * coefficients[3] >= 0.0;
    }

    public void resetSeriesWithMarks() {
        this.setSeries(null);
        this.getGraph().reset();
        APiecewiseFunction1d val = (APiecewiseFunction1d)this.getValue();
        if (val != null) {
            this.loadValue((APiecewiseFunction1d)this.getValue());
            this.addPoints();
        }
        EventQueue.invokeLater(() -> this.getGraph().repaint());
    }

    public void addPoints() {
        APiecewiseFunction1d.Entry[] entries = this.getEntries();
        int num = entries.length;
        APiecewiseFunction1d.Entry[] entrySorted = Arrays.copyOf(entries, num);
        Arrays.sort(entrySorted, (e1, e2) -> e1.x.compareTo(e2.x));
        double[] points = new double[num * 2];
        Unit ux = VentusApp.getApp().getUnitSystem().getUnit(this.getProp().x.unitType);
        Unit uy = VentusApp.getApp().getUnitSystem().getUnit(this.getProp().y.unitType);
        int i = 0;
        int j = 0;
        while (i < num) {
            points[j] = entrySorted[i].x.getValue(ux);
            points[j + 1] = entrySorted[i].y.getValue(uy);
            ++i;
            j += 2;
        }
        PlotData pd = new PlotData(ux, uy, false, points);
        Graph graph = this.getGraph();
        PiecewiseFunction1d newfunc = PiecewiseFunction1d.newFunction(pd);
        LWSeries markedSeries = CubicPolyFunction1dEditor.toSeries(graph, this.getProp(), newfunc, Intl.intl(""), Color.RED, 9, 5);
        this.addSeries(markedSeries);
        graph.setLegendVisible(false);
    }

    private boolean checksForDataSet(Vector<Vector> dataset) {
        int counter = 0;
        for (Vector v : dataset) {
            if (!Arrays.stream(v.toArray()).allMatch(i -> i != null)) continue;
            ++counter;
        }
        return counter < 2;
    }

    public void updateCurve() {
        Function1dProp prop = this.getProp();
        Graph graph = this.getGraph();
        APiecewiseFunction1d func = null;
        LWSeries loadedSeries = this.getSeries();
        if (this.checksForDataSet(this.getTableModel().getDataVector())) {
            this.removeSeries(loadedSeries);
            return;
        }
        int numRows = this.getTableModel().getRowCount();
        if (numRows < this.d_minEntries) {
            return;
        }
        func = this.saveValue(null);
        graph.reset();
        loadedSeries = CubicPolyFunction1dEditor.toSeries(graph, prop, func, Intl.intl(""), Color.BLUE, 14, 0);
        this.addSeries(loadedSeries);
        this.setSeries(loadedSeries);
        this.addPoints();
    }

    private static class CubicPoly
    extends APiecewiseFunction1d {
        private static final long serialVersionUID = 1L;
        private final double[] coefficients;
        private final APiecewiseFunction1d.Entry[] d_input;
        private final APiecewiseFunction1d.Entry[] d_output;

        public CubicPoly(APiecewiseFunction1d.Entry[] entries) {
            this.d_input = entries;
            if (entries.length < 4) {
                this.d_output = Arrays.copyOf(this.d_input, this.d_input.length);
                this.coefficients = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
                return;
            }
            CubicFanPerformanceCurveUtil.CurveData curveData = CubicFanPerformanceCurveUtil.getCurveData(entries, null, null);
            this.coefficients = curveData.coefficients;
            this.d_output = this.generateOutputPoints(500);
        }

        @Override
        public String format(UnaryOperator<Unit> getDisplayUnit) {
            return Intl.intl("Cubic Polynomial Function");
        }

        @Override
        public APiecewiseFunction1d.Entry[] getInput() {
            return this.d_input;
        }

        @Override
        public APiecewiseFunction1d.Entry[] getOutput() {
            return this.d_output;
        }

        @Override
        public double calculateYValue(double x) {
            return this.coefficients[0] + this.coefficients[1] * x + this.coefficients[2] * (x * x) + this.coefficients[3] * (x * x * x);
        }
    }
}

