/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.dependencies.powerlaw;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.swing.JOptionPane;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.Mediator;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.data.property.Function1dProp;
import ventus.data.value.APiecewiseFunction1d;
import ventus.gui.value.PiecewiseFunction1dEditor;
import ventus.unitsystem.SIUS;
import ventus.util.MerlinUtil;

public final class CubicFlowFunction
extends APiecewiseFunction1d {
    private final double[] a;
    private final double[] b;
    private final double[] c;
    private final double[] d;
    private final double[] inputXValues;
    private final double[] inputYValues;
    private final APiecewiseFunction1d.Entry[] d_input;
    private final APiecewiseFunction1d.Entry[] d_output;

    public CubicFlowFunction(APiecewiseFunction1d.Entry ... input) {
        this.d_input = input;
        int numPoints = this.d_input.length;
        this.inputXValues = new double[numPoints];
        this.inputYValues = new double[numPoints];
        assert (numPoints > 1);
        this.a = new double[numPoints];
        this.b = new double[numPoints - 1];
        this.c = new double[numPoints - 1];
        this.d = new double[numPoints - 1];
        if (numPoints < 4) {
            this.d_output = Arrays.copyOf(this.d_input, numPoints);
            return;
        }
        LinkedHashSet<APiecewiseFunction1d.Entry> vals = new LinkedHashSet<APiecewiseFunction1d.Entry>();
        Arrays.sort(this.d_input, APiecewiseFunction1d.Entry::compareTo);
        for (int i = 0; i < this.d_input.length; ++i) {
            APiecewiseFunction1d.Entry entry = this.d_input[i];
            if (vals.add(entry)) {
                UnitDouble x = entry.x;
                UnitDouble y = entry.y;
                if (x == null || y == null) continue;
                this.inputXValues[i] = x.getValue(x.getUnit());
                this.inputYValues[i] = y.getValue(y.getUnit());
                continue;
            }
            --numPoints;
        }
        this.calculateSplineCoefficients();
        this.d_output = this.generateOutputPoints(500);
    }

    @Override
    public String format(UnaryOperator<Unit> getDisplayUnit) {
        return Intl.intl("Cubic Flow Function");
    }

    private void calculateSplineCoefficients() {
        int j;
        int n = this.getInput().length;
        double[] dx = new double[n - 1];
        double[] rhs = new double[n - 2];
        double[] upper = new double[n - 2];
        double[] main = new double[n - 2];
        double[] lower = new double[n - 2];
        for (int j2 = 0; j2 < n - 1; ++j2) {
            dx[j2] = this.inputXValues[j2 + 1] - this.inputXValues[j2];
        }
        main[0] = 1.0;
        rhs[0] = (this.inputYValues[1] - this.inputYValues[0]) / dx[0];
        double slopeBackward = (this.inputYValues[2] - this.inputYValues[1]) / dx[1];
        for (j = 2; j < n - 2; ++j) {
            double slopeForward = (this.inputYValues[j + 1] - this.inputYValues[j]) / dx[j];
            lower[j - 1] = dx[j];
            main[j - 1] = 2.0 * (dx[j - 1] + dx[j]);
            upper[j - 1] = dx[j - 1];
            rhs[j - 1] = 3.0 * (slopeForward * dx[j - 1] + slopeBackward * dx[j]);
            slopeBackward = slopeForward;
        }
        main[n - 2 - 1] = 1.0;
        rhs[n - 2 - 1] = (this.inputYValues[n - 1] - this.inputYValues[n - 2]) / dx[n - 2];
        this.solveTridiagonal(n - 2, lower, main, upper, rhs);
        this.b[0] = rhs[0];
        for (j = 0; j < n; ++j) {
            if (j > 0 && j < n - 2) {
                double dd2 = (this.inputYValues[j + 1] - this.inputYValues[j]) / dx[j];
                this.b[j] = rhs[j - 1];
                this.c[j] = (3.0 * dd2 - 2.0 * rhs[j - 1] - rhs[j]) / dx[j];
                this.d[j] = (rhs[j - 1] - 2.0 * dd2 + rhs[j]) / (dx[j] * dx[j]);
            }
            this.a[j] = this.inputYValues[j];
        }
        this.b[n - 2] = rhs[n - 3];
    }

    private void solveTridiagonal(int neq, double[] lower, double[] main, double[] upper, double[] rhs) {
        int j;
        for (j = 1; j < neq; ++j) {
            double factor = lower[j] / main[j - 1];
            main[j] = main[j] - factor * upper[j - 1];
            rhs[j] = rhs[j] - factor * rhs[j - 1];
        }
        int n = neq - 1;
        rhs[n] = rhs[n] / main[neq - 1];
        for (j = neq - 2; j >= 0; --j) {
            rhs[j] = (rhs[j] - upper[j] * rhs[j + 1]) / main[j];
        }
    }

    @Override
    public double calculateYValue(double x) {
        int index = 0;
        for (int i = 0; i < this.inputXValues.length - 1; ++i) {
            if (!(this.inputXValues[i] <= x) || !(x <= this.inputXValues[i + 1])) continue;
            index = i;
            break;
        }
        double h = x - this.inputXValues[index];
        return this.a[index] + h * (this.b[index] + h * (this.c[index] + h * this.d[index]));
    }

    public double slope(int i) {
        assert (i > 0 && i < this.getOutput().length);
        assert (this.inputXValues.length > 1);
        APiecewiseFunction1d.Entry entry2 = this.getOutput()[i];
        APiecewiseFunction1d.Entry entry1 = this.getOutput()[i - 1];
        return entry2.y.sub(entry1.y).divide(entry2.x.sub(entry1.x)).getRawValue();
    }

    @Override
    public APiecewiseFunction1d.Entry[] getInput() {
        return this.d_input;
    }

    @Override
    public APiecewiseFunction1d.Entry[] getOutput() {
        return this.d_output;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof CubicFlowFunction && super.equals(obj);
    }

    public static class CubicSplineEditor
    extends PiecewiseFunction1dEditor {
        private static final long serialVersionUID = 1L;
        private final Function1dProp d_prop;
        private final int d_minEntries;
        private final int validationOptions;
        public static final int POSITIVE_SLOPE = 1;

        public CubicSplineEditor(Function1dProp prop, int minEntries) {
            this(prop, minEntries, 0);
        }

        public CubicSplineEditor(Function1dProp prop, int minEntries, int validation) {
            super(prop);
            this.d_prop = prop;
            this.d_minEntries = minEntries;
            this.validationOptions = validation;
        }

        @Override
        protected APiecewiseFunction1d saveValue(Mediator mediator) {
            return new CubicFlowFunction(this.getEntries());
        }

        @Override
        protected void loadValue(APiecewiseFunction1d var) {
            super.loadValue(new CubicFlowFunction(var.getInput()));
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            boolean valid = true;
            int numRows = this.getTableModel().getRowCount();
            if (numRows < this.d_minEntries) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(this, String.format(Intl.intl("There must be at least %d entries."), this.d_minEntries), Intl.intl("Not Enough Entries"), 0);
                }
                valid = false;
            }
            if ((this.validationOptions & 1) != 0) {
                valid = valid && (this.validateSlope((APiecewiseFunction1d)this.getValue(), SIUS.unit(this.d_prop.x.unitType), SIUS.unit(this.d_prop.y.unitType), showWarn) || !allowModify);
            }
            LinkedHashSet<UnitDouble> vals = new LinkedHashSet<UnitDouble>();
            for (int row = 0; row < numRows; ++row) {
                UnitDouble x = (UnitDouble)this.getTableModel().getValueAt(row, 0);
                if (x == null || vals.add(x)) continue;
                String msg = String.format(Intl.intl("Multiple values specified for %1$s=%2$s"), this.d_prop.x.desc, MerlinUtil.format(x, this.d_prop.x.unitType));
                this.getTable().flagInvalidCell(row, 0, showWarn, allowModify, msg);
                valid = false;
            }
            if (valid) {
                return super.validateData(showWarn, allowModify);
            }
            return false;
        }

        private boolean validateSlope(APiecewiseFunction1d func, Unit ux, Unit uy, boolean showWarn) {
            Function<Integer, Integer> getSegment = i -> {
                APiecewiseFunction1d.Entry point = func.getOutput()[i];
                for (int j = 0; j < func.getInput().length; ++j) {
                    APiecewiseFunction1d.Entry entry = func.getInput()[j];
                    if (!theUtil.lt(point.x.get(ux), entry.x.get(ux), 1.0E-6)) continue;
                    return j;
                }
                return -1;
            };
            ArrayList<Double> slopes = CubicSplineEditor.getSlope(func);
            LinkedHashSet<Integer> less0Segments = new LinkedHashSet<Integer>();
            LinkedHashSet<Integer> eq0Segments = new LinkedHashSet<Integer>();
            for (int i2 = 0; i2 < slopes.size(); ++i2) {
                if (theUtil.lt0(slopes.get(i2), 1.0E-6)) {
                    less0Segments.add(getSegment.apply(i2));
                }
                if (!theUtil.eq0(slopes.get(i2), 0.001)) continue;
                eq0Segments.add(getSegment.apply(i2));
            }
            if (!(less0Segments.isEmpty() && eq0Segments.isEmpty() || !showWarn)) {
                int seg;
                StringBuilder sb = new StringBuilder();
                Iterator iterator = less0Segments.iterator();
                while (iterator.hasNext()) {
                    seg = (Integer)iterator.next();
                    sb.append(String.format(Intl.intl("Found f' < 0 in segment [%d, %d]\n"), seg, seg + 1));
                }
                iterator = eq0Segments.iterator();
                while (iterator.hasNext()) {
                    seg = (Integer)iterator.next();
                    sb.append(String.format(Intl.intl("Found f' near 0 in segment [%d, %d]\n"), seg, seg + 1));
                }
                sb.append(Intl.intl("\nNegative or zero slope will be prohibitive\nwhen attempting to run the simulation."));
                int status = !less0Segments.isEmpty() ? 0 : 2;
                String title = !less0Segments.isEmpty() ? Intl.intl("Slope Error") : Intl.intl("Slope Warning");
                JOptionPane.showMessageDialog(this, sb.toString(), title, status);
            }
            return less0Segments.isEmpty();
        }

        private static ArrayList<Double> getSlope(APiecewiseFunction1d func) {
            ArrayList<Double> slopes = new ArrayList<Double>();
            if (func instanceof CubicFlowFunction) {
                CubicFlowFunction cf = (CubicFlowFunction)func;
                for (int i = 1; i < func.getOutput().length; ++i) {
                    slopes.add(cf.slope(i));
                }
            }
            return slopes;
        }

        @Override
        protected void updateValue() {
            assert (this.isLive());
            if (super.validateData(false, false)) {
                this.setValue(this.saveValue(null));
            }
        }
    }
}

