/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ahs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TypedProp;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.CompElementActions;
import ventus.data.IMerlinObj;
import ventus.feature.ahs.AHSPoint;
import ventus.feature.ahssimple.SimpleAHS;
import ventus.feature.comps.ISelectionRibbon;
import ventus.feature.comps.SelectionRibbonHelper;
import ventus.gui.MerlinComboBox;
import ventus.gui.MerlinUDF;
import ventus.gui.guiUtil;
import ventus.gui.value.ScheduleField;
import ventus.mv.gui.PropConnections;
import ventus.mv.gui.SelectionEditorPanel;

public class AHSPointRibbon
implements ISelectionRibbon {
    private guiComboBox<SimpleAHS> d_simpleAHSComboBox;
    private ScheduleField d_multiplierFld;
    private final ArrayList<SelectionEditorPanel.EditorPanel> d_sections = new ArrayList();

    private void createSections() {
        guiComboBox<AHSPoint.Types> typeCB = guiUtil.newCombo(type -> type != null ? guiUtil.encodeToHtmlLabels(type.name, type.desc) : new Pair<String, String>(Intl.intl("<mixed>"), null), AHSPoint.Types.values());
        MerlinUDF flowRateField = new MerlinUDF(17, DoubleVR.above(0.0, true));
        this.d_simpleAHSComboBox = new MerlinComboBox(VentusApp.getAppData(), SimpleAHS.class, (IMerlinObj[])new SimpleAHS[0]);
        PropConnections.ComboPropConn<SimpleAHS> systemConn = new PropConnections.ComboPropConn<SimpleAHS>(new CompElementActions.DefProp(AHSPoint.AHS), this.d_simpleAHSComboBox);
        PropConnections.ScheduleProp multiplierConn = SelectionRibbonHelper.scheduleConn(AHSPoint.MULTIPLIER, AHSPoint.MULTIPLIER.name, 10, UnitDoubleVR.ge(0.0, Unit.ONE));
        this.d_multiplierFld = (ScheduleField)multiplierConn.getControl();
        SelectionEditorPanel.EditorPanel section1 = this.newSection();
        section1.addConnection(new PropConnections.ComboPropConn<AHSPoint.Types>(new CompElementActions.DefProp(AHSPoint.TYPES), typeCB));
        section1.addConnection(new PropConnections.UDPropConnection((CompElementActions.IObjectProp<IMerlinObj, UnitDouble>)new CompElementActions.DefProp<IMerlinObj, UnitDouble>(AHSPoint.DESIGN_FLOW_RATE), flowRateField));
        SelectionEditorPanel.EditorPanel section2 = this.newSection();
        section2.addConnection(systemConn);
        section2.addConnection(multiplierConn);
        GridBagHelper gb = new GridBagHelper(section1);
        gb.rowSpace = 1;
        gb.addRow(new guiLabel(Intl.intl("Types:")), typeCB, 0, 1.0);
        gb.addRow(new guiLabel(Intl.intl("Design Flow Rate:")), flowRateField, 1.0);
        GridBagHelper gb2 = new GridBagHelper(section2);
        gb2.rowSpace = 1;
        gb2.addRow(new guiLabel(Intl.intl("Air Handling System:")), this.d_simpleAHSComboBox, 0, 1.0);
        gb2.addRow(guiUtil.lblProp(AHSPoint.MULTIPLIER), this.d_multiplierFld, 0, 1.0);
    }

    private SelectionEditorPanel.EditorPanel newSection() {
        SelectionEditorPanel.EditorPanel panel = new SelectionEditorPanel.EditorPanel();
        this.d_sections.add(panel);
        return panel;
    }

    @Override
    public boolean isEnabled(Set<TypedProp<?>> shared, Set<TypedProp<?>> unshared) {
        return shared.contains(AHSPoint.ROOM);
    }

    @Override
    public Collection<SelectionEditorPanel.EditorPanel> getSections() {
        if (this.d_sections.isEmpty()) {
            this.createSections();
        }
        return this.d_sections;
    }
}

