/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.value;

import java.util.HashMap;
import java.util.TreeSet;
import java.util.function.UnaryOperator;
import org.jscience.physics.units.Unit;
import ventus.Intl;
import ventus.data.property.Function1dProp;
import ventus.data.value.APiecewiseFunction1d;
import ventus.unitsystem.SIUS;

public class TrigonometricFunction
extends APiecewiseFunction1d {
    private final APiecewiseFunction1d.Entry[] d_input;
    private final APiecewiseFunction1d.Entry[] d_output;
    private final double p0;
    private final double p90;
    private final double p180;
    private final double p270;

    public TrigonometricFunction(Function1dProp prop, APiecewiseFunction1d.Entry[] input) {
        this.d_input = input;
        HashMap<Double, Double> vals = new HashMap<Double, Double>();
        for (APiecewiseFunction1d.Entry e : this.d_input) {
            vals.put(e.x.get(e.x.getUnit()), e.y.get(e.y.getUnit()));
        }
        this.p0 = vals.computeIfAbsent(0.0, d -> 0.0);
        this.p90 = vals.computeIfAbsent(90.0, d -> 0.0);
        this.p180 = vals.computeIfAbsent(180.0, d -> 0.0);
        this.p270 = vals.computeIfAbsent(270.0, d -> 0.0);
        input = new APiecewiseFunction1d.Entry[vals.size()];
        TreeSet keys = new TreeSet(vals.keySet());
        int i = 0;
        for (Double key : keys) {
            input[i] = new APiecewiseFunction1d.Entry(SIUS.newud(key, prop.x.unitType), SIUS.newud((Double)vals.get(key), prop.y.unitType));
            ++i;
        }
        this.d_output = this.generateOutputPoints(361);
    }

    @Override
    public String format(UnaryOperator<Unit> getDisplayUnit) {
        return Intl.intl("Trigonometric Function");
    }

    @Override
    public APiecewiseFunction1d.Entry[] getInput() {
        return this.d_input;
    }

    @Override
    public APiecewiseFunction1d.Entry[] getOutput() {
        return this.d_output;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof TrigonometricFunction && super.equals(obj);
    }

    @Override
    protected double calculateYValue(double x) {
        double r = Math.toRadians(x);
        double cosR = Math.cos(r);
        double sinR = Math.sin(r);
        double term2 = x > 90.0 && x <= 270.0 ? -(this.p0 - this.p180) * Math.pow(cosR * cosR, 0.375) : (this.p0 - this.p180) * Math.pow(cosR * cosR, 0.375);
        return 0.5 * ((this.p0 + this.p180) * Math.pow(cosR * cosR, 0.25) + term2 + (this.p90 + this.p270) * Math.pow(sinR, 4.0) + (this.p90 - this.p270) * sinR);
    }
}

