/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.value;

import java.util.TreeSet;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;
import ventus.data.value.Schedule;

public class ScheduleUtil {
    public static boolean isTimeSorted(Schedule schedule) {
        UnitDouble prevT = new UnitDouble(0.0, SI.SECOND);
        for (Schedule.Entry entry : schedule.getEntries()) {
            if (entry.t.le(prevT, 1.0E-6)) {
                return false;
            }
            prevT = entry.t;
        }
        return true;
    }

    public static Schedule fixTimeSort(Schedule schedule) {
        UnitDouble initVal = schedule.getInitialValue();
        UnitDouble tZero = new UnitDouble(0.0, SI.SECOND);
        TreeSet<Schedule.Entry> entries = new TreeSet<Schedule.Entry>();
        for (Schedule.Entry entry : schedule.getEntries()) {
            if (!entry.t.gt(tZero, 1.0E-6)) continue;
            entries.add(entry);
        }
        Schedule newSchedule = new Schedule(schedule.type, initVal, entries.toArray(new Schedule.Entry[0]));
        assert (ScheduleUtil.isTimeSorted(schedule));
        return newSchedule;
    }
}

