/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.schematics.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.ElementUniform;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.elem.IPrimElements;
import thunderheadeng.geometry.objs.node.AGeomNode;
import thunderheadeng.geometry.objs.node.GeomNodeGroup;
import thunderheadeng.geometry.objs.node.GeomNodeLeaf;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.CancelObjectPicking;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.ProxyIsectCollector;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.CachedValue;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.SoftCachedValue;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.data.AMerlinObj;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.ISchematicObj;
import ventus.data.schematics.geom.ASchematicComp;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.schematics.geom.ISchematicRoomColorSrc;
import ventus.data.schematics.geom.RoomUtil;
import ventus.data.schematics.geom.SchematicModelGeom;
import ventus.data.value.Schedule;
import ventus.feature.dependencies.powerlaw.PowerlawModel;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.props.DisplayProps;
import ventus.feature.props.PropComparisons;
import ventus.feature.props.PropertyDefs;
import ventus.geom.GeomUtil;
import ventus.geom.Geometry;
import ventus.geom.IMerlinDispProps;
import ventus.io.VentusIO;
import ventus.io.VentusOIS;
import ventus.unitsystem.SIUS;
import ventus.util.Dependencies;

public class SchematicRoom
extends ASchematicComp
implements Serializable,
ISchematicRoom,
IDirectDependent<VentusData>,
IEventObserver {
    static final long serialVersionUID = 1L;
    public static final Logger LOGGER = Logger.getLogger(SchematicRoom.class.getSimpleName());
    private static final Color COLOR = new Color(0.86f, 0.83f, 1.0f);
    public static final Elements.ElemProp<Boolean> PICKABLE_ELEM = new Elements.ElemProp<Boolean>(-349025687, "SchematicRoom.PICKABLE_ELEM", Boolean.class, new ElementUniform<Boolean>(true));
    public static final int DEFAULT_CLEANUP_OPTIONS = 23;
    public static final Object AREA_ADDED = "CopPolyNavGeom.AREA_ADDED";
    public static final Object AREA_SUBTRACTED = "CopPolyNavGeom.AREA_SUBTRACTED";
    public static final Object CLEARED = "CopPolyNavGeom.CLEARED";
    public static final PropertyDefs<SchematicRoom> PROP_TYPES = PropertyDefs.defsInheritPropsOnlyMultiple(SchematicRoom.class, PropertyDefs.legacy(SchematicRoom::initCacheAndTopology), List.of(ASchematicComp.PROP_TYPES, ISchematicRoom.PROP_TYPES), Predicates.alwaysTrue());
    static final TypedProp<Set<ISchematicObj>> TOPOLOGY = TypedProps.buildGeneric("SchematicRoom.TOPOLOGY", Set.class, new LinkedHashSet()).attrStoreAsTopologyIndirect(PROP_TYPES, obj -> new LinkedHashSet()).attrGetter(room -> room.d_topology, Stream.empty()).attrSetter((prop, room, val) -> {
        room.d_topology = val;
        room.markTopoDirty();
    }, (prop, room, val) -> {
        room.d_topology = val;
    }).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Schedule> TEMPERATURE_SCHEDULE = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"SchematicRoom.TEMPERATURE_SCHEDULE", Schedule.class, Schedule.newConstant(new UnitDouble(20.0, SI.CELSIUS)), Intl.intl("Temperature"), "").attrFormatValue(sch -> sch.format(14))).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(SchematicRoom::getTemperatureSchedule, Stream.empty()).attrSetter(SchematicRoom::setTemperatureSchedule, null).attrSurrogateEquals(null).attrComparisonEditor(PropComparisons.factory().schedule(14)).attrFinish();
    public static final TypedProp<Boolean> TEMP_DEFINEDLOCALLY = TypedProps.build((Object)"SchematicRoom.TEMP_OVERWRITE", false).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(SchematicRoom::getTempDefinedLocally, Stream.empty()).attrSetter(SchematicRoom::setTempDefinedLocally, null).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<IMaterial[]> MATERIAL = PROP_TYPES.storeAsPlainOldData(VentusData.MATERIAL).attrGetter(SchematicRoom::getMaterialArray, Stream.empty()).attrSetter(SchematicRoom::setMaterialArray, null).attrDependency(prop -> GeomUtil.newMatDependency()).attrSurrogateEquals(null).attrFinish();
    private static final Matrix4d s_identity = new Matrix4d();
    @SkipDep
    private Model d_geometry;
    private CachedValue<Boolean> d_overlapsSelf;
    @SkipDep
    private SoftCachedValue<IGeomNode> d_wallGeom;
    @SkipDep
    private SoftCachedValue<IPropsSrc> d_wallDrawProps;
    private boolean d_useManualVolume;
    private UnitDouble d_manualVolume;
    @Deprecated
    private UnitDouble d_temperature = null;
    private Schedule d_temperatureSchedule;
    private boolean d_tempDefinedLocally;
    private ISchematicRoom.Type d_type = ISchematicRoom.Type.ZONE;
    private IMaterial d_material;
    @SkipDep
    private transient Set<ISchematicObj> d_topology;

    public SchematicRoom(String name) {
        this(name, new Model(), 0);
    }

    public SchematicRoom(String name, Model geometry) {
        this(name, geometry, 23);
    }

    public SchematicRoom(String name, Model geometry, int cleanupOptions) {
        super(name);
        super.setColor(COLOR);
        this.initCacheAndTopology();
        this.d_geometry = geometry;
        this.d_geometry = RoomUtil.cleanup(this.d_geometry, cleanupOptions, Predicates.alwaysTrue());
        this.d_temperatureSchedule = Schedule.newConstant(new UnitDouble(20.0, SI.CELSIUS));
        this.d_tempDefinedLocally = false;
        this.d_useManualVolume = (Boolean)ISchematicRoom.USE_MANUAL_VOLUME.defVal;
        this.d_manualVolume = (UnitDouble)ISchematicRoom.MANUAL_VOLUME.defVal;
    }

    private void initCacheAndTopology() {
        this.d_topology = new LinkedIdentityHashSet<ISchematicObj>();
        this.d_wallGeom = new SoftCachedValue();
        this.d_wallDrawProps = new SoftCachedValue();
        this.d_overlapsSelf = new CachedValue();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.d_type = ISchematicRoom.Type.ZONE;
        in.defaultReadObject();
        this.d_topology = new LinkedIdentityHashSet<ISchematicObj>();
        if (this.d_temperatureSchedule == null) {
            this.d_temperatureSchedule = Schedule.newConstant(this.d_temperature);
            this.d_temperature = null;
        }
    }

    public Schedule getTemperatureSchedule() {
        return this.d_temperatureSchedule;
    }

    public void setTemperatureSchedule(Schedule temp) {
        if (Objects.equals(this.d_temperatureSchedule, temp)) {
            return;
        }
        this.d_temperatureSchedule = temp;
        this.changedEvt(TEMPERATURE_SCHEDULE);
    }

    public boolean getTempDefinedLocally() {
        return this.d_tempDefinedLocally;
    }

    public void setTempDefinedLocally(Boolean flag) {
        if (this.d_tempDefinedLocally == flag) {
            return;
        }
        this.d_tempDefinedLocally = flag;
        this.changedEvt(TEMP_DEFINEDLOCALLY);
    }

    public void colorPropsChanged() {
        this.markCachesDirty(false, true, false, new Object[0]);
    }

    private void markCachesDirty(boolean wallGeom, boolean wallDrawProps, boolean overlap, Object ... changes) {
        if (wallGeom) {
            this.d_wallGeom.clear();
        }
        if (wallDrawProps) {
            this.d_wallDrawProps.clear();
        }
        if (overlap) {
            this.d_overlapsSelf.clear();
        }
        this.changedEvt(changes);
    }

    private void markGeomCachesDirty() {
        this.markCachesDirty(true, true, true, new Object[0]);
    }

    private void markWallHeightDirty() {
        this.markCachesDirty(true, true, false, HEIGHT);
    }

    @Override
    protected void addToDomain(VentusData domain, IMerlinObj parent) {
        super.addToDomain(domain, parent);
        if (domain != null) {
            domain.getEvents().addObserverInDomain((IEventObserver)this, Floor.class, true, false, Floor.HEIGHT, Floor.WORKING_Z);
        }
        this.markWallHeightDirty();
    }

    @Override
    protected void removeFromDomain(VentusData domain, IMerlinObj parent) {
        this.markWallHeightDirty();
        if (domain != null) {
            domain.getEvents().removeObserver(this);
        }
        super.removeFromDomain(domain, parent);
    }

    @Override
    public void update(Events events) {
        IEventRecord<Floor> levelEvts;
        Floor level;
        if (this.getType().hasWalls && (level = this.getLevel()) != null && ((levelEvts = events.getEvents(Floor.class, new Class[0])).isChanged(level, Floor.HEIGHT) || levelEvts.isChanged(level, Floor.WORKING_Z))) {
            this.markWallHeightDirty();
        }
    }

    private int surrogateHashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + theUtil.hashCode(this.getArea());
        hash = 31 * hash + theUtil.hashCode(this.d_geometry.getBoundingBox());
        return hash;
    }

    @Override
    public boolean updateTopo() {
        return true;
    }

    @Override
    public boolean hasOpenSpots(Class<? extends ISchematicObj> type) {
        return true;
    }

    private void markTopoDirty() {
        this.changedEvt(VentusData.TOPOLOGY);
    }

    public boolean isConnected(ISchematicObj obj) {
        return this.d_topology.contains(obj);
    }

    @Override
    public Collection<? extends ISchematicObj> getConnections() {
        return this.d_topology;
    }

    @Override
    public void connectTo(ISchematicObj conn) {
        this.d_topology.add(conn);
        this.markCachesDirty(false, true, false, VentusData.CONNECTION);
    }

    @Override
    public void disconnectFrom(ISchematicObj conn) {
        this.d_topology.remove(conn);
        this.markCachesDirty(false, true, false, VentusData.CONNECTION);
    }

    @Override
    public Model getModel() {
        return this.d_geometry;
    }

    @Override
    public boolean isModelCached() {
        return true;
    }

    @Override
    public void setModel(Model geometry) {
        this.d_geometry = geometry;
        this.markTopoDirty();
        this.markGeomCachesDirty();
        this.changedEvt(GEOMETRY);
    }

    public boolean getModificationsAllowed() {
        return true;
    }

    public boolean add(SchematicRoom comp2) {
        Model model1 = this.d_geometry.clone();
        Model model2 = comp2.d_geometry.clone();
        int t1 = Integer.MAX_VALUE;
        int t2 = 0x7FFFFFFE;
        for (Face face : model2.getFaces()) {
            face.addGroup(t2);
        }
        for (Face face : model1.getFaces()) {
            face.addGroup(t1);
        }
        model1.merge(model2);
        ArrayList<Edge> sharedEdges = new ArrayList<Edge>();
        for (Edge edge : model1.getEdges()) {
            if (edge.faces.size() <= 1) continue;
            boolean bl = false;
            boolean m2Found = false;
            for (Face face : edge.faces) {
                if (face.partOfGroup(t1)) {
                    bl = true;
                }
                if (!face.partOfGroup(t2)) continue;
                m2Found = true;
            }
            if (!bl || !m2Found) continue;
            sharedEdges.add(edge);
        }
        if (sharedEdges.isEmpty()) {
            return false;
        }
        int[] nArray = new int[]{0};
        for (Edge edge : sharedEdges) {
            if (!edge.partOfGroup(1) && !edge.partOfGroup(t2)) continue;
            edge.groups = nArray;
        }
        int[] nArray2 = new int[]{t1, t2};
        for (Face face : model1.getFaces()) {
            face.removeGroups(nArray2);
        }
        this.d_geometry = model1;
        this.pauseUpdates();
        this.markTopoDirty();
        this.markGeomCachesDirty();
        this.resumeUpdates();
        return true;
    }

    public boolean sub(SchematicRoom comp2) {
        return this.subtract(comp2.getModel(), false);
    }

    public boolean subVolume(Model volume) {
        return this.subtract(volume, true);
    }

    private static boolean delFace(Model model1, Model subModel, Face face, boolean isVolume) {
        if (face.partOfGroup(Integer.MAX_VALUE)) {
            return true;
        }
        if (!isVolume) {
            return false;
        }
        Point3d testP = model1.findPointInFace(face);
        return testP == null || subModel.contains(testP);
    }

    public List<Face> haveCommonFaces(Model subModel, boolean isVolume) {
        Model model2 = subModel.clone();
        int[] tempGroup = new int[]{Integer.MAX_VALUE};
        for (Face face : model2.getFaces()) {
            face.groups = tempGroup;
        }
        Model model1 = this.d_geometry.clone();
        model1.merge(model2);
        return this.haveCommonFaces(model1, model2, isVolume, new ArrayList<Face>());
    }

    private List<Face> haveCommonFaces(Model mergeModel, Model subModel, boolean isVolume, List<Face> delFaces) {
        ArrayList<Face> commonFaces = new ArrayList<Face>();
        for (Face face : mergeModel.getFaces()) {
            if (!SchematicRoom.delFace(mergeModel, subModel, face, isVolume)) continue;
            delFaces.add(face);
            if (!face.partOfGroup(0)) continue;
            commonFaces.add(face);
        }
        return commonFaces;
    }

    public boolean subtract(Model subModel, boolean isVolume) {
        Model model2 = subModel.clone();
        int[] tempGroup = new int[]{Integer.MAX_VALUE};
        for (Face face : model2.getFaces()) {
            face.groups = tempGroup;
        }
        Model model1 = this.d_geometry.clone();
        model1.merge(model2);
        ArrayList<Face> delFaces = new ArrayList<Face>();
        if (this.haveCommonFaces(model1, subModel, isVolume, delFaces).isEmpty()) {
            return false;
        }
        for (Face delFace : delFaces) {
            model1.deleteFace(delFace, true, true);
        }
        int[] boundGroup = new int[]{1};
        for (Edge edge : model1.getEdges()) {
            Face face;
            if (edge.faces.size() != 1 || (face = edge.faces.get(0)).isInternalEdge(edge)) continue;
            edge.groups = boundGroup;
        }
        this.pauseUpdates();
        this.d_geometry = model1;
        this.markTopoDirty();
        this.markGeomCachesDirty();
        this.resumeUpdates();
        return true;
    }

    public Predicate<Edge> getInUseEdgeFilter() {
        return Predicates.alwaysFalse();
    }

    public Model cleanup(Model model) {
        return RoomUtil.cleanup(model, 31, this.getInUseEdgeFilter());
    }

    private void cleanupModel() {
        Model cleaned;
        Model original = this.getModel();
        if (original != (cleaned = this.cleanup(original))) {
            this.setModel(cleaned);
        }
    }

    public static void cleanup(VentusData md, Collection<? extends SchematicRoom> rooms) {
        if (!rooms.isEmpty()) {
            md.updateTopology();
            rooms.forEach(SchematicRoom::cleanupModel);
        }
    }

    public List<SchematicRoom> addBoundary(Collection<? extends ICurve> boundary, double edgeError) {
        this.d_geometry.addEdges(Integer.MAX_VALUE, SchematicRoom.toParms(boundary, edgeError));
        ArrayList<Edge> toDelete = new ArrayList<Edge>();
        int[] boundaryid = new int[]{1};
        for (Edge edge : this.d_geometry.getEdges()) {
            boolean newEdge = edge.partOfGroup(Integer.MAX_VALUE);
            if (newEdge && edge.faces.isEmpty()) {
                toDelete.add(edge);
                continue;
            }
            if (!newEdge) continue;
            edge.groups = boundaryid;
        }
        for (Edge delEdge : toDelete) {
            this.d_geometry.deleteEdge(delEdge, true);
        }
        this.markTopoDirty();
        this.markGeomCachesDirty();
        List<SchematicRoom> separated = this.separate();
        return separated;
    }

    @Override
    public IGeomNode getGeom() {
        IGeomNode base = this.getFloorGeom();
        IGeomNode walls = this.getWallGeom();
        return new RoomGeom(base, walls);
    }

    @Override
    public boolean isCeiling() {
        return this.getType().equals(ISchematicRoom.Type.CEILING);
    }

    @Override
    public void pickBox(final IBoxCollector result, IIsectFilter filter, ConvexHull region, IDisplayProps dispProps) {
        IBoxCollector skipNonPickable = new IBoxCollector(){

            @Override
            public void addNonFace(Object obj, int primIx, IPrimElements primElements) throws CancelObjectPicking {
                if (!primElements.getElement(PICKABLE_ELEM).orElse(true).booleanValue()) {
                    return;
                }
                result.addNonFace(obj, primIx, primElements);
            }

            @Override
            public void addFace(Object obj, int primIx, Supplier<Pair<Point3d, Vector3d>> getPointAndNormal, IPrimElements faceElements, IPrimProps faceProps) throws CancelObjectPicking {
                if (!faceElements.getElement(PICKABLE_ELEM).orElse(true).booleanValue()) {
                    return;
                }
                result.addFace(obj, primIx, getPointAndNormal, faceElements, faceProps);
            }
        };
        super.pickBox(skipNonPickable, filter, region, dispProps);
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester, IDisplayProps dprops) {
        ProxyIsectCollector skipNonPickable = new ProxyIsectCollector(this, isects){

            @Override
            public void addNonFace(Object obj, Point3d p, GeomType type, int primIx, IPrimElements primElements) {
                if (!primElements.getElement(PICKABLE_ELEM).orElse(true).booleanValue()) {
                    return;
                }
                this.base.addNonFace(obj, p, type, primIx, primElements);
            }

            @Override
            public void addFace(Object obj, Point3d p, int primIx, Supplier<IFace> getPrim, Supplier<Vector3d> getNormal, IPrimElements faceElements, IPrimProps faceProps) {
                if (!faceElements.getElement(PICKABLE_ELEM).orElse(true).booleanValue()) {
                    return;
                }
                this.base.addFace(obj, p, primIx, getPrim, getNormal, faceElements, faceProps);
            }
        };
        super.pickPoints(skipNonPickable, filter, rayBegin, rayDirN, maxDist, tester, dprops);
    }

    public IGeomNode getFloorGeom() {
        return this.getFloorGeom(this.d_geometry, false);
    }

    private IGeomNode getFloorGeom(Model roomModel, boolean displayable) {
        int options = 1;
        if (displayable) {
            options |= 4;
        }
        if (this.getModificationsAllowed()) {
            options |= 2;
        }
        SchematicModelGeom geom = new SchematicModelGeom(roomModel, displayable ? Filters.rejectAll(Edge.class) : this.getInUseEdgeFilter(), Predicates.alwaysTrue(), this.getBoundaryEdgeFilter(), options);
        IPropertySet elements = Elements.newElements();
        elements.setIfNotDefault(COMPONENT_ELEMENT, new ElementUniform<ISchematicRoom.DefaultFloorComponent>(DEFAULT_FLOOR_COMPONENT));
        elements.setIfNotDefault(Elements.CREASE, Elements.NO_CREASE);
        elements = Elements.finalizeElements(elements);
        return GeomNodeUtil.newNode(geom, elements);
    }

    @Override
    public void setGeom(IGeomNode node) {
        assert (node instanceof RoomGeom);
        if (!(node instanceof RoomGeom)) {
            return;
        }
        RoomGeom rg = (RoomGeom)node;
        this.setGeom(rg.room.transform(rg.getLocalTransform().getInfo()).flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        assert (geom instanceof SchematicModelGeom);
        if (!(geom instanceof SchematicModelGeom)) {
            return;
        }
        SchematicModelGeom mg = (SchematicModelGeom)geom;
        this.d_geometry = mg.model;
        this.changedEvt(GEOMETRY);
        this.markTopoDirty();
        this.markGeomCachesDirty();
    }

    private IPrimProps getFaceProps(IMerlinDispProps props) {
        return props.getFaceProps(this, IMerlinDispProps.SchematicType.ROOM, this.d_material, this.getColor(), this.getOpacity());
    }

    private IPrimProps getBoundaryProps(IMerlinDispProps props) {
        return props.getEdgeProps(this, IMerlinDispProps.SchematicType.BOUNDARY, null, this.getOpacity());
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps dprops) {
        if (!(dprops instanceof IMerlinDispProps)) {
            return DisplayGeom.EMPTY;
        }
        IMerlinDispProps props = (IMerlinDispProps)dprops;
        Model displayModel = this.d_geometry;
        IGeomNode floorGeom = this.getFloorGeom(displayModel, true);
        int numFaces = floorGeom.getNumPrims(1);
        int numBEdges = floorGeom.getNumPrims(2);
        IPrimProps fprops = this.getFaceProps(props);
        IPrimProps bprops = this.getBoundaryProps(props);
        PropsBuilder floorProps = new PropsBuilder();
        floorProps.add(fprops, numFaces);
        floorProps.add(bprops, numBEdges);
        return this.getDisplayAndPickableGeom(props, floorGeom, floorProps, false, () -> {});
    }

    @Override
    public void setDomain(VentusData domain, IMerlinObj parent) {
        if (domain != this.getDomain()) {
            super.setDomain(domain, parent);
            this.markCachesDirty(true, true, false, new Object[0]);
        }
    }

    @Override
    public UnitDouble getHeight() {
        if (!this.getType().hasWalls) {
            return GeomUtil.GEOM_LEN_ZERO;
        }
        if (this.getLevel() == null) {
            return (UnitDouble)SchematicRoom.HEIGHT.defVal;
        }
        Model m = (Model)this.get(GEOMETRY);
        if (m == null) {
            return (UnitDouble)SchematicRoom.HEIGHT.defVal;
        }
        double minZ = m.getBoundingBox().getMinZ();
        double ht = SchematicRoom.getHeightToLevelMax(minZ, this.getLevel());
        if (Double.isNaN(ht)) {
            return GeomUtil.GEOM_LEN_ZERO;
        }
        return new UnitDouble(ht, Geometry.LENGTH_UNIT);
    }

    @Override
    public UnitDouble getBaseOffsetAboveLevel() {
        if (this.getLevel() == null) {
            return GeomUtil.GEOM_LEN_ZERO;
        }
        Model m = (Model)this.get(GEOMETRY);
        if (m == null) {
            return GeomUtil.GEOM_LEN_ZERO;
        }
        UnitDouble baseZ = new UnitDouble(m.getBoundingBox().getMinZ(), Geometry.LENGTH_UNIT);
        UnitDouble diff = baseZ.diff(this.getLevel().getWorkingZ());
        if (diff.tolEquals(GeomUtil.GEOM_LEN_ZERO)) {
            return GeomUtil.GEOM_LEN_ZERO;
        }
        return diff;
    }

    @Override
    public Collection<Pair<ISchematicComp, ISchematicComp.ConflictType>> getConflicts() {
        Collection<Pair<ISchematicComp, ISchematicComp.ConflictType>> conflicts = super.getConflicts();
        Floor level = this.getLevel();
        if (level == null) {
            return conflicts;
        }
        UnitDouble levelMin = level.getWorkingZ();
        UnitDouble levelMax = levelMin.add(level.getHeight());
        AABox bounds = this.getGeom().getBoundingBox(new AABox());
        UnitDouble min = new UnitDouble(bounds.getMinZ(), Geometry.LENGTH_UNIT);
        UnitDouble max = new UnitDouble(bounds.getMaxZ(), Geometry.LENGTH_UNIT);
        double tol = levelMin.diff(levelMax).scale(0.001).get(Geometry.LENGTH_UNIT);
        if (min.compareTo(levelMin, tol) < 0 || max.compareTo(levelMax, tol) > 0) {
            conflicts = new ArrayList<Pair<ISchematicComp, ISchematicComp.ConflictType>>(conflicts);
            conflicts.add(new Pair<SchematicRoom, ISchematicComp.ConflictType>(this, ISchematicComp.ConflictType.LEVEL_MISMATCH_Z));
        }
        return conflicts;
    }

    private static double getHeightToLevelMax(double geomMinZ, Floor level) {
        if (Double.isNaN(geomMinZ)) {
            return Double.NaN;
        }
        if (level == null) {
            return Double.NaN;
        }
        double levelMin = level.getWorkingZ().get(Geometry.LENGTH_UNIT);
        double levelHt = level.getHeight().get(Geometry.LENGTH_UNIT);
        double levelMax = levelMin + levelHt;
        double tol = levelHt / 1000.0;
        if (geomMinZ < levelMin - tol || levelMax + tol < geomMinZ) {
            return Double.NaN;
        }
        double htOffset = levelHt - (geomMinZ - levelMin);
        assert (htOffset >= 0.0);
        assert (htOffset <= levelHt + tol);
        return htOffset;
    }

    private IGeomNode getWallGeom() {
        return this.d_wallGeom.get(() -> {
            if (!this.getType().hasWalls) {
                return GeomNodeUtil.EMPTY_NODE;
            }
            if (this.d_geometry == null) {
                return GeomNodeUtil.EMPTY_NODE;
            }
            AABox geomBounds = this.d_geometry.getBoundingBox();
            if (!geomBounds.isValid() || geomBounds.isInfinite()) {
                return GeomNodeUtil.EMPTY_NODE;
            }
            double htOffset = this.getHeight().get(Geometry.LENGTH_UNIT);
            Vector3d htOffsetVec = new Vector3d(0.0, 0.0, htOffset);
            LinkedHashMap<Point3d, Integer> points = new LinkedHashMap<Point3d, Integer>();
            Function<Point3d, Integer> nextIx = p -> points.size();
            ArrayList<Integer> faceIxes = new ArrayList<Integer>();
            ArrayList<Integer> borderEdgeIxes = new ArrayList<Integer>();
            ArrayList<Wall> components = new ArrayList<Wall>();
            ArrayList<Vector3d> normals = new ArrayList<Vector3d>();
            for (Face face : this.d_geometry.getFaces()) {
                for (FaceLoop loop : face.edgeLoops) {
                    for (EdgeUse eu : loop.edges) {
                        Point3d p1a;
                        if (!eu.edge.partOfGroup(1)) continue;
                        Point3d p1 = eu.v1().loc;
                        Point3d p2 = eu.v2().loc;
                        Point3d p2a = Util3D.add(p2, (Tuple3d)htOffsetVec);
                        List<Point3d> facePoints = Arrays.asList(p1, p2, p2a, p1a = Util3D.add(p1, (Tuple3d)htOffsetVec));
                        Plane3d plane = Util3D.simplePolygonPlane(facePoints, true, 1.0E-12);
                        if (plane == null) continue;
                        for (Point3d p3 : facePoints) {
                            faceIxes.add(points.computeIfAbsent(p3, nextIx));
                        }
                        components.add(new Wall(face, eu));
                        normals.add(plane.getNormal());
                        borderEdgeIxes.add((Integer)points.get(p2));
                        borderEdgeIxes.add((Integer)points.get(p2a));
                        borderEdgeIxes.add((Integer)points.get(p2a));
                        borderEdgeIxes.add((Integer)points.get(p1a));
                    }
                }
            }
            if (faceIxes.isEmpty()) {
                return GeomNodeUtil.EMPTY_NODE;
            }
            ArrayList<GeomNodeLeaf> nodes = new ArrayList<GeomNodeLeaf>(2);
            Point3d[] pointsArr = (Point3d[])theUtil.toArray(points.keySet());
            Mesh mesh = new Mesh(pointsArr, theUtil.toIntArray(faceIxes), 3);
            IPropertySet elements = Elements.newElements();
            elements.setIfNotDefault(ISchematicRoom.COMPONENT_ELEMENT, new ElementMesh<ISchematicRoom.IComponent>(ElementMesh.Mapping.PER_PRIM, (ISchematicRoom.IComponent[])theUtil.toArray(components), 1));
            elements.setIfNotDefault(Elements.NORMAL, new ElementMesh<Vector3d>(ElementMesh.Mapping.PER_PRIM, (Vector3d[])theUtil.toArray(normals), 1));
            elements.setIfNotDefault(Elements.ORIENT, Elements.CCW);
            elements.setIfNotDefault(Elements.CREASE, Elements.ALL_CREASE);
            GeomNodeLeaf faceNode = GeomNodeUtil.newNode(mesh, Elements.finalizeElements(elements));
            nodes.add(faceNode);
            mesh = new Mesh(pointsArr, theUtil.toIntArray(borderEdgeIxes), 1);
            elements = Elements.newElements();
            elements.setIfNotDefault(PICKABLE_ELEM, new ElementUniform<Boolean>(false));
            elements = Elements.finalizeElements(elements);
            GeomNodeLeaf edgesNode = GeomNodeUtil.newNode(mesh, elements);
            nodes.add(edgesNode);
            GeomNodeGroup result = GeomNodeUtil.newNode(nodes);
            return result;
        });
    }

    private IPropsSrc getWallDisplayProps(IMerlinDispProps mprops, IGeomNode wallGeom) {
        Function<Color, IPrimProps> getFaceProps = color -> mprops.getFaceProps(this, IMerlinDispProps.SchematicType.ROOM, this.d_material, (Color)color, this.getOpacity());
        return this.d_wallDrawProps.get(() -> {
            HashMap componentColors = new HashMap();
            for (ISchematicRoomColorSrc colorSrc : this.getConnections(ISchematicRoomColorSrc.class)) {
                colorSrc.getRoomColors(this, (w, c) -> componentColors.computeIfAbsent(w, wall -> (IPrimProps)getFaceProps.apply((Color)c)));
            }
            IPrimProps edgeProps = this.getBoundaryProps(mprops);
            IPrimProps defaultWallFaceProps = (IPrimProps)getFaceProps.apply(this.getColor() == null ? null : theUtil.generateRandomOffsetColor(this.getColor(), 0.3f, 0L));
            PropsBuilder props = new PropsBuilder();
            Iterator<IGeomNode> nodeIt = wallGeom.flatIterator();
            while (nodeIt.hasNext()) {
                IGeomNode node = nodeIt.next();
                int numPrims = node.getLocalGeom().getNumPrims(7);
                if (numPrims == 0) continue;
                IPropertySet elements = node.getLocalElements();
                IElemSource components = (IElemSource)((Object)elements.get(ISchematicRoom.COMPONENT_ELEMENT));
                Iterator componentIt = components.getPerPrimIterator();
                for (int m = 0; m < numPrims; ++m) {
                    ISchematicRoom.IComponent comp = (ISchematicRoom.IComponent)componentIt.next();
                    if (!(comp instanceof Wall)) {
                        props.add(edgeProps);
                        continue;
                    }
                    Wall wall = (Wall)comp;
                    IPrimProps fprops = componentColors.getOrDefault(wall, defaultWallFaceProps);
                    props.add(fprops);
                }
            }
            return props.finalizeProps();
        });
    }

    private DisplayGeom getDisplayAndPickableGeom(IMerlinDispProps mprops, IGeomNode floorGeom, IPropsSrc floorProps, boolean pickable, Runnable validateProgress) {
        IGeomNode wallGeom = this.getWallGeom();
        IPropsSrc wallProps = this.getWallDisplayProps(mprops, wallGeom);
        if (pickable) {
            boolean wireframe = mprops.isWireframe(this);
            wallGeom = wallGeom.getPickable(validateProgress, wireframe);
        }
        IGeomNode geom = new RoomGeom(floorGeom, wallGeom);
        PropsBuilder propsBuilder = new PropsBuilder();
        propsBuilder.add(floorProps, floorGeom.getNumPrims(7));
        propsBuilder.add(wallProps, wallGeom.getNumPrims(7));
        IPropsSrc finalProps = propsBuilder.finalizeProps();
        if (!pickable) {
            geom = GeomUtil.finalizeTexCoords(geom, finalProps);
        }
        return new DisplayGeom(geom, finalProps);
    }

    @Override
    public DisplayGeom getPickGeom(IDisplayProps dispProps, Runnable validateProgress) {
        IGeomNode baseGeom = this.getFloorGeom();
        if (dispProps instanceof IMerlinDispProps) {
            return this.getDisplayAndPickableGeom((IMerlinDispProps)dispProps, baseGeom, DEF_PROPS, true, validateProgress);
        }
        return new DisplayGeom(this.getGeom().getPickable(validateProgress, dispProps.isWireframe(this)), IPickable.DEF_PROPS);
    }

    public List<SchematicRoom> separate() {
        List<Model> separatedModels = RoomUtil.separate(this.d_geometry);
        if (separatedModels.size() <= 1) {
            return Arrays.asList(this);
        }
        ArrayList<SchematicRoom> separatedRooms = new ArrayList<SchematicRoom>(separatedModels.size());
        for (Model model : separatedModels) {
            SchematicRoom newRoom = this.clone();
            newRoom.d_geometry = model;
            newRoom.setVisible(this.isVisible());
            newRoom.setColor(this.getColor());
            newRoom.setOpacity(this.getOpacity());
            separatedRooms.add(newRoom);
        }
        int biggestRoomIx = SchematicRoom.getBiggestRoom(separatedRooms);
        SchematicRoom biggestRoom = (SchematicRoom)separatedRooms.get(biggestRoomIx);
        separatedRooms.remove(biggestRoomIx);
        separatedRooms.add(0, biggestRoom);
        return separatedRooms;
    }

    private static int getBiggestRoom(List<SchematicRoom> rooms) {
        UnitDouble biggestRoomArea = new UnitDouble(-1.0, SIUS.unit(2));
        int biggestRoom = 0;
        for (int m = 0; m < rooms.size(); ++m) {
            UnitDouble area = rooms.get(m).getArea();
            if (area.compareTo(biggestRoomArea) <= 0) continue;
            biggestRoomArea = area;
            biggestRoom = m;
        }
        return biggestRoom;
    }

    public boolean overlapsSelf() {
        return this.d_overlapsSelf.get(() -> {
            theTimer timer = new theTimer();
            boolean overlapsSelf = RoomUtil.overlapsSelf(this.d_geometry);
            double time = timer.curr();
            System.out.printf("Recalculated overlap for %s: %g sec%n", this.getName(), time);
            return overlapsSelf;
        });
    }

    @Override
    public <T> Collection<? extends T> getConnections(Class<T> type) {
        return theUtil.filter(this.d_topology, entry -> type.isAssignableFrom(entry.getClass()));
    }

    public boolean connectedToAmbient() {
        if (this == FlowPath.AMBIENT_ZONE) {
            return true;
        }
        IdentityHashSet closed = new IdentityHashSet();
        ArrayDeque<ISchematicComp> open = new ArrayDeque<ISchematicComp>();
        open.push(this);
        closed.add(this);
        while (!open.isEmpty()) {
            ISchematicObj comp = (ISchematicObj)open.pop();
            for (ISchematicComp adj : comp.getConnections(ISchematicComp.class)) {
                if (!adj.isEnabled()) continue;
                if (adj instanceof FlowPath) {
                    FlowPath fp = (FlowPath)adj;
                    if (((PowerlawModel)fp.getFlowElement().get(FlowElement.POWERLAW_MODEL)).equals(PowerlawModel.PERFORMANCE_CURVE)) continue;
                    Pair<ISchematicRoom, ISchematicRoom> zones = fp.getZones();
                    if (((ISchematicRoom)zones.v1).equals(FlowPath.AMBIENT_ZONE) || ((ISchematicRoom)zones.v2).equals(FlowPath.AMBIENT_ZONE)) {
                        return true;
                    }
                }
                if (!closed.add(adj)) continue;
                open.push(adj);
            }
        }
        return false;
    }

    public double getRoomArea() {
        return this.getArea().getValue(Geometry.AREA_UNIT);
    }

    public int subdivide(IFaceClassifier classifier, Collection<? extends ICurve> boundary, double edgeError, int newId) throws Exception {
        return this.subdivide(classifier, SchematicRoom.toParms(boundary, edgeError), newId);
    }

    protected static List<IParametric3D> toParms(Collection<? extends ICurve> curves, double edgeError) {
        ArrayList<IParametric3D> parms = new ArrayList<IParametric3D>(curves.size());
        for (ICurve iCurve : curves) {
            Mesh segments = iCurve.getSegments(edgeError);
            for (int m = 0; m < segments.indices.length; m += 2) {
                parms.add(new LineSeg3D(segments.vertices[segments.indices[m]], segments.vertices[segments.indices[m + 1]]));
            }
        }
        return parms;
    }

    public int subdivide(IFaceClassifier classifier, Collection<? extends IParametric3D> boundary, int newId) throws Exception {
        int tempEdgeId = Integer.MAX_VALUE;
        Predicate<Edge> boundaryEdgeTest = e -> e.partOfGroup(tempEdgeId);
        Model newGeom = this.d_geometry.clone();
        newGeom.addEdges(tempEdgeId, boundary);
        ArrayList<Edge> newEdges = new ArrayList<Edge>(newGeom.getGroup((int)tempEdgeId, (boolean)false, (boolean)true, (boolean)false).edges);
        LinkedIdentityHashSet closedFaces = new LinkedIdentityHashSet();
        for (Edge edge : newEdges) {
            for (Face f : edge.faces) {
                if (closedFaces.contains(f)) continue;
                Set<Face> touching = SchematicRoom.findTouchingFaces(f, boundaryEdgeTest, Predicates.alwaysFalse());
                closedFaces.addAll(touching);
                if (!classifier.test(newGeom, touching)) continue;
                int adjCount = 0;
                for (Face eface : edge.faces) {
                    if (!touching.contains(eface)) continue;
                    ++adjCount;
                }
                if (adjCount > 1) {
                    throw new Exception(String.format(Intl.intl("Boundary does not completely enclose a region in room %s."), this.getName()));
                }
                for (Face touchingFace : touching) {
                    touchingFace.addGroup(newId);
                }
            }
        }
        if (newGeom.getGroup((int)newId, (boolean)true, (boolean)false, (boolean)false).faces.isEmpty()) {
            return -1;
        }
        int[] remIds = new int[]{tempEdgeId};
        for (Edge edge : newEdges) {
            edge.removeGroups(remIds);
        }
        this.setGeom(new SchematicModelGeom(newGeom));
        return newId;
    }

    private static Set<Face> findTouchingFaces(Face seed, Predicate<Edge> boundaryEdgeTest, Predicate<Face> boundaryTriTest) {
        LinkedIdentityHashSet<Face> closed = new LinkedIdentityHashSet<Face>();
        ArrayDeque<Face> open = new ArrayDeque<Face>();
        open.addLast(seed);
        closed.add(seed);
        while (!open.isEmpty()) {
            Face face = (Face)open.pollLast();
            for (FaceLoop loop : face.edgeLoops) {
                for (EdgeUse eu : loop.edges) {
                    if (boundaryEdgeTest.test(eu.edge)) continue;
                    for (Face adjFace : eu.edge.faces) {
                        if (boundaryTriTest.test(adjFace) || !closed.add(adjFace)) continue;
                        open.addLast(adjFace);
                    }
                }
            }
        }
        return closed;
    }

    public IMaterial getMaterial() {
        return this.d_material;
    }

    public IMaterial[] getMaterialArray() {
        return new IMaterial[]{this.getMaterial()};
    }

    public void setMaterial(IMaterial material) {
        if (Objects.equals(this.d_material, material)) {
            return;
        }
        this.d_material = material;
        this.markCachesDirty(false, true, false, MATERIAL);
    }

    public void setMaterialArray(IMaterial[] mats) {
        this.setMaterial(mats[0]);
    }

    @Override
    public void setColor(Color color) {
        if (!Objects.equals(this.getColor(), color)) {
            this.pauseUpdates();
            this.markCachesDirty(false, true, false, new Object[0]);
            super.setColor(color);
            this.resumeUpdates();
        }
    }

    @Override
    public void setOpacity(float opacity) {
        if (this.getOpacity() != opacity) {
            this.pauseUpdates();
            this.markCachesDirty(false, true, false, new Object[0]);
            super.setOpacity(opacity);
            this.resumeUpdates();
        }
    }

    @Override
    public ISchematicRoom.Type getType() {
        return this.d_type;
    }

    @Override
    public void setManualVolume(UnitDouble vol) {
        this.d_manualVolume = vol;
        this.changedEvt(MANUAL_VOLUME);
    }

    @Override
    public UnitDouble getManualVolume() {
        return this.d_manualVolume;
    }

    @Override
    public void setUseManualVolume(boolean use) {
        this.d_useManualVolume = use;
        this.changedEvt(USE_MANUAL_VOLUME);
    }

    @Override
    public boolean getUseManualVolume() {
        return this.d_useManualVolume;
    }

    @Override
    public UnitDouble getVolume() {
        if (this.d_useManualVolume) {
            return this.d_manualVolume;
        }
        return ISchematicRoom.super.getVolume();
    }

    @Override
    public void setType(ISchematicRoom.Type type) {
        if (this.d_type == type) {
            return;
        }
        this.d_type = type;
        this.markCachesDirty(true, true, false, VentusData.TOPOLOGY);
        this.changedEvt(TYPE);
    }

    public PropertyDefs<SchematicRoom> getPropertyDefs() {
        return PROP_TYPES;
    }

    @Override
    public SchematicRoom clone() {
        return (SchematicRoom)super.clone();
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        if (VentusOIS.isPrior(ois, VentusIO.Version.VER_215)) {
            this.d_topology = (Set)ois.readObject();
        } else {
            super.readTopology(ois);
        }
    }

    @Override
    public Collection<AMerlinObj> getConnObjectsForEnable(VentusData md) {
        ArrayList<AMerlinObj> connObjects = new ArrayList<AMerlinObj>();
        for (ISchematicObj iSchematicObj : this.getConnections()) {
            if (!(iSchematicObj instanceof ISchematicComp)) continue;
            connObjects.add((AMerlinObj)((Object)iSchematicObj));
        }
        ArrayList allReferences = new ArrayList();
        Dependencies.getObjReferences(md, o -> o == this, (source, link, target) -> allReferences.add((AMerlinObj)source));
        return connObjects;
    }

    static {
        s_identity.setIdentity();
    }

    public static class RoomGeom
    extends AGeomNode {
        private static final long serialVersionUID = 1L;
        public final IGeomNode room;
        public final IGeomNode walls;

        public RoomGeom() {
            this(GeomNodeUtil.EMPTY_NODE, GeomNodeUtil.EMPTY_NODE);
        }

        public RoomGeom(IGeomNode roomGeom, IGeomNode wallGeom) {
            this((ITransform)TransformUtil.IDENTITY, roomGeom, wallGeom);
        }

        public RoomGeom(ITransform xform, IGeomNode roomGeom, IGeomNode wallGeom) {
            super(xform, EmptyGeom.INSTANCE, Elements.newElements());
            this.room = roomGeom;
            this.walls = wallGeom;
        }

        @Override
        public IGeomNode newNode(ITransform xform, IGeom geom, IPropertySet elements, Collection<? extends IGeomNode> children) {
            assert (geom.getNumPrims(7) == 0);
            assert (children.size() == 2);
            Iterator<? extends IGeomNode> childIt = children.iterator();
            return new RoomGeom(xform, childIt.next(), childIt.next());
        }

        @Override
        public Collection<? extends IGeomNode> getChildren() {
            return Arrays.asList(this.room, this.walls);
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            IGeomNode.generateLocalHandles(this.room, handle -> {
                if (handle instanceof IGeomNode.Handle) {
                    handles.accept(new SearchGeomHandle((IGeomNode.Handle)handle));
                }
            });
        }

        public class SearchGeomHandle
        implements IHandle {
            public final IGeomNode.Handle base;

            public SearchGeomHandle(IGeomNode.Handle base) {
                this.base = base;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj == null || !obj.getClass().equals(this.getClass())) {
                    return false;
                }
                return ((SearchGeomHandle)obj).base.equals(this.base);
            }

            public int hashCode() {
                return Objects.hashCode(this.base);
            }

            @Override
            public IGeomNode getGeom() {
                return this.base.getGeom();
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return this.base.getPickFilter();
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                return this.base.getConstraint(handleLoc);
            }

            @Override
            public void begin(Point3d handleLoc, ISnapConstraint constraint) {
                this.base.begin(handleLoc, constraint);
            }

            @Override
            public Object modify(IsectInfo constraintInfo, Point3d newLoc) throws ManipException {
                return this.modifySearch(this.base.modify(constraintInfo, newLoc));
            }

            @Override
            public Object end() {
                return this.modifySearch(this.base.end());
            }

            private RoomGeom modifySearch(IGeomNode newRoom) {
                return new RoomGeom(RoomGeom.this.getLocalTransform(), newRoom, RoomGeom.this.walls);
            }
        }
    }

    public static interface IFaceClassifier {
        public boolean test(Model var1, Collection<Face> var2);
    }

    public static class Wall
    implements ISchematicRoom.IWallComponent {
        private static final long serialVersionUID = 1L;
        public final Face face;
        public final EdgeUse edge;

        public Wall(Face face, EdgeUse edge) {
            this.face = face;
            this.edge = edge;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!Wall.class.isInstance(obj)) {
                return false;
            }
            Wall wall = (Wall)obj;
            return wall.edge.orient == this.edge.orient && wall.face == this.face && wall.edge.edge == this.edge.edge;
        }

        public int hashCode() {
            return 0xAF983 ^ Objects.hash(this.face, this.edge.orient, this.edge.edge);
        }

        @Override
        public Pair<Model, Face> toNmt(ISchematicRoom room, boolean modifiable) {
            return RoomUtil.getWallNmtGeom(this.edge, room.getHeight());
        }

        @Override
        public IPolygon toPoly(ISchematicRoom room) {
            return RoomUtil.getWallPoly(this.edge, room.getHeight());
        }

        @Override
        public Vector3d getNormal() {
            Vector3d edir = Util3D.vector(this.edge.v1().loc, this.edge.v2().loc);
            if (Util3D.safeNormalize(edir, 0.0) == 0.0) {
                return edir;
            }
            Vector3d normal = Util3D.cross(edir, Util3D.VEC3D_ZPOS);
            Util3D.safeNormalize(normal, 1.0E-12);
            return normal;
        }
    }
}

