/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.schematics.geom;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.elem.ElementUniform;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.ILabeled;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import ventus.Intl;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.feature.props.DisplayProps;
import ventus.feature.props.PropComparisons;
import ventus.feature.props.PropertyDefs;
import ventus.geom.GeomUtil;
import ventus.geom.Geometry;

public interface ISchematicRoom
extends ISchematicComp,
ISurrogate {
    public static final Elements.ElemProp<IComponent> COMPONENT_ELEMENT = new Elements.ElemProp<Object>(1404609423, "COMPONENT", IComponent.class, new ElementUniform<Object>(null));
    public static final DefaultFloorComponent DEFAULT_FLOOR_COMPONENT = DefaultFloorComponent.INSTANCE;
    public static final PropertyDefs<ISchematicRoom> PROP_TYPES = PropertyDefs.defsRoot(ISchematicRoom.class, PropertyDefs.legacy(null));
    public static final DisplayProp<Type> TYPE = (DisplayProp)DisplayProps.build((Object)"ISchematicRoom.TYPE", Type.class, Type.ZONE, Intl.intl("Room Type"), "").attrStoreAsPlainOldData(PROP_TYPES).attrSetter(ISchematicRoom::setType, null).attrGetter(ISchematicRoom::getType, Stream.empty()).attrComparisonEditor(PropComparisons.factory().options(Type.values())).attrFinish();
    public static final TypedProp<Model> GEOMETRY = TypedProps.build((Object)"SchematicRoom.GEOMETRY", Model.class).attrStoreAsMutable(PROP_TYPES).attrGetter(ISchematicRoom::getModel, Stream.empty()).attrSetter(ISchematicRoom::setModel, ISchematicRoom::setModel).attrCloneAndRestoreValue((room, model) -> model.clone()).attrSurrogateEquals((room1, geom1, room2, geom2, comparedSet) -> geom1.getBoundingBox().equals(geom2.getBoundingBox())).attrFinish();
    public static final DisplayProp<UnitDouble> AREA = (DisplayProp)DisplayProps.build((Object)"ISchematicRoom.AREA", new UnitDouble(0.0, SI.METER.pow(2)), Intl.intl("Area"), "", 2).attrStoreAsReadOnly(PROP_TYPES).attrGetter(ISchematicRoom::getArea, GEOMETRY).attrSurrogateEquals((room1, area1, room2, area2, comparedSet) -> area1.epsilonEquals((UnitDouble)area2, 0.001)).attrComparisonEditor(PropComparisons.factory().unitdouble(2)).attrFinish();
    public static final DisplayProp<UnitDouble> HEIGHT = (DisplayProp)DisplayProps.build((Object)"ISchematicRoom.HEIGHT", new UnitDouble(0.0, SI.METER), Intl.intl("Height"), "", 0).attrStoreAsReadOnly(PROP_TYPES).attrGetter(ISchematicRoom::getHeight, Stream.of(TYPE, GEOMETRY)).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> VOLUME = (DisplayProp)DisplayProps.build((Object)"ISchematicRoom.VOLUME", new UnitDouble(0.0, SI.METER.pow(3)), Intl.intl("Volume"), "", 16).attrStoreAsReadOnly(PROP_TYPES).attrGetter(ISchematicRoom::getVolume, Stream.of(HEIGHT, AREA)).attrFinish();
    public static final DisplayProp<UnitDouble> MANUAL_VOLUME = (DisplayProp)DisplayProps.build((Object)"ISchematicRoom.MANUAL_VOLUME", new UnitDouble(0.0, SI.METER.pow(3)), Intl.intl("Volume"), "", 16).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(ISchematicRoom::getManualVolume, Stream.empty()).attrSetter(ISchematicRoom::setManualVolume, null).attrFinish();
    public static final DisplayProp<Boolean> USE_MANUAL_VOLUME = (DisplayProp)DisplayProps.build((Object)"ISchematicRoom.USE_MANUAL_VOLUME", false, "", Intl.intl("When checked, volume is input manually instead of calculated automatically by Zone dimensions.")).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(ISchematicRoom::getUseManualVolume, Stream.empty()).attrSetter(ISchematicRoom::setUseManualVolume, null).attrFinish();
    public static final DisplayProp<UnitDouble> EFFECTIVE_VOLUME = (DisplayProp)DisplayProps.build((Object)"ISchematicRoom.EFFECTIVE_VOLUME", new UnitDouble(0.0, SI.METER.pow(3)), Intl.intl("Volume"), "", 16).attrStoreAsReadOnly(PROP_TYPES).attrGetter(ISchematicRoom::getEffectiveVolume, Stream.of(HEIGHT, AREA, MANUAL_VOLUME, USE_MANUAL_VOLUME)).attrComparisonEditor(PropComparisons.factory().unitdouble(16)).attrFinish();
    public static final DisplayProp<Floor> LEVEL = PROP_TYPES.storeAsReadOnly(VentusData.LEVEL).attrGetter(ISchematicRoom::getLevel, Stream.empty()).attrFinish();

    default public UnitDouble getArea() {
        double area = 0.0;
        for (Face face : this.getModel().getFaces()) {
            area += face.getArea();
        }
        UnitDouble areau = new UnitDouble(area, Geometry.AREA_UNIT);
        return areau;
    }

    default public UnitDouble getCalculatedVolume() {
        UnitDouble height = this.getHeight();
        UnitDouble area = this.getArea();
        return area.multiply(height);
    }

    default public UnitDouble getVolume() {
        return this.getCalculatedVolume();
    }

    default public UnitDouble getEffectiveVolume() {
        if (this.getUseManualVolume()) {
            return this.getManualVolume();
        }
        return this.getVolume();
    }

    public UnitDouble getHeight();

    public void setManualVolume(UnitDouble var1);

    public UnitDouble getManualVolume();

    public void setUseManualVolume(boolean var1);

    public boolean getUseManualVolume();

    public UnitDouble getBaseOffsetAboveLevel();

    public void setType(Type var1);

    public Type getType();

    public Model getModel();

    public void setModel(Model var1);

    default public Floor getLevel() {
        VentusData domain = (VentusData)this.getDomain();
        if (domain == null) {
            return null;
        }
        return domain.hierarchy.getAncestor(this, false, Floor.class, Predicates.alwaysTrue());
    }

    default public Predicate<Edge> getBoundaryEdgeFilter() {
        return edge -> !edge.faces.isEmpty() && edge.partOfGroup(1);
    }

    public boolean isModelCached();

    @Override
    public IGeomNode getGeom();

    default public Point3d getZProjectedLoc(Point3d loc) {
        ISchematicRoom room = this;
        Point3d tolLoc = Util3D.add(loc, (Tuple3d)new Point3d(0.0, 0.0, 0.001));
        Collection<GeomUtil.FindResult> isects = GeomUtil.findRoomIsects(Collections.singleton(room), () -> {}, tolLoc, Util3D.VEC3D_ZNEG, Double.MAX_VALUE, (r, comp) -> !IWallComponent.class.isInstance(comp));
        if (isects.isEmpty()) {
            return null;
        }
        return isects.iterator().next().p;
    }

    public boolean isCeiling();

    public static interface IWallComponent
    extends IPatch {
        public IPolygon toPoly(ISchematicRoom var1);

        default public Collection<? extends IPatch> subdivide(ISchematicRoom srcRoom, Point3d searchHint, Collection<? extends ISchematicRoom> nearRooms) {
            if (nearRooms.isEmpty()) {
                return Collections.singleton(this);
            }
            AABox search = this.getBounds(srcRoom);
            ArrayList otherWalls = new ArrayList();
            for (ISchematicRoom iSchematicRoom : nearRooms) {
                iSchematicRoom.getGeom().find(search, (fprim, ctmt) -> {
                    Optional<IComponent> comp = fprim.elements.getElement(COMPONENT_ELEMENT);
                    comp.filter(c -> c instanceof IWallComponent).map(c -> (IWallComponent)c).filter(wall -> wall.getBounds((ISchematicRoom)room).test((AABox)search, (double)1.0E-9).positive).ifPresent(c -> otherWalls.add(new Pair<ISchematicRoom, IWallComponent>(room, (IWallComponent)c)));
                });
            }
            if (otherWalls.isEmpty()) {
                return Collections.singleton(this);
            }
            Pair<Model, Face> thisModel = this.toNmt(srcRoom, true);
            if (thisModel == null) {
                return Collections.singleton(this);
            }
            ((Face)thisModel.v2).groups = new int[]{0};
            int[] nArray = new int[]{1};
            for (Pair otherWall : otherWalls) {
                Pair<Model, Face> otherFace = ((IWallComponent)otherWall.v2).toNmt((ISchematicRoom)otherWall.v1, false);
                if (otherFace == null) continue;
                ((Model)thisModel.v1).addFace((Face)otherFace.v2, nArray);
            }
            if (searchHint != null) {
                Face face = ((Model)thisModel.v1).findFace(searchHint);
                if (face != null) {
                    return Collections.singleton(new NmtPatch((Model)thisModel.v1, face));
                }
                return Collections.emptyList();
            }
            return ((Model)thisModel.v1).getFaces(0).stream().map(f -> new NmtPatch((Model)thisModel.v1, (Face)f)).collect(Collectors.toList());
        }

        default public AABox getBounds(ISchematicRoom room) {
            return this.toPoly(room).getBoundingBox(new AABox());
        }

        public Vector3d getNormal();
    }

    public static interface IComponent
    extends Serializable {
    }

    public static final class DefaultFloorComponent
    implements IFloorComponent {
        private static final long serialVersionUID = 1L;
        public static final DefaultFloorComponent INSTANCE = new DefaultFloorComponent();

        private DefaultFloorComponent() {
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    public static enum Type implements ILabeled
    {
        ZONE(Intl.intl("Zone"), Intl.intl("Represents a volume. Flow Paths can be placed on zone floors and walls\nto connect to adjacent zones or to ambient."), true, true),
        CEILING(Intl.intl("Ceiling"), Intl.intl("Represents the ceiling of the building. Flow paths can be placed on a\nceiling to connect the zone below to ambient."), false, false);

        public final String name;
        public final String desc;
        public final boolean hasWalls;
        public final boolean isWritable;

        private Type(String name, String desc, boolean hasWalls, boolean isWritable) {
            this.name = name;
            this.desc = desc;
            this.hasWalls = hasWalls;
            this.isWritable = isWritable;
        }

        public Predicate<? super ISchematicRoom> roomFilter() {
            return r -> r.getType() == this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }
    }

    public static class NmtPatch
    implements IPatch {
        private static final long serialVersionUID = 1L;
        public final Model model;
        public final Face face;

        public NmtPatch(Model model, Face face) {
            this.model = model;
            this.face = face;
        }

        @Override
        public Pair<Model, Face> toNmt(ISchematicRoom room, boolean modifiable) {
            if (modifiable) {
                Model clone = this.model.clone(v -> v.isAdjacent(this.face), e -> e.faces.contains(this.face), f -> f == this.face);
                return new Pair<Model, Face>(clone, clone.getFaces().iterator().next());
            }
            return new Pair<Model, Face>(this.model, this.face);
        }
    }

    public static interface IPatch
    extends IComponent {
        public Pair<Model, Face> toNmt(ISchematicRoom var1, boolean var2);
    }

    public static interface ICeilingComponent
    extends IComponent {
    }

    public static interface IFloorComponent
    extends IComponent {
    }
}

