/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.schematics.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.theUtil;
import ventus.data.AMerlinObj;
import ventus.data.IOpacity;
import ventus.data.NamedMerlinObj;
import ventus.data.Opacity;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.feature.props.PropertyDefs;
import ventus.feature.tags.Tag;
import ventus.feature.tags.TagsUtil;

public abstract class ASchematicComp
extends NamedMerlinObj
implements ISchematicComp,
Serializable,
Cloneable,
ISurrogate,
IDirectDependent<VentusData> {
    static final long serialVersionUID = 1L;
    public static final PropertyDefs<ASchematicComp> PROP_TYPES = PropertyDefs.defsInheritStorageAndProps(ASchematicComp.class, null, NamedMerlinObj.PROP_TYPES);
    public static final DisplayProp<Boolean> ENABLED = PROP_TYPES.storeAsPlainOldData(VentusData.ENABLED).attrGetter(ASchematicComp::isEnabled, Stream.empty()).attrSetter(ASchematicComp::setEnabled, (obj, val) -> {
        obj.d_enabled = val;
    }).attrSurrogateEquals(null).attrFinish();
    public static final TypedProp<Boolean> STORED_VISIBILITY = ((TypedProps.Builder)TypedProps.build((Object)"ASchematicComp.VISIBILITY", true).attrMarkers(VentusData.VISIBILITY_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(ASchematicComp::getStoredVisibility, Stream.empty()).attrSetter(ASchematicComp::setStoredVisibility, (obj, val) -> {
        obj.d_visible = val;
    }).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Boolean> VISIBILITY = PROP_TYPES.storeAsWrapper(VentusData.VISIBILITY).attrGetter(ASchematicComp::isVisible, Stream.of(ENABLED, STORED_VISIBILITY)).attrSetter(ASchematicComp::setVisible, null).attrUndoPropRestore(false, STORED_VISIBILITY).attrFinish();
    public static final DisplayProp<Set<Tag>> TAGS = PROP_TYPES.storeAsPlainOldData(VentusData.TAGS).attrGetter(ASchematicComp::getTags, Stream.empty()).attrSetter(ASchematicComp::setTags, null).attrDependency(prop -> TagsUtil.newTagCallback()).attrFinish();
    public static final DisplayProp<Color> COLOR = PROP_TYPES.storeAsPlainOldData(VentusData.COLOR).attrGetter(ASchematicComp::getColor, Stream.empty()).attrSetter(ASchematicComp::setColor, null).attrFinish();
    public static final DisplayProp<Color> SEARCH_COLOR = PROP_TYPES.storeAsReadOnly(VentusData.SEARCH_COLOR).attrGetter(ASchematicComp::getColor, COLOR).attrFinish();
    public static final DisplayProp<IOpacity> OPACITY = PROP_TYPES.storeAsPlainOldData(VentusData.OPACITY).attrGetter(ASchematicComp::getOpacityProp, Stream.empty()).attrSetter(ASchematicComp::setOpacityProp, null).attrSurrogateEquals(null).attrFinish();
    private boolean d_visible = true;
    private boolean d_enabled = true;
    private Color d_color = null;
    private float d_transparency = 0.0f;
    private Set<Tag> d_tags = Collections.emptySet();

    public ASchematicComp(String name) {
        super(name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.d_enabled = true;
        in.defaultReadObject();
        if (this.d_tags == null) {
            this.d_tags = Collections.emptySet();
        }
    }

    @Override
    public Collection<Pair<ISchematicComp, ISchematicComp.ConflictType>> getConflicts() {
        return Collections.emptyList();
    }

    @Override
    public Color getColor() {
        return this.d_color;
    }

    @Override
    public void setColor(Color color) {
        if (!Objects.equals(this.d_color, color)) {
            this.d_color = color;
            this.changedEvt(COLOR);
        }
    }

    @Override
    public void setOpacity(float opacity) {
        float trans = 1.0f - opacity;
        if (theUtil.eq(trans, this.d_transparency, 0.0)) {
            return;
        }
        this.d_transparency = trans;
        this.changedEvt(OPACITY);
    }

    public IOpacity getOpacityProp() {
        return new Opacity(this.getOpacity());
    }

    public void setOpacityProp(IOpacity opacity) {
        this.setOpacity(opacity.getValue());
    }

    @Override
    public float getOpacity() {
        return 1.0f - this.d_transparency;
    }

    @Override
    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.d_enabled) {
            this.d_enabled = enabled;
            this.changedEvt(VentusData.ENABLED, EventChannel.EVT_GENERAL, VentusData.TOPOLOGY);
        }
    }

    public Set<Tag> getTags() {
        return Collections.unmodifiableSet(this.d_tags);
    }

    public void setTags(Set<Tag> tags) {
        if (Objects.equals(this.d_tags, tags)) {
            return;
        }
        this.d_tags = tags;
        this.changedEvt(TAGS);
    }

    protected final boolean getStoredVisibility() {
        return this.d_visible;
    }

    protected final void setStoredVisibility(boolean visible) {
        if (this.d_visible == visible) {
            return;
        }
        this.d_visible = visible;
        this.changedEvt(STORED_VISIBILITY);
    }

    @Override
    public void setVisible(boolean visible) {
        this.set(STORED_VISIBILITY, visible);
    }

    @Override
    public boolean isVisible() {
        return this.d_visible && this.d_enabled;
    }

    public Collection<AMerlinObj> getConnObjectsForEnable(VentusData md) {
        return Collections.emptyList();
    }

    public PropertyDefs<? extends ASchematicComp> getPropertyDefs() {
        return PROP_TYPES;
    }

    @Override
    public ASchematicComp clone() {
        return (ASchematicComp)super.clone();
    }
}

