/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.schematics;

import java.awt.Component;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import thunderheadeng.util.Warning;
import ventus.data.IMerlinObj;
import ventus.data.INamed;
import ventus.gui.guiUtil;

public class SimError
extends Warning {
    private static final LevelIcon MODERATE_ICON = new LevelIcon(guiUtil.s_warningIcon.icon, Level.MODERATE);
    private static final LevelIcon CRITICAL_ICON = new LevelIcon(guiUtil.s_errorIcon.icon, Level.CRITICAL);
    public static final int WARNINGINFO_OBJS = 2;
    public static final int WARNINGINFO_LEVEL = 3;
    public final Level level;
    public final String cause;
    public final String fix;
    public final Collection<? extends IMerlinObj> causeObjs;
    public final Type type;

    public SimError(Level level, String cause, String fix, IMerlinObj ... causeObjs) {
        this(level, cause, fix, Arrays.asList(causeObjs));
    }

    public SimError(Level level, String cause, String fix, Collection<? extends IMerlinObj> causeObjs) {
        this(level, cause, fix, causeObjs, Type.DATA);
    }

    public SimError(Level level, String cause, String fix, Collection<? extends IMerlinObj> causeObjs, Type type) {
        super(cause, fix);
        this.level = level;
        this.cause = cause;
        this.fix = fix;
        this.causeObjs = causeObjs;
        this.type = type;
    }

    @Override
    public Comparable<?> getWarningInfo(int type) {
        if (type == 2) {
            List names = this.causeObjs.stream().map(o -> o instanceof INamed ? ((INamed)((Object)o)).getName() : "").collect(Collectors.toList());
            return String.join((CharSequence)"; ", names);
        }
        if (type == 3) {
            return this.level == Level.MODERATE ? MODERATE_ICON : CRITICAL_ICON;
        }
        return super.getWarningInfo(type);
    }

    public static enum Level implements Comparable<Level>
    {
        MODERATE(5),
        CRITICAL(10);

        public final int severity;

        private Level(int severity) {
            this.severity = severity;
        }
    }

    public static enum Type {
        DATA,
        RESULTS;

    }

    private static class LevelIcon
    implements Icon,
    Comparable<LevelIcon> {
        Icon d_parent;
        Level d_level;

        LevelIcon(Icon icon, Level level) {
            this.d_parent = icon;
            this.d_level = level;
        }

        @Override
        public int compareTo(LevelIcon o) {
            return o.d_level.compareTo(this.d_level);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.d_parent.paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.d_parent.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.d_parent.getIconHeight();
        }

        public String toString() {
            return this.d_level.toString();
        }
    }
}

