/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.schematics;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.stream.Stream;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Global;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import ventus.Intl;
import ventus.data.Composite;
import ventus.data.GeomComposite;
import ventus.data.IMerlinObj;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.FloorComposite;
import ventus.data.schematics.ISchematicObj;
import ventus.feature.props.DisplayProps;
import ventus.feature.props.PropComparisons;
import ventus.feature.props.PropertyDefs;
import ventus.io.VentusOIS;
import ventus.util.Dependencies;

public class Floor
extends GeomComposite<IMerlinObj>
implements IMerlinObj,
IDirectDependent<VentusData> {
    static final long serialVersionUID = 1L;
    public static final UnitDouble CURR_FLOOR = new UnitDouble(Double.NaN, SI.METER);
    public static final UnitDouble NEXT_FLOOR = new UnitDouble(Double.NaN, SI.METER);
    public static final PropertyDefs<Floor> PROP_TYPES = PropertyDefs.defsInheritStorageAndProps(Floor.class, null, GeomComposite.PROP_TYPES, Filters.reject(NamedMerlinObj.NAME, GeomComposite.STORED_VISIBILITY));
    public static final DisplayProp<UnitDouble> WORKING_Z = (DisplayProp)DisplayProps.build((Object)"Floor.WORKING_Z", null, Intl.intl("Z Location"), "", 0).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(Floor::getWorkingZ, Stream.empty()).attrSetter(Floor::setWorkingZ, null).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<String> NAME = Floor.buildCustomNameProp(PROP_TYPES).attrGetter(obj -> {
        String name = obj.getStoredName();
        if (name == null) {
            VentusData md = (VentusData)obj.getDomain();
            BaseUnit lu = md != null ? md.getUnitSystem().getLength() : SI.METER;
            name = String.format(Intl.intl("Level %s"), Global.format(obj.getWorkingZ().convert(lu)));
        }
        return name;
    }, Stream.of(STORED_NAME, WORKING_Z)).attrFinish();
    public static final DisplayProp<Boolean> VISIBILITY = Floor.defineVisibilityLocally(PROP_TYPES, false);
    public static final DisplayProp<UnitDouble> HEIGHT = (DisplayProp)DisplayProps.build((Object)"Floor.HEIGHT", new UnitDouble(3.0, SI.METER), Intl.intl("Floor Height"), "", 0).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(Floor::getHeight, Stream.empty()).attrSetter(Floor::setHeight, null).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> ZMIN_FILTER = (DisplayProp)DisplayProps.build((Object)"Floor.ZMIN_FILTER", null, Intl.intl("Z Min Filter"), "", 0).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(floor -> floor.getZFilter()[0], Stream.empty()).attrSetter((floor, value) -> floor.setZFilter((UnitDouble)value, floor.getZFilter()[1]), null).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<UnitDouble> ZMAX_FILTER = (DisplayProp)DisplayProps.build((Object)"Floor.ZMAX_FILTER", null, Intl.intl("Z Max Filter"), "", 0).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(floor -> floor.getZFilter()[1], Stream.empty()).attrSetter((floor, value) -> floor.setZFilter(floor.getZFilter()[0], (UnitDouble)value), null).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final TypedProp<GeomComposite<IMerlinObj>> WORKING_GROUP = TypedProps.buildGeneric("Floor.WORKING_GROUP", GeomComposite.class, null).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(prop -> Dependencies.newDependencyGeneric(prop, DLink.WEAK, GeomComposite.class, null, (md, src, group) -> Stream.of(group), null, (md, src, val, old, repl) -> repl)).attrSetter(Floor::setWorkingGeomGroup, null).attrGetter(Floor::getWorkingGeomGroup, Stream.empty()).attrCloneValue((floor, group) -> null).attrRestoreValue((floor, group) -> group).attrSurrogateEquals(null).attrFinish();
    private UnitDouble d_defWorkingZ;
    private UnitDouble d_height;
    private UnitDouble d_zminFilter;
    private UnitDouble d_zmaxFilter;
    private GeomComposite<IMerlinObj> d_workingNavGroup;

    public Floor(UnitDouble defWorkingZ) {
        this(null, defWorkingZ);
    }

    public Floor(String name, UnitDouble defWorkingZ) {
        super(name);
        this.d_defWorkingZ = defWorkingZ;
        this.d_height = new UnitDouble(3.0, SI.METER);
        this.d_workingNavGroup = this;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (in instanceof VentusOIS) {
            for (ISchematicObj obj : this.getDeepMembers(ISchematicObj.class)) {
                obj.readTopology(in);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        for (ISchematicObj obj : this.getDeepMembers(ISchematicObj.class)) {
            obj.writeTopology(out);
        }
    }

    public String getBaseName() {
        return this.getStoredName();
    }

    public void setWorkingGeomGroup(GeomComposite<IMerlinObj> group) {
        if (group == null) {
            group = this;
        }
        if (this.d_workingNavGroup == group) {
            return;
        }
        this.pauseUpdates();
        if (this.d_workingNavGroup == null) {
            assert (false) : "Working group must not be null";
        } else if (this.d_workingNavGroup != this) {
            this.d_workingNavGroup.changedEvt(WORKING_GROUP);
        }
        this.d_workingNavGroup = group;
        this.changedEvt(WORKING_GROUP);
        if (this.d_workingNavGroup != this) {
            this.d_workingNavGroup.changedEvt(WORKING_GROUP);
        }
        this.resumeUpdates();
    }

    public GeomComposite<IMerlinObj> getWorkingGeomGroup() {
        return this.d_workingNavGroup;
    }

    public UnitDouble getWorkingZ() {
        return this.d_defWorkingZ;
    }

    public void setWorkingZ(UnitDouble workingZ) {
        if (Objects.equals(workingZ, this.d_defWorkingZ)) {
            return;
        }
        this.d_defWorkingZ = workingZ;
        this.invalidateClippingRegion();
        this.changedEvt(WORKING_Z);
    }

    public UnitDouble getHeight() {
        return this.d_height;
    }

    public void setHeight(UnitDouble height) {
        if (Objects.equals(this.d_height, height)) {
            return;
        }
        this.pauseUpdates();
        try {
            this.d_height = height;
            this.invalidateClippingRegion();
            this.changedEvt(HEIGHT);
        }
        finally {
            this.resumeUpdates();
        }
    }

    public UnitDouble[] getZFilter() {
        UnitDouble min = this.d_zminFilter == null ? CURR_FLOOR : this.d_zminFilter;
        UnitDouble max = this.d_zmaxFilter == null ? NEXT_FLOOR : this.d_zmaxFilter;
        return new UnitDouble[]{min, max};
    }

    public void setZFilter(UnitDouble zMin, UnitDouble zMax) {
        this.d_zminFilter = zMin == CURR_FLOOR ? null : zMin;
        this.d_zmaxFilter = zMax == NEXT_FLOOR ? null : zMax;
        this.invalidateClippingRegion();
        this.changedEvt(new Object[0]);
    }

    private void invalidateClippingRegion() {
        if (this.getDomain() != null) {
            ((VentusData)this.getDomain()).floors.invalidateClippingRegions();
        }
    }

    @Override
    public PropertyDefs<Floor> getPropertyDefs() {
        return PROP_TYPES;
    }

    @Override
    public Floor clone() {
        return (Floor)super.clone();
    }

    public void repairBrokenFloors(FloorComposite topFloorNode) {
        ArrayDeque<Floor> brokenFloors = new ArrayDeque<Floor>(this.getDeepMembers(Floor.class));
        for (Floor f : brokenFloors) {
            System.out.println("Moving level to Levels node: " + f.toString());
            Composite<Floor> parent = Composite.findParent(this, f);
            if (parent != null) {
                parent.remove(f);
                topFloorNode.add(f);
                continue;
            }
            throw new RuntimeException("Unable to repair level grouping error.");
        }
    }

    @Override
    public String toString() {
        return String.format("Level[name=\"%s\", z=%s]", this.getName(), this.d_defWorkingZ.toString());
    }
}

