/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.material;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.function.Function;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.PlanarCoordMapper;
import ventus.data.material.Material;
import ventus.geom.Geometry;

public class TexMappers {
    static final long serialVersionUID = 1L;

    public static PlanarCoordMapper newPlanarCoordMapper(Point3d texOrigin) {
        return new PlanarCoordMapper(MatSizeRetriever.INSTANCE, texOrigin);
    }

    private static class MatSizeRetriever
    implements Serializable,
    Function<IMaterial, Point2d> {
        private static final long serialVersionUID = 9036542564056965835L;
        public static final MatSizeRetriever INSTANCE = new MatSizeRetriever();

        private MatSizeRetriever() {
        }

        @Override
        public Point2d apply(IMaterial m) {
            if (!(m instanceof Material)) {
                return new Point2d(1.0, 1.0);
            }
            Material mat = (Material)m;
            return new Point2d(mat.getWidth().getValue(Geometry.LENGTH_UNIT), mat.getHeight().getValue(Geometry.LENGTH_UNIT));
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }
}

