/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.material;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ventus.data.material.HashMaterial;
import ventus.data.material.Material;

public class MaterialCache {
    private Map<HashMaterial, Material> d_matMap = new HashMap<HashMaterial, Material>();
    private final List<Material> d_oldMats;
    private final List<Material> d_newMats;

    public MaterialCache(Collection<? extends Material> mats) {
        this.d_oldMats = new ArrayList<Material>(mats);
        this.d_newMats = new ArrayList<Material>();
        this.d_matMap = null;
    }

    public Material add(Material mat) {
        HashMaterial hmat;
        Material existing;
        if (this.d_matMap == null) {
            this.d_matMap = new HashMap<HashMaterial, Material>();
            for (Material omat : this.d_oldMats) {
                this.d_matMap.put(omat.makeImagesHashable(), omat);
            }
        }
        if ((existing = this.d_matMap.get(hmat = mat.makeImagesHashable())) == null) {
            existing = mat;
            this.d_matMap.put(hmat, existing);
            this.d_newMats.add(mat);
        }
        return existing;
    }

    public List<Material> getAddedMaterials() {
        return this.d_newMats;
    }
}

