/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.image;

import java.awt.Dimension;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.image.Image;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.picking.CancelObjectPicking;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.theUtil;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.feature.props.PropertyDefs;
import ventus.geom.IMerlinGeomSrc;

public class RasterImage
extends NamedMerlinObj
implements IMerlinGeomSrc {
    static final long serialVersionUID = 1L;
    public static final PropertyDefs<RasterImage> PROP_TYPES = PropertyDefs.defsInheritStorageAndProps(RasterImage.class, null, NamedMerlinObj.PROP_TYPES);
    public static final DisplayProp<Boolean> ENABLED = PROP_TYPES.storeAsPlainOldData(VentusData.ENABLED).attrSetter(RasterImage::setEnabled, null).attrGetter(RasterImage::isEnabled, Stream.empty()).attrFinish();
    public static final TypedProp<Boolean> STORED_VISIBILITY = ((TypedProps.Builder)TypedProps.build((Object)"RasterImage.VISIBILITY", true).attrMarkers(VentusData.VISIBILITY_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(RasterImage::getStoredVisibility, Stream.empty()).attrSetter(RasterImage::setStoredVisibility, null).attrFinish();
    public static final DisplayProp<Boolean> VISIBILITY = PROP_TYPES.storeAsWrapper(VentusData.VISIBILITY).attrGetter(RasterImage::isVisible, Stream.of(STORED_VISIBILITY, ENABLED)).attrSetter(RasterImage::setVisible, null).attrUndoPropRestore(false, STORED_VISIBILITY).attrFinish();
    public static final TypedProp<Image> IMAGE = TypedProps.build((Object)"RasterImage.IMAGE", Image.class).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(RasterImage::getImage, Stream.empty()).attrSetter(RasterImage::setImage, null).attrFinish();
    private Image d_image;
    private boolean d_enabled;
    private boolean d_visible;
    private Matrix4d d_lwXform;

    public RasterImage(String name, Image baseImage) {
        super(name);
        this.d_image = baseImage;
        this.d_enabled = true;
        this.d_visible = true;
    }

    public float getOpacity() {
        return 1.0f;
    }

    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.d_enabled) {
            this.d_enabled = enabled;
            this.changedEvt(VentusData.ENABLED, EventChannel.EVT_GENERAL);
        }
    }

    public final boolean getStoredVisibility() {
        return this.d_visible;
    }

    public final void setStoredVisibility(boolean visible) {
        if (this.d_visible == visible) {
            return;
        }
        this.d_visible = visible;
        this.changedEvt(STORED_VISIBILITY);
    }

    @Override
    public boolean isVisible() {
        return this.get(STORED_VISIBILITY) != false && this.get(ENABLED) != false;
    }

    @Override
    public void setVisible(boolean visible) {
        this.set(STORED_VISIBILITY, visible);
    }

    public void setImage(Image image) {
        this.d_image = image;
        this.changedEvt(IMAGE);
    }

    public Image getImage() {
        return this.d_image;
    }

    public Matrix4d getLWXform() {
        return this.d_lwXform;
    }

    public void setLWXform(Matrix4d lwXform) {
        this.d_lwXform = lwXform;
        this.changedEvt(new Object[0]);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        return DisplayGeom.EMPTY;
    }

    @Override
    public DisplayGeom getPickGeom(IDisplayProps dispProps, Runnable validateProgress) {
        return DisplayGeom.EMPTY;
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getRasterGeom());
    }

    public RasterImageGeom getRasterGeom() {
        return new RasterImageGeom(new Dimension(this.d_image.getWidth(), this.d_image.getHeight()), this.d_lwXform);
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (!(geom instanceof RasterImageGeom)) {
            return;
        }
        RasterImageGeom rig = (RasterImageGeom)geom;
        this.setLWXform(rig.lwxform);
    }

    @Override
    public void getAll(Consumer<Object> result, IIsectFilter filter) {
    }

    @Override
    public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull box, IDisplayProps dprops) {
    }

    public PropertyDefs<? extends RasterImage> getPropertyDefs() {
        return PROP_TYPES;
    }

    @Override
    public RasterImage clone() {
        return (RasterImage)super.clone();
    }

    public static class RasterImageGeom
    implements IGeom {
        private static final long serialVersionUID = -2245365587792843008L;
        public final Dimension imgSize;
        public final Matrix4d lwxform;

        public RasterImageGeom(Dimension imgSize, Matrix4d xform) {
            this.imgSize = imgSize;
            this.lwxform = xform;
        }

        @Override
        public IGeom optimize(IPointOptimizer pointOptimizer) {
            return this;
        }

        @Override
        public boolean isShell() {
            return true;
        }

        @Override
        public boolean isAxisAlignedBlock(TransformInfo parentXform) {
            return false;
        }

        @Override
        public IDOF getDOF() {
            return IDOF.FREE;
        }

        @Override
        public IDOF getRetainingDOF() {
            return IDOF.FREE;
        }

        @Override
        public IGeom transform(TransformInfo ti, int options) {
            if (ti.isIdentity()) {
                return this;
            }
            Matrix4d xform = new Matrix4d(ti.getMatrix());
            xform.mul(this.lwxform);
            return new RasterImageGeom(this.imgSize, xform);
        }

        @Override
        public int getNumPrims(int types) {
            return (types & 1) != 0 ? 1 : 0;
        }

        @Override
        public Iterator<Byte> iteratePrimTypes(int offset) {
            return theUtil.iterate((byte)1, 1);
        }

        @Override
        public boolean canExplode() {
            return true;
        }

        @Override
        public Collection<IGeom> explode(Collection<IGeom> prims) {
            prims.add(this.toQuad());
            return prims;
        }

        public Quad toQuad() {
            return this.toQuad(this.lwxform);
        }

        protected Quad toQuad(Matrix4d xform) {
            Quad q = new Quad(new Point3d(0.0, 0.0, 0.0), new Point3d(this.imgSize.width, 0.0, 0.0), new Point3d(this.imgSize.width, this.imgSize.height, 0.0), new Point3d(0.0, this.imgSize.height, 0.0));
            return q.transform(new TransformInfo(xform), 0);
        }

        @Override
        public AABox getBoundingBox(AABox aabb) {
            return this.toQuad().getBoundingBox(aabb);
        }

        @Override
        public void pickBox(Object source, IElemSource<Boolean> visFaceEdges, IIsectFilter filter, ConvexHull region, thunderheadeng.geometry.objs.IBoxCollector isects) throws CancelObjectPicking {
            this.toQuad().pickBox(source, visFaceEdges, filter, region, isects);
        }

        @Override
        public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, IElemSource<Boolean> creases, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester) {
            this.toQuad().pickPoints(isects, filter, source, creases, rayBegin, rayDirN, maxDist, tester);
        }

        @Override
        public void find(ITest<AABox> test, IResult<? super IGeom.FoundPrimitive> result) {
            result.mark(new IGeom.FoundPrimitive(0, this.toQuad()), Containment.INTERSECTS);
        }

        @Override
        public void getAll(IResult<? super IPrimitive> result) {
            result.mark(this.toQuad(), Containment.INSIDE);
        }
    }
}

