/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.image;

import java.awt.Dimension;
import java.io.File;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.BGImageXform;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.image.Image;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.HashPool;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import ventus.Intl;
import ventus.data.IOpacity;
import ventus.data.Opacity;
import ventus.data.VentusData;
import ventus.data.image.RasterImage;
import ventus.feature.props.DisplayProps;
import ventus.feature.props.PropertyDefs;
import ventus.geom.Geometry;

public class BGImage
extends RasterImage {
    static final long serialVersionUID = 1L;
    public static final PropertyDefs<BGImage> PROP_TYPES = PropertyDefs.defsInheritStorageAndProps(BGImage.class, null, RasterImage.PROP_TYPES);
    public static final DisplayProp<Float> OPACITY = (DisplayProp)DisplayProps.build((Object)"BGImage.OPACITY", Float.class, Float.valueOf(1.0f), Intl.intl("Opacity"), "").attrStoreAsPlainOldData(PROP_TYPES).attrGetter(BGImage::getOpacity, Stream.empty()).attrSetter(BGImage::setOpacity, null).attrFinish();
    public static final DisplayProp<IOpacity> SHARED_OPACITY = PROP_TYPES.storeAsWrapper(VentusData.OPACITY).attrGetter(image -> new Opacity(image.getOpacity()), OPACITY).attrSetter((image, val) -> image.setOpacity(val.getValue()), null).attrUndoPropRestore(false, OPACITY).attrFinish();
    static final TypedProp<String> FILENAME = TypedProps.build((Object)"BGImage.FILENAME", String.class).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(BGImage::getFilename, Stream.empty()).attrSetter((obj, val) -> obj.setFilename((String)val), (obj, val) -> obj.setFilename((String)val, false)).attrUndoPropRestore(true, NAME).attrFinish();
    static final TypedProp<BGImageXform> TRANSFORM = TypedProps.build((Object)"BGImage.BGImageXForm", BGImageXform.class).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(BGImage::getTransformInfo, Stream.empty()).attrSetter(BGImage::setTransformInfo, null).attrFinish();
    private String d_filename;
    private Point2d d_anchorImage;
    private UnitPoint3D d_anchorModel;
    private Point2d d_aImage;
    private Point2d d_bImage;
    private UnitDouble d_distABModel;
    private UnitDouble d_abAngle;
    private float d_opacity = 1.0f;

    public BGImage(String filename, Image baseImage) {
        super(BGImage.nameFromFile(filename), baseImage);
        this.d_filename = filename;
    }

    private static String nameFromFile(String filename) {
        return new File(filename).getName();
    }

    public PropertyDefs<BGImage> getPropertyDefs() {
        return PROP_TYPES;
    }

    @Override
    public BGImage clone() {
        return (BGImage)super.clone();
    }

    @Override
    public BGImageGeom getRasterGeom() {
        double angle = this.d_abAngle != null ? this.d_abAngle.getValue(Geometry.ANGLE_UNIT) : new Vector2d(1.0, 0.0).angle(Util2D.vector(this.d_aImage, this.d_bImage));
        Unit lu = Geometry.LENGTH_UNIT;
        return new BGImageGeom(new Dimension(this.getImage().getWidth(), this.getImage().getHeight()), this.d_anchorImage, this.d_anchorModel.getPoint3dValue(lu), this.d_aImage, this.d_bImage, this.d_distABModel.getValue(lu), angle);
    }

    @Override
    public void setGeom(IGeom geom) {
        if (!(geom instanceof BGImageGeom)) {
            return;
        }
        BGImageGeom bg = (BGImageGeom)geom;
        Unit lu = Geometry.LENGTH_UNIT;
        this.setTransformInfo(bg.anchorImg, new UnitPoint3D(bg.anchorMdl, lu), bg.aImg, bg.bImg, new UnitDouble(bg.distABMdl, lu), new UnitDouble(bg.abAngle, Geometry.ANGLE_UNIT));
    }

    public String getFilename() {
        return this.d_filename;
    }

    public void setFilename(String filename) {
        this.setFilename(filename, true);
    }

    public void setFilename(String filename, boolean updateName) {
        boolean nameFromFile;
        this.pauseUpdates();
        if (updateName && (nameFromFile = this.getName().equals(BGImage.nameFromFile(this.d_filename)))) {
            this.setName(BGImage.nameFromFile(filename));
        }
        this.d_filename = filename;
        this.changedEvt(FILENAME);
        this.resumeUpdates();
    }

    public void setTransformInfo(BGImageXform xform) {
        this.setTransformInfo(xform.anchorImage, new UnitPoint3D(xform.anchorModel, Geometry.LENGTH_UNIT), xform.aImage, xform.bImage, new UnitDouble(xform.distABModel, Geometry.LENGTH_UNIT), new UnitDouble(xform.abAngle, Geometry.ANGLE_UNIT));
    }

    public void setTransformInfo(Point2d anchorImage, UnitPoint3D anchorModel, Point2d aImage, Point2d bImage, UnitDouble distABModel, UnitDouble abAngle) {
        if (!(Objects.equals(this.d_anchorImage, anchorImage) && Objects.equals(this.d_anchorModel, anchorModel) && Objects.equals(this.d_aImage, aImage) && Objects.equals(this.d_bImage, bImage) && Objects.equals(this.d_distABModel, distABModel) && Objects.equals(this.d_abAngle, abAngle))) {
            this.d_anchorImage = new Point2d(anchorImage);
            this.d_anchorModel = anchorModel;
            this.d_aImage = new Point2d(aImage);
            this.d_bImage = new Point2d(bImage);
            this.d_distABModel = distABModel;
            this.d_abAngle = abAngle;
            this.pauseUpdates();
            this.changedEvt(TRANSFORM);
            this.updateXform();
            this.resumeUpdates();
        }
    }

    public BGImageXform getTransformInfo() {
        double angle = this.d_abAngle == null ? Util2D.angle(new Vector2d(1.0, 0.0), Util2D.vector(this.d_aImage, this.d_bImage)) : this.d_abAngle.getValue(Geometry.ANGLE_UNIT);
        return new BGImageXform(this.d_anchorImage, this.d_anchorModel.getPoint3dValue(Geometry.LENGTH_UNIT), this.d_aImage, this.d_bImage, this.d_distABModel.getValue(Geometry.LENGTH_UNIT), angle);
    }

    private void updateXform() {
        this.setLWXform(BGImage.generateTransform(this.d_anchorImage, this.d_anchorModel, this.d_aImage, this.d_bImage, this.d_distABModel, this.d_abAngle));
    }

    public static Matrix4d generateTransform(Point2d anchorImage, UnitPoint3D anchorModel, Point2d aImage, Point2d bImage, UnitDouble distABModel, UnitDouble abAngle) {
        Unit lu = Geometry.LENGTH_UNIT;
        Unit au = Geometry.ANGLE_UNIT;
        assert (anchorImage != null && anchorModel != null);
        Point3d am = anchorModel.getPoint3dValue(lu);
        if (aImage == null || bImage == null || distABModel == null) {
            return BGImageGeom.generateTransform(anchorImage, am);
        }
        double dab = distABModel.getValue(lu);
        if (abAngle == null) {
            return BGImageGeom.generateTransform(anchorImage, am, aImage, bImage, dab);
        }
        return BGImageGeom.generateTransform(anchorImage, am, aImage, bImage, dab, abAngle.getValue(au));
    }

    public void setOpacity(float opacity) {
        if (opacity == this.d_opacity) {
            return;
        }
        this.d_opacity = opacity;
        this.changedEvt(OPACITY);
    }

    @Override
    public float getOpacity() {
        return this.d_opacity;
    }

    public UnitPoint3D getAnchorModel() {
        return this.d_anchorModel;
    }

    public static class BGImageGeom
    extends RasterImage.RasterImageGeom {
        private static final long serialVersionUID = -8664913704149564133L;
        private final Point2d anchorImg;
        private final Point3d anchorMdl;
        private final Point2d aImg;
        private final Point2d bImg;
        private final double distABMdl;
        private final double abAngle;
        private static final IDOF s_dof = new IDOF(){

            @Override
            public boolean accept(TransformInfo ti) {
                Matrix4d xform = ti.getMatrix();
                AxisAngle4d rot = GeomUtil.getRotation(xform);
                if (rot == null) {
                    return true;
                }
                Vector3d axis = new Vector3d(rot.x, rot.y, rot.z);
                axis.normalize();
                return Util3D.getClosestAxis(axis) == 2;
            }

            @Override
            public void describeRules(Set<String> rules) {
                rules.add(Intl.intl("Rotation may only be about the Z axis."));
            }
        };

        public BGImageGeom(Dimension imgSize, Point2d anchorImage, Point3d anchorModel, Point2d aImage, Point2d bImage, double distABModel, double abAngle) {
            super(imgSize, BGImageGeom.generateTransform(anchorImage, anchorModel, aImage, bImage, distABModel, abAngle));
            this.anchorImg = anchorImage;
            this.anchorMdl = anchorModel;
            this.aImg = aImage;
            this.bImg = bImage;
            this.distABMdl = distABModel;
            this.abAngle = abAngle;
        }

        public IGeom optimize(HashPool<Point3d> pool) {
            Point3d am = pool.getExisting(this.anchorMdl);
            return am == this.anchorMdl ? this : new BGImageGeom(this.imgSize, this.anchorImg, am, this.aImg, this.bImg, this.distABMdl, this.abAngle);
        }

        @Override
        public IDOF getDOF() {
            return s_dof;
        }

        @Override
        public IDOF getRetainingDOF() {
            return s_dof;
        }

        @Override
        public IGeom transform(TransformInfo ti, int options) {
            if (ti.isIdentity()) {
                return this;
            }
            Matrix4d xform = ti.getMatrix();
            Point3d newAnchor = Util3D.xform(xform, this.anchorMdl);
            xform = new Matrix4d(xform);
            xform.mul(this.lwxform);
            Point3d aMdl = Util3D.xform(xform, new Point3d(this.aImg.x, this.aImg.y, 0.0));
            Point3d bMdl = Util3D.xform(xform, new Point3d(this.bImg.x, this.bImg.y, 0.0));
            double newDist = aMdl.distance(bMdl);
            Vector3d abVec = Util3D.vector(aMdl, bMdl);
            double newAngle = Util3D.angle(GeomConstants.VEC3D_XPOS, abVec, GeomConstants.VEC3D_ZPOS);
            return new BGImageGeom(this.imgSize, this.anchorImg, newAnchor, this.aImg, this.bImg, newDist, newAngle);
        }

        public static Matrix4d generateTransform(Point2d anchorImage, Point3d anchorModel) {
            return BGImageGeom.generateTransform(anchorImage, anchorModel, new Point2d(0.0, 0.0), new Point2d(1.0, 0.0), 1.0, 0.0);
        }

        public static Matrix4d generateTransform(Point2d anchorImage, Point3d anchorModel, Point2d aImage, Point2d bImage, double distABModel) {
            return BGImageGeom.generateTransform(anchorImage, anchorModel, aImage, bImage, distABModel, Util2D.angle(new Vector2d(1.0, 0.0), Util2D.vector(aImage, bImage)));
        }

        public static Matrix4d generateTransform(Point2d anchorImage, Point3d anchorModel, Point2d aImage, Point2d bImage, double distABModel, double abAngle) {
            assert (anchorImage != null && anchorModel != null);
            Matrix4d xform = new Matrix4d();
            xform.setIdentity();
            if (aImage.equals(bImage) || distABModel == 0.0) {
                return xform;
            }
            double scale = BGImageGeom.getBackgroundImageScale(aImage, bImage, distABModel);
            xform.setTranslation(new Vector3d(anchorModel.x, anchorModel.y, anchorModel.z));
            xform.mul(Util.scaleMat(scale, scale, 1.0));
            double angle = BGImageGeom.getBGImageRotation(aImage, bImage, abAngle);
            xform.mul(Util.rotMat(0.0, 0.0, 1.0, angle));
            xform.mul(Util.translateMat(-anchorImage.x, -anchorImage.y, 0.0));
            return xform;
        }

        private static double getBackgroundImageScale(Point2d aImage, Point2d bImage, double distABModel) {
            double pixelDist = aImage.distance(bImage);
            return distABModel / pixelDist;
        }

        private static double getBGImageRotation(Point2d aImage, Point2d bImage, double desiredAngle) {
            Vector2d ab = Util2D.vector(aImage, bImage);
            double currAngle = Util2D.angle(new Vector2d(1.0, 0.0), ab);
            return desiredAngle - currAngle;
        }
    }
}

