/*
 * Decompiled with CFR 0.152.
 */
package ventus.builders;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import thunderheadeng.util.Pair;
import ventus.builders.ATwoPointBuilder;
import ventus.builders.PlanarGeomBuilder;
import ventus.builders.WorkingPlane;
import ventus.data.VentusData;

public class RectBuilder
extends ATwoPointBuilder {
    public RectBuilder(VentusData data, WorkingPlane workingPlane, PlanarGeomBuilder.IGeomBuilder builder) {
        super(data, workingPlane, builder);
    }

    @Override
    public Shape getShape() {
        Point2d p1 = this.getP1();
        Point2d p2 = this.getP2();
        if (p1 == null || p2 == null) {
            return new Rectangle2D.Double();
        }
        double width = Math.abs(p2.x - p1.x);
        double height = Math.abs(p2.y - p1.y);
        double miny = Math.min(p1.y, p2.y);
        double minx = Math.min(p1.x, p2.x);
        return new Rectangle2D.Double(minx, miny, width, height);
    }

    @Override
    public List<Pair<Point3d, Double>> getDimensions() {
        Point2d p1 = this.getP1();
        Point2d p2 = this.getP2();
        if (p1 == null || p2 == null) {
            return Collections.emptyList();
        }
        Point2d center = new Point2d(p1);
        center.add(p2);
        center.scale(0.5);
        double width = Math.abs(p2.x - p1.x);
        double height = Math.abs(p2.y - p1.y);
        double zLoc = this.getZLoc().get(SI.METER);
        return List.of(new Pair<Point3d, Double>(new Point3d(center.x, p1.y, zLoc), width), new Pair<Point3d, Double>(new Point3d(center.x, p2.y, zLoc), width), new Pair<Point3d, Double>(new Point3d(p1.x, center.y, zLoc), height), new Pair<Point3d, Double>(new Point3d(p2.x, center.y, zLoc), height));
    }
}

