/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions.importinferno;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.util.FileFilters;
import ventus.Intl;
import ventus.MerlinPrefs;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.Undo;
import ventus.actions.importgeom.Import;
import ventus.actions.importinferno.SchematicType;
import ventus.data.Composite;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.geom.GeomUtil;

public abstract class ImportInferno
extends AMerlinOp {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(VentusApp app, VentusData mdd) {
        if (!app.promptSaveIfModified()) {
            return;
        }
        guiJFXFileChooser chooser = new guiJFXFileChooser(null, MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, FileFilters.EXT_FILTER_INFERNO);
        File f = chooser.showOpenDialog();
        if (f == null) {
            return;
        }
        MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, f.getParent());
        app.beginWaitCursor();
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            try (VentusData.WriteLock lock = mdd.lockWrite();){
                Undo.insertEntry_breakChain(mdd);
                mdd.reset();
                this.parse(is, mdd);
                mdd.getEvents().changed(mdd, Import.MODEL_IMPORTED);
            }
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), String.format(Intl.intl("Could not open file: %s"), f.getAbsolutePath()), Intl.intl("File error"), 0);
            return;
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            app.endWaitCursor();
        }
    }

    protected abstract void parse(InputStream var1, VentusData var2);

    protected SchematicRoom findMergeGeom(VentusData md, Composite<ISchematicComp> node, SchematicType terrain, Point3d ... polyPoints) {
        IPolygon poly = PolyUtil.newPoly(polyPoints);
        Plane3d plane = poly.getPlane(true);
        for (SchematicRoom geom : node.getMembers(SchematicRoom.class)) {
            for (IFace face : thunderheadeng.geometry.objs.GeomUtil.explode(geom.getGeom().flatten().getLocalGeom(), IFace.class)) {
                List<? extends IPolygon> planarFaces = GeomUtil.toPolys(face, md.simParams.edgeError);
                for (IPolygon iPolygon : planarFaces) {
                    Plane3d pfplane = iPolygon.getPlane(true);
                    if (!plane.epsilonEquals(pfplane, 1.0E-6)) continue;
                    return geom;
                }
            }
        }
        Model model = new Model();
        GeomUtil.addFaceToModel(poly, model, 0, 0.0, 0.0);
        int[] group = new int[]{1};
        for (Edge edge : model.getEdges()) {
            edge.groups = group;
        }
        SchematicRoom geom = new SchematicRoom("mesh", model);
        node.add(geom);
        return geom;
    }

    protected static SchematicRoom toTempRoom(Point3d ... points) {
        ArrayList<LineSeg3D> segs = new ArrayList<LineSeg3D>();
        for (int m = 0; m < points.length; ++m) {
            Point3d p1 = points[m];
            Point3d p2 = points[(m + 1) % points.length];
            segs.add(new LineSeg3D(p1, p2));
        }
        Model model = new Model();
        if (GeomUtil.addFaceToModel(model, 0, new Plane3d(true, points), segs)) {
            return new SchematicRoom("", model);
        }
        return null;
    }
}

