/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions.copypaste;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.Warning;
import ventus.VentusApp;
import ventus.actions.copypaste.CopyPasteUtil;
import ventus.actions.copypaste.PasteHandler;
import ventus.actions.copypaste.PasteHints;
import ventus.data.Composite;
import ventus.data.INamed;
import ventus.data.VentusData;

public class DefaultPasteHandler
implements PasteHandler {
    private final Class acceptedClass;

    public DefaultPasteHandler(Class clazz) {
        this.acceptedClass = clazz;
    }

    @Override
    public boolean isHandlerFor(IDomainObject obj, String mdRootField) {
        return this.acceptedClass.getName().equals(mdRootField);
    }

    @Override
    public PasteHints getPasteHints(VentusData md, IDomainObject pasteObj) {
        return new PasteHints();
    }

    @Override
    public void pasteApply(VentusData md, VentusApp app, Predicate<? super IDomainObject> isPasteObj, Consumer<? super IDomainObject> allPastedObjs, Consumer<? super Warning> warnings, Collection<? extends PasteHandler.PasteEntry> entries) {
        for (PasteHandler.PasteEntry pasteEntry : entries) {
            Composite insertRoot = (Composite)pasteEntry.pasteLoc();
            Collection<INamed> nameSibs = insertRoot.getMembers(INamed.class);
            CopyPasteUtil.renamePasteObj(nameSibs, pasteEntry.pasteObj());
            CopyPasteUtil.pasteIntoAndTransform(md, app, pasteEntry.pasteObj(), pasteEntry.hints(), allPastedObjs, insertRoot, -1, true);
            allPastedObjs.accept(pasteEntry.pasteObj());
        }
    }
}

