/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import javafx.scene.input.KeyCode;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import thunderheadeng.gui.DropDownButton;
import thunderheadeng.gui.framework.CompositeUndo;
import thunderheadeng.gui.framework.UndoFramework;
import thunderheadeng.util.CachedValue;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.TypedProp;
import ventus.Intl;
import ventus.MerlinPrefs;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.UIHook;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.util.MerlinUtil;

public class Undo
extends UndoFramework<VentusData, IMerlinObj, Composite<? extends IMerlinObj>> {
    private static final CachedValue<Undo> s_global = new CachedValue();
    public static final Icon ICON_UNDO = UIHook.loadIcon("thunderheadeng/gui/graphics/Undo16.gif");
    public static final UIHook UI_HOOK_UNDO = new UIHook(new UndoAction(), Intl.intl("&Undo,Z,Undo last action,Undo last action"), ICON_UNDO, 16);
    public static final UIHook UI_HOOK_UNDO_MAJOR = new UIHook(new UndoThroughMajorAction(), Intl.intl("&Undo Edit,-,Undo last edit,Undo last edit"), ICON_UNDO, 16);
    public static final Icon ICON_REDO;
    public static final UIHook UI_HOOK_REDO;
    public static final UIHook UI_HOOK_REDO_MAJOR;

    public static Undo global() {
        return s_global.get(() -> new Undo());
    }

    public Undo() {
        super(new VentusCallback());
    }

    public static void insertEntry_breakChain(VentusData md) {
        Undo.global().breakChain(md);
    }

    public static void insertEntry(VentusData md, UndoFramework.UndoOp op) {
        Undo.global().pushEntry(md, op);
    }

    public static void begin(String actionName) {
        Undo.global().beginUndo(actionName);
    }

    public static void begin(String actionName, boolean record) {
        Undo.global().beginUndo(actionName, record);
    }

    public static void end(VentusData md) {
        Undo.global().endUndo(md);
    }

    public static void end(VentusData md, boolean keepLast) {
        Undo.global().endUndo(md, keepLast);
    }

    public static void insertUndoEntry_delete(VentusData md, Composite<?> parent, Collection<? extends IMerlinObj> objs) {
        Undo.global().pushEntry_delete(md, parent, objs);
    }

    public static void insertUndoEntry_delete(VentusData md, Composite<?> parent, IMerlinObj ... objs) {
        Undo.global().pushEntry_delete(md, parent, objs);
    }

    public static void insertUndoEntry_add(VentusData md, IMerlinObj ... objs) {
        Undo.global().pushEntry_add(md, objs);
    }

    public static void insertUndoEntry_add(VentusData md, Collection<? extends IMerlinObj> objs) {
        Undo.global().pushEntry_add(md, objs);
    }

    public static void insertUndoEntry_insert(VentusData md, IMerlinObj obj) {
        Undo.global().pushEntry_insert(md, obj);
    }

    public static void insertUndoEntry_deletePreserveIx(VentusData md, Composite<IMerlinObj> parent, IMerlinObj obj, int ix) {
        Undo.global().pushEntry_deletePreserveIx(md, parent, obj, ix);
    }

    public static void insertUndoEntry_restore(VentusData md, Collection<? extends IMerlinObj> objs) {
        Undo.global().pushEntry_restore(md, objs);
    }

    public static void insertUndoEntry_restore(VentusData md, IMerlinObj obj) {
        Undo.global().pushEntry_restore(md, obj);
    }

    public static void insertUndoEntry_restore(VentusData md, IMerlinObj obj, Object momento) {
        Undo.global().pushEntry_restore(md, obj, momento);
    }

    public static UndoFramework.UndoOp getRestoreAllOp(VentusData md, IMerlinObj obj) {
        return Undo.global().getRestoreAll(md, obj);
    }

    public static UndoFramework.UndoOp getRestoreAllOp(VentusData md, IMerlinObj obj, Object momento) {
        return Undo.global().getRestoreAll(md, obj, momento);
    }

    public static UndoFramework.UndoOp getRestorePropOp(VentusData md, IMerlinObj obj, TypedProp<?> prop) {
        return Undo.getRestorePropOp(md, obj, List.of(prop));
    }

    public static UndoFramework.UndoOp getRestorePropOp(VentusData md, IMerlinObj obj, Collection<? extends TypedProp<?>> props) {
        return Undo.global().getRestoreProp(md, obj, props);
    }

    public static void insertUndoEntry_propRestore(VentusData md, Collection<? extends IMerlinObj> objs, TypedProp<?> prop) {
        if (!Undo.global().accepting()) {
            return;
        }
        for (IMerlinObj iMerlinObj : objs) {
            Undo.global().pushEntry_propRestore(md, iMerlinObj, prop);
        }
    }

    public static void insertUndoEntry_propRestore(VentusData md, IMerlinObj obj, TypedProp<?> prop) {
        Undo.global().pushEntry_propRestore(md, obj, prop);
    }

    public static void insertUndoEntry_propRestore(VentusData md, IMerlinObj obj, Collection<? extends TypedProp<?>> props) {
        Undo.global().pushEntry_propRestore(md, obj, props);
    }

    public static void insertUndoEntry_restoreSelection(VentusData md) {
        Undo.global().pushEntry_restoreSelection(md);
    }

    static {
        UI_HOOK_UNDO_MAJOR.setKeyStroke(KeyStroke.getKeyStroke(KeyCode.Z.getCode(), 192));
        ICON_REDO = UIHook.loadIcon("thunderheadeng/gui/graphics/Redo16.gif");
        UI_HOOK_REDO = new UIHook(new RedoAction(), Intl.intl("&Redo,Y,Redo last action,Redo last action"), ICON_REDO, 16);
        UI_HOOK_REDO_MAJOR = new UIHook(new RedoThroughMajorAction(), Intl.intl("&Redo Edit,-,Redo last edit,Redo last edit"), ICON_REDO, 16);
        UI_HOOK_REDO_MAJOR.setKeyStroke(KeyStroke.getKeyStroke(KeyCode.Y.getCode(), 192));
    }

    private static class VentusCallback
    implements UndoFramework.ICallback<VentusData, IMerlinObj, Composite<? extends IMerlinObj>> {
        private VentusCallback() {
        }

        @Override
        public UndoFramework.IWriteLock lockWrites(VentusData mediator) {
            VentusData.WriteLock lock = mediator.lockWrite();
            return () -> lock.close();
        }

        @Override
        public Class<Composite<? extends IMerlinObj>> getGroupType() {
            return Composite.class;
        }

        @Override
        public Class<IMerlinObj> getObjType() {
            return IMerlinObj.class;
        }

        @Override
        public Object getParent(VentusData md, Object child) {
            return md.hierarchy.getParent(child);
        }

        @Override
        public int indexOf(VentusData md, Composite<? extends IMerlinObj> parent, IMerlinObj child) {
            return parent.indexOf(child);
        }

        @Override
        public void removeAll(Composite<? extends IMerlinObj> parent, Collection<? extends IMerlinObj> children) {
            parent.removeAll(children);
        }

        @Override
        public void addAll(Composite<? extends IMerlinObj> parent, Collection<? extends IMerlinObj> children, OptionalInt where) {
            if (where.isPresent()) {
                parent.insert(children, where.getAsInt());
            } else {
                parent.addAll(children);
            }
        }

        @Override
        public boolean contains(Composite<? extends IMerlinObj> parent, IMerlinObj child) {
            return parent.contains(child);
        }

        @Override
        public boolean canAdd(Composite<? extends IMerlinObj> group, IMerlinObj obj) {
            return group.getFilter().test(obj);
        }

        @Override
        public String getName(IMerlinObj obj) {
            return MerlinUtil.getName(obj);
        }

        @Override
        public Object getRestoreObj(IMerlinObj obj) {
            return obj.getRestoreObj();
        }

        @Override
        public void restoreFrom(IMerlinObj obj, Object memento) {
            obj.restoreFrom(memento);
        }

        @Override
        public Optional<UndoFramework.UndoOp> getUndoOpPropRestore(IMerlinObj obj, Collection<? extends TypedProp<?>> props) {
            return obj.getUndoOpPropRestore(props);
        }

        @Override
        public <T> PropValue<T> getWithDetails(IMerlinObj obj, TypedProp<T> prop) {
            return obj.getWithDetails(prop);
        }

        @Override
        public <T> void set(IMerlinObj obj, TypedProp<T> prop, T value) {
            obj.set(prop, value);
        }

        @Override
        public IMerlinObj getSelection(VentusData md) {
            return md.selection;
        }
    }

    private static class UndoAction
    extends AMerlinOp
    implements IEventObserver {
        public UndoAction() {
            VentusApp.getApp().getData().getEvents().addObserver(this);
            this.setEnabled(Undo.global().canUndo());
        }

        @Override
        public void run(VentusApp app, VentusData md) {
            Undo.global().undo(md);
        }

        @Override
        public void update(Events events) {
            if (events.isAffected(UndoFramework.UndoStatus.class)) {
                this.setEnabled(Undo.global().canUndo());
                UI_HOOK_UNDO.setName(Undo.global().getUndoName(false));
                String desc = Undo.global().getUndoName(true);
                UI_HOOK_UNDO.setShortDesc(desc);
                UI_HOOK_UNDO.setLongDesc(desc);
            }
        }
    }

    private static class UndoThroughMajorAction
    extends AMerlinOp
    implements IEventObserver {
        public UndoThroughMajorAction() {
            VentusApp.getApp().getData().getEvents().addObserver(this);
        }

        @Override
        public void run(VentusApp app, VentusData vd) {
            Undo.global().undoThrough(vd, UndoThroughMajorAction.lastMajor());
        }

        @Override
        public void update(Events events) {
            if (events.isAffected(UndoFramework.UndoStatus.class)) {
                CompositeUndo op = UndoThroughMajorAction.lastMajor();
                this.setEnabled(op != null);
                if (op != null) {
                    String newName = String.format(Intl.intl("Undo %s"), op.getName());
                    UI_HOOK_UNDO_MAJOR.setName(newName);
                    UI_HOOK_UNDO_MAJOR.setShortDesc(newName);
                    UI_HOOK_UNDO_MAJOR.setLongDesc(newName);
                } else {
                    UI_HOOK_UNDO_MAJOR.setName(Intl.intl("Undo Edit"));
                    UI_HOOK_UNDO_MAJOR.setShortDesc(Intl.intl("Undo last edit"));
                    UI_HOOK_UNDO_MAJOR.setLongDesc(Intl.intl("Undo last edit"));
                }
            }
        }

        private static CompositeUndo lastMajor() {
            return Undo.global().lastMajorUndo();
        }
    }

    private static class RedoAction
    extends AMerlinOp
    implements IEventObserver {
        public RedoAction() {
            VentusApp.getApp().getData().getEvents().addObserver(this);
            this.setEnabled(Undo.global().canRedo());
        }

        @Override
        public void run(VentusApp app, VentusData md) {
            Undo.global().redo(md);
        }

        @Override
        public void update(Events events) {
            if (events.isAffected(UndoFramework.UndoStatus.class)) {
                this.setEnabled(Undo.global().canRedo());
                UI_HOOK_REDO.setName(Undo.global().getRedoName(false));
                String desc = Undo.global().getRedoName(true);
                UI_HOOK_REDO.setShortDesc(desc);
                UI_HOOK_REDO.setLongDesc(desc);
            }
        }
    }

    private static class RedoThroughMajorAction
    extends AMerlinOp
    implements IEventObserver {
        public RedoThroughMajorAction() {
            VentusApp.getApp().getData().getEvents().addObserver(this);
        }

        @Override
        public void run(VentusApp app, VentusData vd) {
            Undo.global().redoThrough(vd, RedoThroughMajorAction.lastMajor());
        }

        @Override
        public void update(Events events) {
            if (events.isAffected(UndoFramework.UndoStatus.class)) {
                CompositeUndo op = RedoThroughMajorAction.lastMajor();
                this.setEnabled(op != null);
                if (op != null) {
                    String newName = String.format(Intl.intl("Redo %s"), op.getName());
                    UI_HOOK_REDO_MAJOR.setName(newName);
                    UI_HOOK_REDO_MAJOR.setShortDesc(newName);
                    UI_HOOK_REDO_MAJOR.setLongDesc(newName);
                } else {
                    UI_HOOK_REDO_MAJOR.setName(Intl.intl("Redo Edit"));
                    UI_HOOK_REDO_MAJOR.setShortDesc(Intl.intl("Redo last edit"));
                    UI_HOOK_REDO_MAJOR.setLongDesc(Intl.intl("Redo last edit"));
                }
            }
        }

        private static CompositeUndo lastMajor() {
            return Undo.global().lastMajorRedo();
        }
    }

    public static class RecentRedosAction
    implements IEventObserver {
        private final JMenu d_topMenu = new JMenu(Intl.intl("Redo"));

        public RecentRedosAction(VentusData vd) {
            vd.getEvents().addObserver(this);
        }

        public JMenu getMenu() {
            return this.d_topMenu;
        }

        @Override
        public void update(Events events) {
            if (events.isAffected(UndoFramework.UndoStatus.class)) {
                this.updateMenu();
            }
        }

        private void updateMenu() {
            this.d_topMenu.removeAll();
            List<CompositeUndo> redoList = Undo.global().getRedoStack().toList();
            if (!redoList.isEmpty()) {
                this.d_topMenu.add(UI_HOOK_REDO);
            }
            for (int i = redoList.size() - 2; i >= 0; --i) {
                CompositeUndo op = redoList.get(i);
                UIHook hook = new UIHook(new RedoThroughOp(op), op.getName(), ICON_REDO, 16);
                String desc = String.format(Intl.intl("Redo %s"), op.getName());
                hook.setShortDesc(desc);
                hook.setLongDesc(desc);
                this.d_topMenu.add(hook);
            }
            this.d_topMenu.setEnabled(!redoList.isEmpty());
        }
    }

    public static class RecentUndosAction
    implements IEventObserver {
        private final JMenu d_topMenu = new JMenu(Intl.intl("Undo"));

        public RecentUndosAction(VentusData vd) {
            vd.getEvents().addObserver(this);
        }

        public JMenu getMenu() {
            return this.d_topMenu;
        }

        @Override
        public void update(Events events) {
            if (events.isAffected(UndoFramework.UndoStatus.class)) {
                this.updateMenu();
            }
        }

        private void updateMenu() {
            this.d_topMenu.removeAll();
            List<CompositeUndo> undoList = Undo.global().getUndoStack().toList();
            if (!undoList.isEmpty()) {
                this.d_topMenu.add(UI_HOOK_UNDO);
            }
            for (int i = undoList.size() - 2; i >= 0; --i) {
                CompositeUndo op = undoList.get(i);
                UIHook hook = new UIHook(new UndoThroughOp(op), op.getName(), ICON_UNDO, 16);
                String desc = String.format(Intl.intl("Undo %s"), op.getName());
                hook.setShortDesc(desc);
                hook.setLongDesc(desc);
                this.d_topMenu.add(hook);
            }
            this.d_topMenu.setEnabled(!undoList.isEmpty());
        }
    }

    public static class RedoDropdownButton
    extends DropDownButton
    implements IEventObserver {
        private static final long serialVersionUID = 1L;

        public RedoDropdownButton(VentusData vd) {
            super(Collections.singleton(UI_HOOK_REDO), 3);
            vd.getEvents().addObserver(this);
        }

        @Override
        public void update(Events events) {
            if (events.isAffected(UndoFramework.UndoStatus.class)) {
                List<CompositeUndo> redoList = Undo.global().getRedoStack().toList();
                ArrayList<UIHook> hooks = new ArrayList<UIHook>(redoList.size());
                hooks.add(UI_HOOK_REDO);
                for (int i = redoList.size() - 2; i >= 0; --i) {
                    CompositeUndo op = redoList.get(i);
                    UIHook hook = new UIHook(new RedoThroughOp(op), op.getName(), ICON_REDO, 16);
                    String desc = String.format(Intl.intl("Redo %s"), op.getName());
                    hook.setShortDesc(desc);
                    hook.setLongDesc(desc);
                    hooks.add(hook);
                }
                this.setAvailableActions(hooks);
            }
        }
    }

    private static class RedoThroughOp
    extends AMerlinOp {
        private final UndoFramework.UndoOp d_op;

        public RedoThroughOp(UndoFramework.UndoOp op) {
            this.d_op = op;
        }

        @Override
        public void run(VentusApp app, VentusData vd) {
            Undo.global().redoThrough(vd, this.d_op);
        }
    }

    public static class UndoDropdownButton
    extends DropDownButton
    implements IEventObserver {
        private static final long serialVersionUID = 1L;

        public UndoDropdownButton(VentusData vd) {
            super(Collections.singleton(UI_HOOK_UNDO), 3);
            vd.getEvents().addObserver(this);
        }

        @Override
        public void update(Events events) {
            if (events.isAffected(UndoFramework.UndoStatus.class)) {
                List<CompositeUndo> undoList = Undo.global().getUndoStack().toList();
                ArrayList<UIHook> hooks = new ArrayList<UIHook>(undoList.size());
                hooks.add(UI_HOOK_UNDO);
                for (int i = undoList.size() - 2; i >= 0; --i) {
                    CompositeUndo op = undoList.get(i);
                    UIHook hook = new UIHook(new UndoThroughOp(op), op.getName(), ICON_UNDO, 16);
                    String desc = String.format(Intl.intl("Undo %s"), op.getName());
                    hook.setShortDesc(desc);
                    hook.setLongDesc(desc);
                    hooks.add(hook);
                }
                this.setAvailableActions(hooks);
            }
        }
    }

    private static class UndoThroughOp
    extends AMerlinOp {
        private final UndoFramework.UndoOp d_op;

        public UndoThroughOp(UndoFramework.UndoOp op) {
            this.d_op = op;
        }

        @Override
        public void run(VentusApp app, VentusData vd) {
            Undo.global().undoThrough(vd, this.d_op);
        }
    }

    public static class StackSizePrefObserver
    implements IEventObserver {
        private final VentusApp d_app;

        public StackSizePrefObserver(VentusApp app) {
            this.d_app = app;
            this.applyStackSize(false);
            this.d_app.getData().getEvents().addObserverInDomain((IEventObserver)this, VentusData.class, false, false, VentusData.PREFS_CHANGED);
        }

        @Override
        public void update(Events events) {
            if (events.isChanged(this.d_app.getData(), VentusData.PREFS_CHANGED)) {
                this.applyStackSize(true);
            }
        }

        private void applyStackSize(boolean fireEvents) {
            int stackSize = this.d_app.getPrefs().get(MerlinPrefs.UNDO_STACK_SIZE);
            Undo undo = Undo.global();
            undo.getUndoStack().setLimit(stackSize, stackSize * 2);
            undo.getRedoStack().setLimit(stackSize, stackSize * 2);
            if (fireEvents) {
                undo.fireChangeEvt(this.d_app.getData());
            }
        }
    }
}

