/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.function.BiConsumer;
import ventus.actions.ShortcutInfo;

public class Shortcut<T> {
    private final ShortcutInfo shortcutInfo;
    private T operator;
    private String overrideName;

    public Shortcut(ShortcutInfo shortcutInfo) {
        this(shortcutInfo, null);
    }

    public Shortcut(ShortcutInfo shortcutInfo, T operator) {
        this.shortcutInfo = shortcutInfo;
        this.operator = operator;
    }

    public Shortcut(ShortcutInfo shortcutInfo, T operator, String overrideName) {
        this.shortcutInfo = shortcutInfo;
        this.operator = operator;
        this.overrideName = overrideName;
    }

    public String getKey() {
        return this.shortcutInfo.key;
    }

    public ShortcutInfo.Category getCategory() {
        return this.shortcutInfo.category;
    }

    public String getDefaultKeystroke() {
        return this.shortcutInfo.defaultKeystroke;
    }

    public String getKeystroke() {
        return this.shortcutInfo.getKeyStroke();
    }

    public T getOperator() {
        return this.operator;
    }

    public void setOperator(T operator) {
        this.operator = operator;
    }

    public boolean hasOverrideName() {
        return this.overrideName != null;
    }

    public String getOverrideName() {
        return this.overrideName;
    }

    public void setKeystroke(String keystroke) {
        this.shortcutInfo.setKeyStroke(keystroke);
    }

    public void mapShortcutOperator(BiConsumer<Shortcut, T> addToMap, T operator) {
        this.operator = operator;
        this.mapShortcutOperator(addToMap);
    }

    public void mapShortcutOperator(BiConsumer<Shortcut, T> addToMap) {
        if (this.operator != null) {
            addToMap.accept(this, (Shortcut)this.operator);
        }
    }
}

