/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.function.Function;
import java.util.stream.Stream;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.SelectObjectsForLevel;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.ISchematicObj;
import ventus.util.MerlinUtil;

public class SelectSchematicCompsForLevel
extends SelectObjectsForLevel
implements IEventObserver {
    public static final SelectSchematicCompsForLevel INSTANCE = new SelectSchematicCompsForLevel();
    public static final UIHook UI_HOOK = INSTANCE.getHook();

    public SelectSchematicCompsForLevel() {
        super(SelectSchematicCompsForLevel.getAll(), Intl.intl("Select All Objects within Level"), "selectAllWithinLevel");
        SelectionObserver.add(this, IMerlinObj.class);
        this.update(null);
    }

    private static Function<VentusData, ? extends Stream<? extends ISchematicObj>> getAll() {
        return vd -> MerlinUtil.flatten(vd.getChildren(), ISchematicObj.class).stream();
    }

    @Override
    public void update(Events events) {
        VentusData vd = VentusApp.getApp().getData();
        this.setEnabled(!vd.selection.isDeepEmpty(Floor.class));
    }
}

