/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.function.Function;
import java.util.stream.Stream;
import thunderheadeng.util.GroupedSequence;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.Shortcut;
import ventus.actions.ShortcutInfo;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.ISchematicObj;
import ventus.feature.CompositeFeatureGuid;
import ventus.feature.comps.BasicHotkey;
import ventus.feature.comps.IContextMenuItem;
import ventus.feature.comps.IHotkey;
import ventus.gui.ContextMenuUtils;

public class SelectObjectsForLevel<T extends ISchematicObj>
extends AMerlinOp
implements IHotkey<UIHook>,
IContextMenuItem {
    private final Function<VentusData, ? extends Stream<? extends T>> d_streamObjs;
    private final String d_actionDescription;
    private final UIHook d_hook;
    private final IHotkey<UIHook> d_hotkey;

    public <RootT extends Composite<T>> SelectObjectsForLevel(CompositeFeatureGuid<RootT, T> feature, String description, String shortcutKey) {
        this(feature, feature.objType, description, shortcutKey);
    }

    public <RootT extends Composite<ObjT>, ObjT extends IMerlinObj> SelectObjectsForLevel(CompositeFeatureGuid<RootT, ObjT> feature, Class<T> searchClass, String description, String shortcutKey) {
        this((VentusData vd) -> ((Composite)vd.getComponentData(feature)).flatten(searchClass).stream(), description, shortcutKey);
    }

    public SelectObjectsForLevel(Function<VentusData, ? extends Stream<? extends T>> streamObjs, String description, String shortcutKey) {
        this.d_streamObjs = streamObjs;
        this.d_actionDescription = description;
        this.d_hook = new UIHook(this, this.d_actionDescription);
        this.d_hotkey = new BasicHotkey<UIHook>(shortcutKey, ShortcutInfo.Category.SELECTION, this.d_hook, true);
    }

    @Override
    public Shortcut<UIHook> getKeyboardShortcut() {
        return this.d_hotkey.getKeyboardShortcut();
    }

    @Override
    public boolean isHeadless() {
        return this.d_hotkey.isHeadless();
    }

    public UIHook getHook() {
        return this.d_hook;
    }

    @Override
    public void addContextMenuItem(GroupedSequence root) {
        root.getNode(ContextMenuUtils.ContextMenuNode.ENABLE_SELECT.id).getNode(ContextMenuUtils.ContextMenuNode.SELECT_WITHIN_LEVEL.id).add(this.d_hook);
    }

    @Override
    public void run(VentusApp app, VentusData vd) {
        IdentityHashSet searchFloors = new IdentityHashSet(vd.selection.getDeepSelected(Floor.class));
        if (searchFloors.isEmpty()) {
            return;
        }
        LinkedIdentityHashSet objsToSelect = new LinkedIdentityHashSet();
        this.d_streamObjs.apply(vd).filter(obj -> obj.isSupportedLocally(VentusData.LEVEL)).forEach(obj -> {
            Floor level = obj.get(VentusData.LEVEL);
            if (searchFloors.contains(level)) {
                objsToSelect.add(obj);
            }
        });
        try (VentusData.WriteLock lock = vd.lockWrite();){
            Undo.begin(this.d_actionDescription);
            Undo.insertUndoEntry_restoreSelection(vd);
            vd.selection.clear();
            vd.selection.selectAll(objsToSelect);
            Undo.end(vd);
        }
    }
}

