/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import ventus.EntryPoint;
import ventus.EntryPointFactory;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.SimError;

public class SelectInvalidObjs
extends AMerlinOp
implements IEventObserver {
    public static final UIHook CRITICAL_HOOK = new UIHook(new SelectInvalidObjs(SimError.Level.CRITICAL), Intl.intl("Select Errors"));
    public static final UIHook MODERATE_HOOK = new UIHook(new SelectInvalidObjs(SimError.Level.MODERATE), Intl.intl("Select Warnings"));
    private final SimError.Level d_level;

    public SelectInvalidObjs(SimError.Level level) {
        this.d_level = level;
        SelectionObserver.add(this, Object.class);
        this.update(null);
    }

    private static boolean isValid(VentusData md, Object obj, SimError.Level level) {
        if (!(obj instanceof IMerlinObj)) {
            return true;
        }
        EntryPoint<IMerlinObj> ep = EntryPointFactory.get((IMerlinObj)obj);
        Collection<SimError> errors = ep.tvEntryPoint.getErrors(md, (IMerlinObj)obj);
        if (level == null) {
            return errors.isEmpty();
        }
        for (SimError error : errors) {
            if (error.level != level) continue;
            return false;
        }
        return true;
    }

    @Override
    public void update(Events events) {
        VentusData md = VentusApp.getApp().getData();
        if (md.selection.isEmpty()) {
            this.setEnabled(!SelectInvalidObjs.isValid(md, md, this.d_level));
        } else {
            boolean valid = true;
            Set sel = md.selection.getSelected(Object.class);
            for (Object selObj : sel) {
                if (SelectInvalidObjs.isValid(md, selObj, this.d_level)) continue;
                valid = false;
                break;
            }
            this.setEnabled(!valid);
        }
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        ArrayList<Object> invalidObjs = new ArrayList<Object>();
        Set sel = md.selection.getSelected(Object.class);
        if (sel.isEmpty()) {
            SelectInvalidObjs.collectInvalidLeaves(md, Arrays.asList(md), invalidObjs, this.d_level);
        } else {
            SelectInvalidObjs.collectInvalidLeaves(md, sel, invalidObjs, this.d_level);
        }
        if (!invalidObjs.isEmpty()) {
            try (VentusData.WriteLock lock = md.lockWrite();){
                Undo.begin(this.d_level == SimError.Level.CRITICAL ? Intl.intl("Select Errors") : Intl.intl("Select Warnings"));
                Undo.insertUndoEntry_restoreSelection(md);
                md.selection.set(invalidObjs);
                Undo.end(md);
            }
        }
    }

    private static void collectInvalidLeaves(VentusData md, Collection<?> objs, List<Object> invalidObjs, SimError.Level level) {
        for (Object obj : objs) {
            Collection<SimError> errors = EntryPointFactory.get(obj).tvEntryPoint.getErrors(md, obj);
            for (SimError error : errors) {
                if (level != null && error.level != level) continue;
                invalidObjs.addAll(error.causeObjs);
            }
        }
    }
}

