/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import thunderheadeng.gui.RenameDialog;
import thunderheadeng.gui.framework.UndoFramework;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;
import ventus.EntryPoint;
import ventus.EntryPointFactory;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.INamed;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.util.MerlinUtil;

public class RenameAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new RenameAction(), Intl.intl("&Rename...,-,Rename selected objects"));
    private static final EnumSet<RenameDialog.DefaultKeywordOpts> s_allowedKeywords = EnumSet.complementOf(EnumSet.of(RenameDialog.DefaultKeywordOpts.RESULTS_ID, RenameDialog.DefaultKeywordOpts.SELECTION_IX));

    public RenameAction() {
        SelectionObserver.add(this, INamed.class);
        this.update(null);
    }

    @Override
    public void run(VentusApp app, VentusData vd) {
        Collection<INamed> objs = RenameAction.getRenameObjs(vd);
        assert (!objs.isEmpty());
        INamed[] namedArr = theUtil.toArray(objs, INamed.class);
        RenameDialog.ICallback<INamed> callback = RenameAction.getRenameCallback(vd);
        List keywords = RenameDialog.getDefaultKeywords(callback, objs, s_allowedKeywords);
        RenameDialog<INamed> dlg = new RenameDialog<INamed>((Window)app.getActiveFrame(), callback, keywords, objs);
        if (dlg.doModal() != 1) {
            return;
        }
        List<String> newNames = dlg.generateNames((INamed[])namedArr);
        if (newNames.isEmpty()) {
            return;
        }
        try (VentusData.WriteLock lock = vd.lockWrite();){
            assert (newNames.size() == namedArr.length);
            List<Pair> entries = IntStream.range(0, namedArr.length).filter(i -> newNames.get(i) != null).mapToObj(i -> new Pair<INamed, String>(namedArr[i], (String)newNames.get(i))).toList();
            List<INamed> filteredToRename = entries.stream().map(e -> (INamed)e.v1).toList();
            List<String> filteredNewNames = entries.stream().map(e -> (String)e.v2).toList();
            RenameAction.renameImpl(vd, filteredToRename, filteredNewNames);
        }
    }

    private static void renameImpl(VentusData vd, List<? extends INamed> objs, List<String> newNames) {
        if (objs.isEmpty()) {
            return;
        }
        Undo.begin(Intl.intl("Rename"));
        RenameOp op = new RenameOp(objs, newNames, true);
        op.perform();
        Undo.insertEntry(vd, op.getReverseOp());
        Undo.end(vd);
    }

    private static RenameDialog.ICallback<INamed> getRenameCallback(final VentusData vd) {
        return new RenameDialog.ICallback<INamed>(){

            @Override
            public Object getRoot(INamed obj) {
                Object[] path = vd.hierarchy.getPath(obj);
                return path == null || path.length < 2 ? null : path[1];
            }

            @Override
            public Object getParent(Object obj) {
                return vd.hierarchy.getParent(obj);
            }

            @Override
            public List<Object> getChildren(Object obj) {
                return vd.hierarchy.getChildren(obj).stream().toList();
            }

            @Override
            public List<Object> flattenHierarchy(Object obj) {
                return MerlinUtil.flatten(vd.hierarchy.getChildren(obj)).stream().toList();
            }

            @Override
            public String getName(Object obj) {
                return MerlinUtil.getName(obj);
            }

            @Override
            public String getTypeString(INamed obj) {
                return EntryPointFactory.get(obj).getTypeString(vd, obj);
            }

            @Override
            public OptionalLong getResultsId(INamed obj) {
                assert (false);
                return OptionalLong.empty();
            }

            @Override
            public Predicate<String> getNameValidator(INamed obj) {
                return EntryPointFactory.get(obj).getNameFormat(vd, obj);
            }

            @Override
            public Object getUniqueNameGroup(INamed obj) {
                return EntryPointFactory.get(obj).getUniqueNameGroup(vd, obj);
            }

            @Override
            public Collection<?> getGroupObjs(Object group) {
                if (group instanceof EntryPoint.INameGroup) {
                    return ((EntryPoint.INameGroup)group).getSharedNameGroupObjs(vd);
                }
                return Collections.emptyList();
            }
        };
    }

    public static boolean rename(VentusData md, Window parent, Collection<? extends INamed> objs, String newName) {
        if (objs.isEmpty()) {
            return true;
        }
        Optional<Function<INamed, String>> validatedResult = RenameDialog.validateNames(parent, RenameAction.getRenameCallback(md), objs, o -> newName);
        if (validatedResult.isEmpty()) {
            return false;
        }
        Function<INamed, String> namesFunc = validatedResult.get();
        IFilteredCollection<INamed> renObjs = theUtil.filter(objs, o -> namesFunc.apply((INamed)o) != null);
        if (renObjs.isEmpty()) {
            return false;
        }
        List<String> newNames = renObjs.stream().map(namesFunc).toList();
        Undo.begin(Intl.intl("Rename"));
        RenameOp op = new RenameOp(new ArrayList<INamed>(renObjs), newNames, true);
        op.perform();
        Undo.insertEntry(md, op.getReverseOp());
        Undo.end(md);
        return renObjs.size() == objs.size();
    }

    private static Collection<INamed> getRenameObjs(VentusData md) {
        return md.selection.get(INamed.class, n -> EntryPointFactory.get(n).tvEntryPoint.canRename(md, (INamed)n));
    }

    @Override
    public void update(Events events) {
        VentusApp app = Objects.requireNonNull(VentusApp.getApp());
        VentusData data = app.getData();
        this.setEnabled(!RenameAction.getRenameObjs(data).isEmpty());
    }

    private static class RenameOp
    implements UndoFramework.UndoOp,
    Cloneable {
        private final List<? extends INamed> d_objs;
        private final List<String> d_oldNames;
        private final List<String> d_newNames;
        private boolean d_ascend;

        public RenameOp(List<? extends INamed> objs, List<String> newNames, boolean ascend) {
            this.d_objs = objs;
            this.d_oldNames = new ArrayList<String>(objs.size());
            for (INamed iNamed : objs) {
                if (iNamed instanceof Floor) {
                    this.d_oldNames.add(((Floor)iNamed).getBaseName());
                    continue;
                }
                this.d_oldNames.add(iNamed.getName());
            }
            this.d_newNames = newNames;
            this.d_ascend = ascend;
        }

        private UndoFramework.UndoOp getReverseOp() {
            try {
                RenameOp clone = (RenameOp)this.clone();
                clone.d_ascend = !clone.d_ascend;
                return clone;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        @Override
        public UndoFramework.UndoOp perform() {
            UndoFramework.UndoOp undo = this.getReverseOp();
            if (this.d_ascend) {
                for (int m = 0; m < this.d_objs.size(); ++m) {
                    INamed obj = this.d_objs.get(m);
                    obj.setName(this.d_newNames.get(m));
                }
            } else {
                for (int m = this.d_objs.size() - 1; m >= 0; --m) {
                    INamed obj = this.d_objs.get(m);
                    String oldName = this.d_oldNames.get(m);
                    obj.setName(oldName);
                }
            }
            return undo;
        }

        @Override
        public boolean isMajor() {
            return true;
        }
    }
}

