/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.Set;
import thunderheadeng.scene3d.IntermediateGraphicsXfer;
import thunderheadeng.scene3d.gui.BGImageDlg;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.AddBGImage;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.MerlinSelectionModel;
import ventus.data.VentusData;
import ventus.data.image.BGImage;

public class EditProps
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new EditProps(), Intl.intl("Properties..."));

    private EditProps() {
        SelectionObserver.add(this, Object.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        VentusApp app = VentusApp.getApp();
        VentusData md = app.getData();
        MerlinSelectionModel sel = md.selection;
        boolean enabled = sel.isExclusive(BGImage.class) && sel.getSelectionCount() == 1;
        this.setEnabled(enabled);
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        MerlinSelectionModel sel = md.selection;
        if (sel.isExclusive(BGImage.class)) {
            EditProps.editBGImage(app, md);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void editBGImage(VentusApp app, VentusData md) {
        Set images = md.selection.getSelected(BGImage.class);
        if (images.isEmpty()) {
            return;
        }
        BGImage i = (BGImage)images.iterator().next();
        IntermediateGraphicsXfer igx = new IntermediateGraphicsXfer();
        try {
            BGImageDlg.ImageInfo result = md.ui(() -> AddBGImage.editBGImage(app.getActiveFrame(), i, igx));
            if (result == null) {
                return;
            }
            try (VentusData.WriteLock lock = md.lockWrite();){
                Undo.begin(Intl.intl("Edit Image"));
                Undo.insertUndoEntry_restore(md, i);
                AddBGImage.applyBGInfo(i, result);
                Undo.end(md);
            }
        }
        finally {
            igx.release();
        }
    }
}

