/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.Set;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.schematics.geom.SchematicRoom;

public class ConvertToRoom {
    public static ConvertedRoom convertToRoom(ISchematicRoom geom, boolean cloneIfRoom, Set<? extends ISchematicRoom> mergeRooms) {
        if (geom instanceof SchematicRoom) {
            SchematicRoom room = cloneIfRoom ? (SchematicRoom)geom.clone() : (SchematicRoom)geom;
            return new ConvertedRoom(geom, room);
        }
        Model model = ConvertToRoom.getModel(geom);
        if (model == null || model.getFaces().isEmpty()) {
            return null;
        }
        SchematicRoom room = new SchematicRoom(geom.getName(), model);
        room.setColor(geom.getColor());
        room.setOpacity(geom.getOpacity());
        room.setVisible(geom.isVisible());
        return new ConvertedRoom(geom, room);
    }

    private static Model getModel(ISchematicRoom geom) {
        Model model = geom.getModel().clone();
        int[] bndIDs = new int[]{1};
        for (Face face : model.getFaces()) {
            for (FaceLoop loop : face.edgeLoops) {
                for (EdgeUse eu : loop.edges) {
                    if (eu.edge.partOfGroup(1) || eu.edge.faces.size() != 1 || face.getInternalEdges().contains(eu.edge)) continue;
                    eu.edge.groups = bndIDs;
                }
            }
        }
        return model;
    }

    public static class ConvertedRoom {
        public final ISchematicRoom source;
        public final SchematicRoom room;

        public ConvertedRoom(ISchematicRoom source, SchematicRoom room) {
            this.source = source;
            this.room = room;
        }
    }
}

