/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.ArrayList;
import java.util.Collection;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.camera.CameraList;
import ventus.data.camera.IViewObj;

public class CaptureCamera
extends AMerlinOp
implements IEventObserver {
    public static final UIHook CONTEXT_HOOK = new UIHook(new CaptureCamera(), Intl.intl("Update View,-,Updates the selected view(s) with the current state of the perspective view"));

    public CaptureCamera() {
        SelectionObserver.add(this, IViewObj.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        this.setEnabled(this.getEnabled());
    }

    private boolean getEnabled() {
        VentusData md = VentusApp.getApp().getData();
        return md.selection.isExclusive(IViewObj.class, CameraList.class);
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        ArrayList views = new ArrayList(md.selection.getDeepSelected(IViewObj.class));
        CaptureCamera.updateViews(app, md, views);
    }

    public static void updateViews(VentusApp app, VentusData md, Collection<? extends IViewObj> views) {
        CameraRecord state = md.ui(() -> {
            Camera cam = app.getModelView().getCamera(3);
            return cam.capture();
        });
        try (VentusData.WriteLock lock = md.lockWrite();){
            Undo.begin(Intl.intl("Update View"));
            IFilteredCollection<IMerlinObj> restorables = theUtil.filter(views, IMerlinObj.class);
            if (restorables.isExclusive()) {
                Undo.insertUndoEntry_restore(md, restorables);
            } else {
                Undo.insertEntry_breakChain(md);
            }
            for (IViewObj iViewObj : views) {
                iViewObj.setCameraState(state);
            }
            Undo.end(md);
        }
    }
}

