/*
 * Decompiled with CFR 0.152.
 */
package ventus.unitsystem;

import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import ventus.Intl;
import ventus.unitsystem.UnitSystem;

public class SIUS
extends UnitSystem {
    private static final SIUS s_fdsSystem = new SIUS();

    private SIUS() {
        super(Intl.intl("SI"));
        this.addUnit(0, SI.METER, true);
        this.addUnit(4, SI.CENTI(SI.METER), false);
        this.addUnit(1, SI.SECOND, true);
        this.addUnit(2, SI.METER.pow(2), true);
        this.addUnit(16, SI.METER.pow(3), true);
        this.addUnit(3, SI.METER.divide(SI.SECOND), true);
        this.addUnit(5, NonSI.DEGREE_ANGLE, true);
        this.addUnit(6, SI.METER.divide(SI.SECOND.pow(2)), true);
        this.addUnit(7, Unit.ONE.alternate("pers"), true);
        this.addUnit(8, Unit.ONE.alternate("pers").divide(SI.METER.pow(2)), true);
        this.addUnit(9, NonSI.PERCENT, true);
        this.addUnit(10, Unit.ONE, true);
        this.addUnit(11, NonSI.DEGREE_ANGLE.divide(SI.SECOND), true);
        this.addUnit(12, NonSI.PERCENT.divide(SI.SECOND), true);
        this.addUnit(13, SI.METER.pow(-1).label("1/m"), true);
        this.addUnit(14, SI.CELSIUS, true);
        this.addUnit(15, SI.PASCAL, true);
        this.addUnit(17, SI.KILOGRAM.divide(SI.SECOND), true);
        this.addUnit(18, SI.GRAM.divide(SI.MOLE), true);
        this.addUnit(19, SI.METER.pow(2).divide(SI.SECOND), true);
        this.addUnit(20, SI.JOULE.divide(SI.KILOGRAM.multiply(SI.KELVIN)), true);
        this.addUnit(21, SI.MICRO(SI.METER), false);
        this.addUnit(22, SI.KILOGRAM.divide(SI.METER.pow(3)), false);
        this.addUnit(23, Unit.ONE.alternate("parts").divide(SI.SECOND), false);
        this.addUnit(24, SI.CENTI(SI.METER).pow(2).divide(SI.MICRO(SI.JOULE)), false);
        this.addUnit(25, SI.KILOGRAM.alternate("kg_cont").divide(SI.KILOGRAM.alternate("kg_air")), false);
        this.addUnit(26, SI.KILOGRAM.divide(SI.SECOND), false);
        this.addUnit(27, SI.METER.pow(3).divide(SI.SECOND), false);
    }

    public static SIUS getInstance() {
        return s_fdsSystem;
    }

    public static Unit unit(int type) {
        return SIUS.getInstance().getUnit(type);
    }

    public static UnitDouble newud(double val, int id) {
        return new UnitDouble(val, SIUS.unit(id));
    }
}

