/*
 * Decompiled with CFR 0.152.
 */
package ventus.unitsystem;

import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import ventus.Intl;
import ventus.unitsystem.UnitSystem;

public class EnglishUS
extends UnitSystem {
    private static final EnglishUS s_fdsSystem = new EnglishUS();

    private EnglishUS() {
        super(Intl.intl("EN"));
        this.addUnit(0, NonSI.FOOT, true);
        this.addUnit(4, NonSI.INCH, false);
        this.addUnit(1, SI.SECOND, true);
        this.addUnit(2, NonSI.FOOT.pow(2), true);
        this.addUnit(16, NonSI.FOOT.pow(3), true);
        this.addUnit(3, NonSI.FOOT.divide(SI.SECOND), true);
        this.addUnit(5, NonSI.DEGREE_ANGLE, true);
        this.addUnit(6, NonSI.FOOT.divide(SI.SECOND.pow(2)), true);
        this.addUnit(7, Unit.ONE.alternate("pers"), true);
        this.addUnit(8, Unit.ONE.alternate("pers").divide(NonSI.FOOT.pow(2)), true);
        this.addUnit(9, NonSI.PERCENT, true);
        this.addUnit(10, Unit.ONE, true);
        this.addUnit(11, NonSI.DEGREE_ANGLE.divide(SI.SECOND), true);
        this.addUnit(12, NonSI.PERCENT.divide(SI.SECOND), true);
        this.addUnit(13, NonSI.FOOT.pow(-1).label("1/ft"), true);
        this.addUnit(14, NonSI.FAHRENHEIT, true);
        this.addUnit(15, NonSI.INCH_OF_MERCURY.multiply(0.0734807847747814).label("inWC"), true);
        this.addUnit(17, SI.KILOGRAM.divide(SI.SECOND).multiply(5.6827E-4).label("scfm"), true);
        this.addUnit(18, SI.GRAM.divide(SI.MOLE), true);
        this.addUnit(19, SI.METER.pow(2).divide(SI.SECOND), true);
        this.addUnit(20, NonSI.BTU.divide(NonSI.POUND.multiply(NonSI.RANKINE)), true);
        this.addUnit(21, SI.MICRO(SI.METER), false);
        this.addUnit(22, NonSI.POUND.divide(NonSI.FOOT.pow(3)), false);
        this.addUnit(23, Unit.ONE.alternate("parts").divide(SI.SECOND), false);
        this.addUnit(24, SI.CENTI(SI.METER).pow(2).divide(SI.MICRO(SI.JOULE)), false);
        this.addUnit(25, SI.KILOGRAM.alternate("lb_cont").divide(SI.KILOGRAM.alternate("lb_air")), false);
        this.addUnit(26, NonSI.POUND.divide(SI.SECOND), false);
        this.addUnit(27, NonSI.FOOT.pow(3).divide(SI.SECOND), false);
        NonSI.FOOT.pow(3).divide(NonSI.MINUTE).alias("cfm");
    }

    public static EnglishUS getInstance() {
        return s_fdsSystem;
    }

    public static Unit unit(int type) {
        return EnglishUS.getInstance().getUnit(type);
    }

    public static UnitDouble newud(double val, int id) {
        return new UnitDouble(val, EnglishUS.unit(id));
    }
}

