/*
 * Decompiled with CFR 0.152.
 */
package ventus.treeview;

import java.awt.Component;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JLabel;
import ventus.EntryPoint;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.SimError;
import ventus.gui.guiUtil;

public class TVEntryPoint<T> {
    private static final Map<Icon, Icon> s_disabledIcons = new WeakHashMap<Icon, Icon>();
    private final EntryPoint.Getter<T, Collection<? extends SimError>> getErrors;
    private final EntryPoint.Getter<T, Collection<? extends SimError>> getRuntimeErrors;
    private final EntryPoint.Getter<T, String> getName;
    private final EntryPoint.Setter<T, String> setName;
    private final EntryPoint.Getter<T, Boolean> canRename;
    private final EntryPoint.AsyncGetter<T, Icon> getIcon;
    private final EntryPoint.Getter<T, Font> getBaseFont;
    private final EntryPoint.Getter<T, Boolean> isVisible;
    private final EntryPoint.Getter<T, Boolean> isEnabled;
    private final EntryPoint.Getter<T, Boolean> getForcedAutoexpand;
    private final EntryPoint.Getter<T, Boolean> isLeaf;
    private final EntryPoint.Getter<T, Collection<?>> getChildren;
    private final EntryPoint.Getter<T, Object> getParent;

    public TVEntryPoint(EntryPoint.Getter<T, Collection<? extends SimError>> getErrors, EntryPoint.Getter<T, Collection<? extends SimError>> getRuntimeErrors, EntryPoint.Getter<T, String> getName, EntryPoint.Setter<T, String> setName, EntryPoint.Getter<T, Boolean> canRename, EntryPoint.AsyncGetter<T, Icon> getIcon, EntryPoint.Getter<T, Font> getBaseFont, EntryPoint.Getter<T, Boolean> isVisible, EntryPoint.Getter<T, Boolean> isEnabled, EntryPoint.Getter<T, Boolean> getForcedAutoexpand, EntryPoint.Getter<T, Boolean> isLeaf, EntryPoint.Getter<T, Collection<?>> getChildren, EntryPoint.Getter<T, Object> getParent) {
        this.getErrors = getErrors;
        this.getRuntimeErrors = getRuntimeErrors;
        this.getName = getName;
        this.setName = setName;
        this.canRename = canRename;
        this.getIcon = getIcon;
        this.getBaseFont = getBaseFont;
        this.isVisible = isVisible;
        this.isEnabled = isEnabled;
        this.getForcedAutoexpand = getForcedAutoexpand;
        this.isLeaf = isLeaf;
        this.getChildren = getChildren;
        this.getParent = getParent;
    }

    public Collection<? extends SimError> getErrors(VentusData md, T obj) {
        if (obj instanceof IMerlinObj && ((IMerlinObj)obj).isPlaceholder()) {
            return Collections.emptyList();
        }
        return this.getErrors.get(md, obj);
    }

    public Collection<? extends SimError> getRuntimeErrors(VentusData md, T obj) {
        if (obj instanceof IMerlinObj && ((IMerlinObj)obj).isPlaceholder()) {
            return Collections.emptyList();
        }
        return this.getRuntimeErrors.get(md, obj);
    }

    public String getName(VentusData md, T obj) {
        return this.getName.get(md, obj);
    }

    public void setName(VentusData md, T obj, String newText) {
        this.setName.set(md, obj, newText);
    }

    public boolean canRename(VentusData md, T obj) {
        return this.canRename.get(md, obj);
    }

    protected Icon getIcon(VentusData md, T obj, Consumer<Icon> whenReady) {
        return this.getIcon.get(md, obj, whenReady);
    }

    public Icon[] getIcons(VentusData md, Component comp, T obj, Runnable whenReady) {
        Icon baseIcon = this.getIcon(md, obj, icon -> whenReady.run());
        Icon disabledIcon = s_disabledIcons.get(baseIcon);
        if (disabledIcon == null) {
            disabledIcon = guiUtil.createDisabledIcon(baseIcon, comp);
            s_disabledIcons.put(baseIcon, disabledIcon);
        }
        return new Icon[]{baseIcon, disabledIcon};
    }

    public Font getBaseFont(VentusData md, T obj) {
        return this.getBaseFont.get(md, obj);
    }

    public Font getFont(VentusData md, T obj) {
        Font base = null;
        try {
            base = this.getBaseFont(md, obj);
        }
        catch (Exception e) {
            base = new JLabel().getFont();
        }
        if (!this.isEnabled(md, obj)) {
            HashMap attribs = new HashMap(base.getAttributes());
            attribs.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            base = base.deriveFont(attribs);
        }
        return base;
    }

    public boolean isVisible(VentusData md, T obj) {
        return this.isVisible.get(md, obj);
    }

    public boolean isEnabled(VentusData md, T obj) {
        return this.isEnabled.get(md, obj);
    }

    public boolean getForcedAutoexpand(VentusData md, T obj) {
        return this.getForcedAutoexpand.get(md, obj);
    }

    public boolean isLeaf(VentusData md, T obj) {
        return this.isLeaf.get(md, obj);
    }

    public Collection<?> getChildren(VentusData md, T obj) {
        return this.getChildren.get(md, obj);
    }

    public Object getParent(VentusData md, T obj) {
        return this.getParent.get(md, obj);
    }
}

