/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.tools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import ventus.VentusApp;
import ventus.builders.FloorExtractor3D;
import ventus.data.ImportedGeom;
import ventus.geom.Geometry;
import ventus.mv.ModelView;
import ventus.mv.tools.VentusTool;

public class FloorExtractionTool
extends VentusTool<FloorExtractor3D> {
    public FloorExtractionTool(ModelView mv) {
        super(mv, (IToolFunction<? extends CursorTool>)new Func());
        this.setSnapInfo(SnapMode.FILTERED_ONE_PASS, new DefaultFilter(this, ImportedGeom.class, GeomType.FACE){

            @Override
            public boolean acceptPickObject(Object obj) {
                return super.acceptPickObject(obj) && !((ImportedGeom)obj).isIgnoredInModelGeneration();
            }
        });
    }

    private void updateProps() {
        Collection<IsectInfo> isects = this.getP1().snaps;
        if (!isects.isEmpty()) {
            for (IsectInfo ii : isects) {
                UnitPoint3D pickPoint = new UnitPoint3D(ii.isectPoint, Geometry.LENGTH_UNIT);
                ImportedGeom pickGeom = (ImportedGeom)ii.obj;
                ((FloorExtractor3D)this.props()).setPickPoint(pickPoint, pickGeom);
                if (!((FloorExtractor3D)this.props()).canExtractFloor()) continue;
                break;
            }
        } else {
            CursorTool.Ray pickRay = this.getPickRay();
            UnitDouble workingZ = VentusApp.getApp().getData().floors.getActive().getWorkingZ();
            Plane3d workingPlane = new Plane3d(0.0, 0.0, 1.0, -workingZ.getValue(Geometry.LENGTH_UNIT));
            Point3d isect = Inter3D.rayPlaneIntersection(pickRay.begin, pickRay.dir, workingPlane, 1.0E-6);
            if (isect != null) {
                ((FloorExtractor3D)this.props()).setPickPoint(new UnitPoint3D(isect, Geometry.LENGTH_UNIT), null);
            } else {
                ((FloorExtractor3D)this.props()).setPickPoint(null, null);
            }
        }
    }

    protected static class Func
    extends AToolFunction<FloorExtractionTool> {
        protected Func() {
        }

        @Override
        public Cursor getCursor(FloorExtractionTool tool) {
            return null;
        }

        @Override
        public void mouseDragged(FloorExtractionTool tool, MouseEvent e) {
        }

        @Override
        public void mousePressed(FloorExtractionTool tool, MouseEvent e) {
        }

        @Override
        public void mouseMoved(FloorExtractionTool tool, MouseEvent e) {
            tool.updateProps();
        }

        @Override
        public void mouseReleased(FloorExtractionTool tool, MouseEvent e) {
            ((FloorExtractor3D)tool.props()).pause();
            tool.updateProps();
            if (((FloorExtractor3D)tool.props()).canExtractFloor()) {
                ((FloorExtractor3D)tool.props()).extractFloor(e.getComponent());
                tool.finish();
            }
            ((FloorExtractor3D)tool.props()).resume();
        }
    }
}

