/*
 * Decompiled with CFR 0.152.
 */
package ventus.mv.tools;

import java.awt.event.MouseEvent;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import ventus.builders.ATwoPointBuilder;
import ventus.mv.ModelView;
import ventus.mv.tools.NewPlanarGeomTool;

public abstract class ANewTwoPointTool<T extends ATwoPointBuilder>
extends NewPlanarGeomTool<T> {
    public ANewTwoPointTool(ModelView mv) {
        this(mv, new Func());
    }

    public ANewTwoPointTool(ModelView mv, Func<T> func) {
        super(mv, func);
    }

    protected abstract int getTolMode();

    @Override
    protected String getStatusMessage() {
        Point3d p1 = this.getLoc(((ATwoPointBuilder)this.props()).getP1());
        if (p1 == null) {
            p1 = this.getAddLoc();
        }
        if (!((ATwoPointBuilder)this.props()).isP1Committed()) {
            return this.getOnePointMessage(p1);
        }
        Point3d p2 = this.getLoc(((ATwoPointBuilder)this.props()).getP2());
        if (p2 == null) {
            return super.getStatusMessage();
        }
        return this.getTwoPointMessage(p1, p2);
    }

    protected abstract String getOnePointMessage(Point3d var1);

    protected abstract String getTwoPointMessage(Point3d var1, Point3d var2);

    protected static class Func<PropT extends ATwoPointBuilder>
    extends NewPlanarGeomTool.Func<PropT, ANewTwoPointTool<PropT>> {
        protected Func() {
        }

        @Override
        public void mousePressed(ANewTwoPointTool<PropT> tool, MouseEvent e) {
            Point2d point = tool.getPlanarAddLoc();
            if (point == null) {
                return;
            }
            if (!((ATwoPointBuilder)tool.props()).isP1Committed()) {
                ((ATwoPointBuilder)tool.props()).setP1(point, true);
            } else {
                ((ATwoPointBuilder)tool.props()).setP2(point, true);
            }
        }

        @Override
        public void mouseReleased(ANewTwoPointTool<PropT> tool, MouseEvent e) {
            boolean completed = false;
            ((ATwoPointBuilder)tool.props()).pause();
            Point2d point = tool.getPlanarAddLoc();
            if (tool.dragAboveTolerance(tool.getTolMode()) && point != null) {
                ((ATwoPointBuilder)tool.props()).setP2(point, true);
            }
            if (((ATwoPointBuilder)tool.props()).canComplete()) {
                ((ATwoPointBuilder)tool.props()).complete(e.getComponent());
                completed = true;
            }
            ((ATwoPointBuilder)tool.props()).resume();
            if (completed) {
                tool.finish();
            }
        }

        @Override
        public void mouseMoved(ANewTwoPointTool<PropT> tool, MouseEvent e) {
            Point2d point = tool.getPlanarAddLoc();
            if (point == null) {
                return;
            }
            if (((ATwoPointBuilder)tool.props()).isP1Committed()) {
                ((ATwoPointBuilder)tool.props()).setP2(point, false);
            } else {
                ((ATwoPointBuilder)tool.props()).setP1(point, false);
            }
        }
    }
}

