/*
 * Decompiled with CFR 0.152.
 */
package ventus.manip;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import javax.vecmath.Matrix4d;
import thunderheadeng.geometry.IMutableGeomSrc;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.IdentityXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.gui.Application;
import thunderheadeng.scene3d.manip.HandleMgr;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.tools.transform.ITransformMgr;
import thunderheadeng.scene3d.transformpreview.ITransformPreview;
import thunderheadeng.util.CachedValue;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.TransformAction;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.geom.IMerlinGeomSrc;
import ventus.mv.ModelView;
import ventus.mv.displays.GlobalDisplayMgr;
import ventus.mv.displays.IMerlinDispMgr;
import ventus.util.MerlinProps;
import ventus.util.MerlinUtil;

public abstract class ATransformManip
extends MerlinProps
implements ITransformMgr {
    public static final Object SEL_CHANGED = "ATransformManip.SEL_CHANGED";
    public static final Object OBJS_TRANSFORMED = "ATransformManip.OBJS_TRANSFORMED";
    public static final Object CANCELLED = "ATransformManip.CANCELLED";
    public static final Object TRANSFORM_CHANGED = "ATransformManip.TRANSFORM_CHANGED";
    public static final Object COPY_MODE_CHANGED = "ATransformManip.COPY_MODE_CHANGED";
    public static final Object RANDOMIZE_AGENT_COPIES = "RANDOMIZE_AGENT_COPIES";
    public static final Object INPUT_CHANGED = "ATransformManip.INPUT_CHANGED";
    private final ModelView d_mv;
    private final GlobalDisplayMgr d_dispMgr;
    private final GlobalDisplayMgr d_xformDispMgr;
    private Collection<? extends IMerlinObj> d_selection = Collections.emptySet();
    private Set<IMerlinGeomSrc> d_flattenedSel = Collections.emptySet();
    private boolean d_copyModeEnabled = false;
    private int d_copies = 1;
    private boolean d_randomizeAgentCopies = true;
    private final CachedValue<IDOF> d_dof = new CachedValue();
    private IntFunction<ITransform> d_getXform = i -> TransformUtil.IDENTITY;
    private final CachedValue<Boolean> d_isTransforming = new CachedValue();
    private final CachedValue<Boolean> d_canTransform = new CachedValue();
    private ITransformPreview d_xformPreview;

    protected abstract void reset();

    protected abstract String getActionName();

    public ATransformManip(ModelView mv, GlobalDisplayMgr dispMgr, GlobalDisplayMgr xformDispMgr) {
        this.d_dispMgr = dispMgr;
        this.d_mv = mv;
        this.d_xformDispMgr = xformDispMgr;
    }

    public void activate() {
        this.pause();
        this.setCopyMode(false);
        this.setNumCopies(1);
        VentusData md = VentusApp.getApp().getData();
        Set<IMerlinObj> sel = TransformAction.getValidObjs(md);
        this.setSelection(sel);
        this.resume();
    }

    public void deactivate() {
        this.setSelection(Collections.emptyList());
    }

    public void setSelection(Collection<? extends IMerlinObj> objs) {
        if (!this.lock()) {
            return;
        }
        this.d_selection = objs;
        this.d_flattenedSel = new IdentityHashSet<IMerlinGeomSrc>(TransformAction.getGeom(VentusApp.getAppData(), objs));
        this.d_isTransforming.clear();
        this.d_dof.clear();
        this.endPreview();
        this.firePropChanged(SEL_CHANGED);
        this.release();
    }

    public Collection<? extends IMerlinObj> getSelection() {
        return this.d_selection;
    }

    public void setNumCopies(int numCopies) {
        if (this.d_copies == numCopies || !this.lock()) {
            return;
        }
        assert (numCopies >= 1);
        this.d_copies = numCopies;
        this.firePropChanged(COPY_MODE_CHANGED);
        this.release();
    }

    public int getNumCopies() {
        return this.d_copies;
    }

    @Override
    public boolean getCopyMode() {
        return this.d_copyModeEnabled;
    }

    @Override
    public void setCopyMode(boolean copyMode) {
        if (copyMode == this.d_copyModeEnabled || !this.lock()) {
            return;
        }
        this.d_copyModeEnabled = copyMode;
        if (this.d_copyModeEnabled && this.d_copies < 1) {
            this.d_copies = 1;
        }
        if (this.d_xformPreview != null) {
            this.d_xformPreview.setCopyMode(copyMode);
        }
        this.firePropChanged(COPY_MODE_CHANGED);
        this.release();
    }

    public void setRandomizeAgentCopies(boolean randomize) {
        if (this.d_randomizeAgentCopies == randomize || !this.lock()) {
            return;
        }
        this.d_randomizeAgentCopies = randomize;
        this.firePropChanged(RANDOMIZE_AGENT_COPIES);
        this.release();
    }

    public boolean getRandomizeAgentCopies() {
        return this.d_randomizeAgentCopies;
    }

    @Override
    public void cancel() {
        this.localReset();
        this.firePropChanged(CANCELLED);
    }

    private void localReset() {
        this.d_dof.clear();
        this.d_getXform = i -> TransformUtil.IDENTITY;
        this.d_canTransform.clear();
        this.d_isTransforming.clear();
        this.reset();
        this.endPreview();
    }

    private void endPreview() {
        for (IMerlinDispMgr<?> dm : this.d_xformDispMgr.getManagers()) {
            dm.removeAll();
        }
        this.applyToScenes(scene -> scene.setTransform(null));
        if (this.d_xformPreview != null) {
            this.d_mv.setVisible(HandleMgr.FILTER_TYPE, true);
            this.d_xformPreview.end();
            this.d_xformPreview = null;
        }
    }

    @Override
    public void commit(Runnable postOp) {
        this.transform(Application.getApp().getActiveFrame(), postOp);
    }

    public void transform(Component c, final Runnable postOp) {
        if (this.d_selection.isEmpty()) {
            this.localReset();
            postOp.run();
            return;
        }
        final int numCopies = this.getCopyMode() ? this.getNumCopies() : 0;
        final TransformInfo[] xforms = new TransformInfo[numCopies > 0 ? numCopies : 1];
        for (int m = 0; m < xforms.length; ++m) {
            xforms[m] = this.d_getXform.apply(m).getInfo();
        }
        final String actionName = this.getActionName();
        final ArrayList<? extends IMerlinObj> objs = new ArrayList<IMerlinObj>(this.d_selection);
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(VentusApp app, VentusData data) {
                try (VentusData.WriteLock lock = data.lockWrite();){
                    String name = numCopies > 0 ? Intl.intl("Copy") + "/" + actionName : actionName;
                    Undo.begin(name);
                    Undo.insertUndoEntry_restoreSelection(data);
                    ArrayList newRooms = new ArrayList();
                    ArrayList toPostUpdate = new ArrayList();
                    TransformAction.transform(VentusApp.getApp(), data, newRooms::add, toPostUpdate::add, objs, numCopies, xforms);
                    data.updateTopology();
                    SchematicRoom.cleanup(data.getDomain(), newRooms);
                    Undo.end(data);
                }
                data.uiLater(() -> {
                    ATransformManip.this.localReset();
                    postOp.run();
                    ATransformManip.this.firePropChanged(OBJS_TRANSFORMED);
                });
            }
        };
        UIHook.run(c, "ATransformManip.transform", op, 4);
    }

    private void tryBegin() {
        if (this.d_xformPreview != null || !this.isTransforming() || !this.isTransformValid()) {
            return;
        }
        LinkedIdentityHashSet<IMutableGeomSrc> previewObjs = new LinkedIdentityHashSet<IMutableGeomSrc>(MerlinUtil.flatten(this.d_flattenedSel, IMutableGeomSrc.class));
        this.d_mv.setVisible(HandleMgr.FILTER_TYPE, false);
        this.d_xformPreview = this.d_dispMgr.getTransformPreview(this.d_xformDispMgr, (Collection<?>)previewObjs, this.d_copyModeEnabled);
    }

    @Override
    public boolean isTransforming() {
        return this.d_isTransforming.get(() -> {
            if (this.d_selection.isEmpty()) {
                return false;
            }
            ITransform xform = this.d_getXform.apply(0);
            return !xform.isIdentity();
        });
    }

    @Override
    public boolean isTransforming(Object obj) {
        return this.isTransforming() && !this.getCopyMode() && this.d_flattenedSel.contains(obj);
    }

    @Override
    public Object getProxySource(Object obj) {
        HandleMgr handleMgr;
        if (obj instanceof IHandle && (handleMgr = this.d_mv.getHandleMgr()).getCurrentHandles().contains(obj)) {
            return handleMgr.getCurrentSourceObj();
        }
        return obj;
    }

    @Override
    public IDOF getDOF() {
        return this.d_dof.get(() -> ATransformManip.getDOF(this.d_flattenedSel));
    }

    private static IDOF getDOF(Collection<? extends IMutableGeomSrc> geoms) {
        LinkedHashSet<IDOF> dofs = new LinkedHashSet<IDOF>();
        for (IMutableGeomSrc iMutableGeomSrc : geoms) {
            dofs.add(iMutableGeomSrc.getGeom().getDOF());
        }
        return IDOF.group(dofs);
    }

    @Override
    public void modify(IntFunction<ITransform> xform) {
        this.d_getXform = xform;
        this.d_isTransforming.clear();
        this.d_canTransform.clear();
        this.tryBegin();
        if (this.d_xformPreview != null) {
            IdentityXform xform0 = this.isTransformValid() ? this.d_getXform.apply(0) : TransformUtil.IDENTITY;
            Matrix4d mat = xform0.toMatrix(false);
            this.d_xformPreview.setTransform(mat);
            this.applyToScenes(scene -> scene.setTransform(mat));
        }
        this.firePropChanged(TRANSFORM_CHANGED);
    }

    @Override
    public void inputChanged() {
        this.d_isTransforming.clear();
        this.d_canTransform.clear();
        this.firePropChanged(INPUT_CHANGED);
    }

    private void applyToScenes(Consumer<ModelScene> function) {
        for (IMerlinDispMgr<?> dm : this.d_xformDispMgr.getManagers()) {
            dm.getScenes(function);
        }
    }

    @Override
    public boolean isTransformValid() {
        return this.d_canTransform.get(() -> {
            ITransform xform = this.d_getXform.apply(0);
            return !xform.isIdentity() && xform.isInvertible();
        });
    }
}

