/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui.value;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.Closeable;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.function.IntToDoubleFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.Graph;
import thunderheadeng.gui.LWSeries;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.format.UnitDoubleFormat;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiFormattedFld;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import ventus.Intl;
import ventus.data.value.Schedule;

public class ScheduleEditorPnl
extends guiPanel
implements Closeable {
    private static final long serialVersionUID = 1L;
    private final guiFormattedFld<UnitDouble> d_initValFld;
    private final Unit d_valUnit;
    private final guiComboBox<Schedule.ScheduleType> d_shapeCB;
    private final guiTable d_table;
    private final Graph d_graph;
    private LWSeries d_series;

    protected ScheduleEditorPnl(String propName, IUnitSrc timeUnit, ValueField<UnitDouble> valFld) {
        String[] headers = new String[]{Intl.intl("Time"), propName};
        guiTableEditor ed = new guiTableEditor(guiTableUtil.fixedColumnTable(headers, new Class[]{UnitDouble.class, UnitDouble.class}), 30);
        this.d_table = ed.getTable();
        this.d_table.setNullValuesAllowed(false);
        this.d_table.getColumnModel().getColumn(0).setCellEditor(new guiTable.UnitDoubleEditor(timeUnit.getUnit(), time -> time.get(NonSI.HOUR) <= 24.0, false));
        this.d_initValFld = valFld;
        this.d_initValFld.addValueChangeListener(e -> {
            if (!this.validateData(false, false)) {
                return;
            }
            this.updateSeries();
        });
        this.d_valUnit = ((UnitDoubleFormat)this.d_initValFld.getFormat()).getUnitType().getUnit();
        this.d_table.getColumnModel().getColumn(1).setCellEditor(new guiTable.UnitDoubleEditor(this.d_valUnit));
        this.d_shapeCB = guiUtil.newCombo(shape -> new Pair<String, Object>(shape.name, null), Arrays.stream(Schedule.ScheduleType.values()).filter(shape -> shape.hasEntries).collect(Collectors.toList()));
        this.d_shapeCB.addActionListener(e -> {
            if (!this.validateData(false, false)) {
                return;
            }
            this.updateSeries();
        });
        this.d_table.autoSizeColumns(500);
        this.d_table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.d_table.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.d_table.setPreferredScrollableViewportSize(new Dimension(this.d_table.getPreferredSize().width, Math.min(500, this.d_table.getPreferredSize().height)));
        this.d_table.getModel().addTableModelListener(e -> {
            if (!this.validateData(false, false)) {
                return;
            }
            this.updateSeries();
        });
        this.d_graph = new Graph();
        this.d_graph.setTitle(String.format(Intl.intl("%s over Time"), propName));
        this.d_graph.setAutoRangeX(true);
        this.d_graph.setAutoRangeY(true);
        this.d_graph.setLegendVisible(false);
        this.d_graph.setXTitle(String.format(Intl.intl("Time (%s)"), timeUnit.getUnit().toString()));
        if (this.d_valUnit.equals(Unit.ONE)) {
            this.d_graph.setYTitle(propName);
        } else {
            this.d_graph.setYTitle(String.format(Intl.intl("%1$s (%2$s)"), propName, this.d_valUnit.toString()));
        }
        guiPanel graphComp = new guiPanel();
        graphComp.add((Component)this.d_graph, "Center");
        graphComp.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        graphComp.setPreferredSize(new Dimension(ed.getPreferredSize().width * 3 / 2, 1));
        guiPanel paramsPanel = new guiPanel(new MigLayout("insets 0"));
        paramsPanel.add(new guiLabel(Intl.intl("Initial Value:")));
        paramsPanel.add(this.d_initValFld, "wrap");
        paramsPanel.add(new guiLabel(Intl.intl("Shape:")));
        paramsPanel.add(this.d_shapeCB, "wrap");
        this.setLayout(new MigLayout("insets 0, fill"));
        this.add((Component)paramsPanel, "wrap");
        this.add((Component)new TitleSeparator(Intl.intl("Timed Values")), "spanx, growx, wrap");
        this.add((Component)ed, "grow");
        this.add((Component)graphComp, "grow, push");
    }

    private UnitDouble getValue(int row) {
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
        Object val = model.getValueAt(row, 1);
        return (UnitDouble)val;
    }

    private void setValue(int row, UnitDouble value) {
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
        model.setValueAt(value, row, 1);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        Predicate<UnitDouble> filter = this.d_initValFld.getFilter();
        if (filter != null) {
            int col = 1;
            int numRows = this.d_table.getModel().getRowCount();
            for (int m = 0; m < numRows; ++m) {
                if (filter.test(this.getValue(m))) continue;
                if (showWarn) {
                    String msg = String.format(Intl.intl("Error in table at row %d, col %d:%n%s"), m + 1, col + 1, filter);
                    JOptionPane.showMessageDialog(this, msg, Intl.intl("Invalid Value"), 2);
                }
                return false;
            }
        }
        return true;
    }

    public void load(Schedule schedule) {
        if (schedule == null) {
            this.d_initValFld.setValue(null);
        } else {
            UnitDouble initValue = schedule.getInitialValue();
            Schedule.Entry[] entries = schedule.getEntries();
            this.d_initValFld.setValue(initValue);
            this.d_shapeCB.setSelectedItem((Object)schedule.type);
            guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
            for (int i = 0; i < entries.length; ++i) {
                Schedule.Entry entry = entries[i];
                model.setValueAt(entry.t, i, 0);
                this.setValue(i, entry.val.convert(this.d_valUnit));
            }
        }
        this.updateSeries();
        this.setModified(false);
    }

    public Schedule save() {
        UnitDouble initVal = this.d_initValFld.getValue();
        if (initVal == null) {
            return null;
        }
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
        int rows = model.getRowCount();
        TreeSet<Schedule.Entry> entries = new TreeSet<Schedule.Entry>();
        for (int i = 0; i < rows; ++i) {
            UnitDouble val;
            UnitDouble t = (UnitDouble)model.getValueAt(i, 0);
            if (t == null || (val = this.getValue(i)) == null) continue;
            entries.add(new Schedule.Entry(t, val));
        }
        if (!entries.isEmpty() && ((Schedule.Entry)entries.getFirst()).t.equals(new UnitDouble(0.0, SI.SECOND))) {
            initVal = ((Schedule.Entry)entries.getFirst()).val;
            entries.removeFirst();
        }
        Schedule.ScheduleType scheduleType = this.d_shapeCB.getSelectedItem();
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"TRAPEZOIDAL", "RECTANGULAR"}, (Schedule.ScheduleType)scheduleType, n)) {
            case 0 -> Schedule.newTrapezoidal(initVal, entries.toArray(new Schedule.Entry[0]));
            case 1 -> Schedule.newRectangular(initVal, entries.toArray(new Schedule.Entry[0]));
            default -> Schedule.newRectangular(initVal, entries.toArray(new Schedule.Entry[0]));
        };
    }

    private void updateSeries() {
        Schedule schedule;
        if (this.d_series != null) {
            this.d_graph.removeSeries(this.d_series);
            if (this.d_series.isOpen()) {
                this.d_series.close();
            }
        }
        if ((schedule = this.save()) == null) {
            return;
        }
        Supplier<IntStream> ixes = () -> IntStream.range(0, 2);
        Supplier<IntToDoubleFunction> x = () -> i -> i;
        Supplier<IntToDoubleFunction> y = () -> i -> 1.0;
        if (schedule.entries.length == 0) {
            ixes = () -> IntStream.range(0, 2);
            x = () -> i -> i == 0 ? 0.0 : 60.0;
            y = () -> i -> schedule.getInitialValue().getValue(this.d_valUnit);
        } else if (schedule.type == Schedule.ScheduleType.TRAPEZOIDAL) {
            ixes = () -> IntStream.range(0, schedule.entries.length + 1);
            x = () -> i -> i == 0 ? 0.0 : schedule.entries[i - 1].t.getValue(SI.SECOND);
            y = () -> i -> i == 0 ? schedule.getInitialValue().getValue(this.d_valUnit) : schedule.entries[i - 1].val.getValue(this.d_valUnit);
        } else if (schedule.type == Schedule.ScheduleType.RECTANGULAR) {
            ixes = () -> IntStream.range(0, schedule.entries.length * 2 + 2);
            x = () -> i -> {
                double tOff;
                int tix = (i + 1) / 2;
                double d = tOff = i % 2 == 0 ? 0.0 : 1.0E-6;
                double tBase = tix == 0 ? 0.0 : (tix < schedule.entries.length ? schedule.entries[tix - 1].t.getValue(SI.SECOND) : schedule.entries[schedule.entries.length - 1].t.getValue(SI.SECOND) * 1.05);
                return tBase - tOff;
            };
            y = () -> i -> {
                int vix = i / 2;
                if (vix == 0) {
                    return schedule.getInitialValue().getValue(this.d_valUnit);
                }
                if (vix < schedule.entries.length) {
                    return schedule.entries[vix - 1].val.getValue(this.d_valUnit);
                }
                return schedule.entries[schedule.entries.length - 1].val.getValue(this.d_valUnit);
            };
        } else assert (false) : "Schedule is not a valid type.";
        this.d_series = new LWSeries(ixes, x, y, "", Color.BLUE, 14, 0, 1);
        this.d_series.open();
        this.d_graph.addSeries(this.d_series);
        EventQueue.invokeLater(() -> this.d_graph.repaint());
    }

    @Override
    public void close() {
        if (this.d_series != null && this.d_series.isOpen()) {
            this.d_series.close();
        }
    }
}

