/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui.stat;

import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.LogNormCurve;
import thunderheadeng.util.stat.StdNormCurve;
import thunderheadeng.util.stat.UniformCurve;
import ventus.Intl;
import ventus.data.stat.CurveUtil;
import ventus.gui.guiUtil;

public class guiCurveUtil {
    public static String format(IDistributedVal<UnitDouble> curve) {
        return guiCurveUtil.format(curve, -1);
    }

    public static String format(IDistributedVal<UnitDouble> curve, int unitType) {
        if (curve instanceof StdNormCurve) {
            StdNormCurve sncurve = (StdNormCurve)curve;
            return String.format("u=%s s=%s [%s, %s]", guiUtil.format(sncurve.getAvg(), unitType), guiUtil.format(sncurve.getStdDev(), unitType), guiUtil.format(sncurve.getMin(), unitType), guiUtil.format(sncurve.getMax(), unitType));
        }
        if (curve instanceof UniformCurve) {
            UniformCurve ucurve = (UniformCurve)curve;
            return String.format("[%s, %s]", guiUtil.format(ucurve.getMin(), unitType), guiUtil.format(ucurve.getMax(), unitType));
        }
        if (curve instanceof ConstantCurve) {
            ConstantCurve ccurve = (ConstantCurve)curve;
            return guiUtil.format(ccurve.getMax(), unitType);
        }
        if (curve instanceof LogNormCurve) {
            LogNormCurve lcurve = (LogNormCurve)curve;
            return String.format("u=%s s=%s [%s, %s]", guiUtil.format(lcurve.getAvg(), unitType), guiUtil.format(lcurve.getStdDev(), unitType), guiUtil.format(lcurve.getMin(), unitType), guiUtil.format(lcurve.getMax(), unitType));
        }
        if (curve instanceof IUrn) {
            CurveUtil.UrnStats urnStats = CurveUtil.getUrnStats((IUrn)curve, unitType);
            return String.format("[%s, %s] ", guiUtil.format(urnStats.min, unitType), guiUtil.format(urnStats.max, unitType)) + Intl.intl("discrete");
        }
        return "";
    }
}

