/*
 * Decompiled with CFR 0.152.
 */
package ventus.gui.stat;

import java.util.function.Predicate;
import java.util.function.Supplier;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.value.AValEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.stat.StdNormCurve;
import ventus.Intl;
import ventus.gui.MerlinValueFields;
import ventus.unitsystem.SIUS;

public class NormEditor
extends AValEditor<StdNormCurve> {
    private static final long serialVersionUID = -6283225512750292888L;
    private final ValueField<UnitDouble> d_min;
    private final ValueField<UnitDouble> d_max;
    private final ValueField<UnitDouble> d_mean;
    private final ValueField<UnitDouble> d_stdDev;

    public NormEditor(int unitType) {
        this(unitType, UnitDoubleVR.above(0.0, SIUS.unit(unitType), true));
    }

    public NormEditor(int unitType, UnitDoubleVR range) {
        super(StdNormCurve.class);
        Supplier<ValueField> fieldFactory = () -> this.registerEd(MerlinValueFields.udFld(new UnitDouble(0.0, SIUS.unit(unitType)), (Predicate<UnitDouble>)range, unitType));
        this.d_min = fieldFactory.get();
        this.d_max = fieldFactory.get();
        this.d_mean = fieldFactory.get();
        this.d_stdDev = fieldFactory.get();
        guiLabel mean = new guiLabel(Intl.intl("Mean (\u03bc):"));
        mean.setToolTipText("The mean or average of this normal distribution.");
        guiLabel stDev = new guiLabel(Intl.intl("Std. Dev. (\u03c3):"));
        stDev.setToolTipText("The standard deviation of this normal distribution.");
        GridBagHelper gb = new GridBagHelper(this, false);
        gb.addRow(Intl.intl("Min:"), this.d_min, Intl.intl("Max:"), this.d_max);
        gb.addRow(mean, this.d_mean, stDev, this.d_stdDev);
        gb.finalizeRows();
    }

    @Override
    public boolean isLive() {
        return true;
    }

    @Override
    public String formatNonLiveValue() {
        return "";
    }

    @Override
    public void add(GridBagHelper gb) {
        gb.add(this, 1.0);
    }

    @Override
    public StdNormCurve saveValue(Mediator mediator) {
        return new StdNormCurve((UnitDouble)this.d_min.getValue(), (UnitDouble)this.d_max.getValue(), (UnitDouble)this.d_mean.getValue(), (UnitDouble)this.d_stdDev.getValue());
    }

    @Override
    public void loadValue(StdNormCurve snc) {
        this.d_min.setValue(snc.getMin());
        this.d_max.setValue(snc.getMax());
        this.d_mean.setValue(snc.getAvg());
        this.d_stdDev.setValue(snc.getStdDev());
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        UnitDouble max;
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        UnitDouble min = (UnitDouble)this.d_min.getValue();
        if (min.sub(max = (UnitDouble)this.d_max.getValue()).getValueNoUnit() > 0.0) {
            if (showWarn) {
                guiDialog.showInvalidEntryMessage(this, Intl.intl("Req: Min <= Max"));
            }
            return false;
        }
        UnitDouble mean = (UnitDouble)this.d_mean.getValue();
        if (min.sub(mean).getValueNoUnit() > 0.0 || mean.sub(max).getValueNoUnit() > 0.0) {
            if (showWarn) {
                guiDialog.showInvalidEntryMessage(this, Intl.intl("Req: Min <= Mean <= Max"));
            }
            return false;
        }
        UnitDouble stdDev = (UnitDouble)this.d_stdDev.getValue();
        if (stdDev.getValueNoUnit() < 0.0) {
            if (showWarn) {
                guiDialog.showInvalidEntryMessage(this, Intl.intl("Req: StdDev >= 0"));
            }
            return false;
        }
        return true;
    }
}

